/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableItemListener;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CommentTableWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textComments;

    public CommentTableWizard(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getComments(String schemaName, String tableName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTableComment());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TABLE_NAME").setString(tableName);
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("comments").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    private void init() {
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboTables.addItemListener(new TableItemListener(){

            public void itemChanged(OracleTableInfo info) {
                CommentTableWizard.this.textComments.setText(CommentTableWizard.this.getComments(info.getSchema().getName(), info.getName()));
            }
        });
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CommentTableWizard.this.textComments.requestFocusInWindow();
            }
        });
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CommentTableWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CommentTableWizard-tab-title");
    }

    public String getSqlCode() {
        return "COMMENT ON TABLE " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + " IS '" + StringUtil.replaceString((String)this.textComments.getText(), (String)"'", (String)"''") + "'";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textComments = new TextField();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("comment-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 274, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textComments, -1, 274, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textComments, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

