/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.DirectoryComboBoxModel;
import pl.mpak.orbada.oracle.gui.wizards.TableColumnDefinitionWizard;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateExternalTableWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private TableColumnDefinitionWizard columnDefinition;
    private JButton buttonAddRow;
    private JButton buttonRemoveRow;
    private JCheckBox checkUsingCLOB;
    private Action cmAddRow;
    private Action cmRemoveRow;
    private JComboBox comboDirectory;
    private JComboBox comboLoader;
    private JComboBox comboLocation;
    private JComboBox comboReject;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane tab;
    private Table tableLocalizations;
    private TextField textName;
    private TextArea textParameters;

    public CreateExternalTableWizard(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableLocalizations.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{this.stringManager.getString("catalog"), this.stringManager.getString("file-name")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.columnDefinition = new TableColumnDefinitionWizard(this.database, "EXTERNAL");
        this.tab.addTab(this.columnDefinition.getTabTitle(), (Component)((Object)this.columnDefinition));
        this.comboDirectory.setModel(new DirectoryComboBoxModel(this.database));
        this.comboLocation.setModel(new DirectoryComboBoxModel(this.database));
        this.tableLocalizations.setRowHeight(20);
        this.tableLocalizations.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.comboLocation));
    }

    public void wizardShow() {
        this.columnDefinition.wizardShow();
        ((DirectoryComboBoxModel)this.comboDirectory.getModel()).change();
        ((DirectoryComboBoxModel)this.comboLocation.getModel()).change();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateExternalTableWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateExternalTableWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String locations = "";
        for (int i = 0; i < this.tableLocalizations.getRowCount(); ++i) {
            Object directory = this.tableLocalizations.getValueAt(i, 0);
            Object patch = this.tableLocalizations.getValueAt(i, 1);
            if (directory == null) continue;
            if (!StringUtil.isEmpty((String)locations)) {
                locations = locations + ",\n";
            }
            locations = this.comboDirectory.getSelectedItem().toString().equals(directory.toString()) ? locations + "    '" + patch + "'" : locations + "    " + SQLUtil.createSqlName((String)directory.toString()) + ": " + "'" + patch + "'";
        }
        return "CREATE TABLE " + SQLUtil.createSqlName((String)this.schemaName) + "." + this.textName.getText() + " (\n" + this.columnDefinition.getSqlCode() + "\n)\n" + "ORGANIZATION EXTERNAL (\n" + "  TYPE " + this.comboLoader.getSelectedItem().toString() + "\n" + (this.comboDirectory.getSelectedItem() != null ? "  DEFAULT DIRECTORY " + this.comboDirectory.getSelectedItem().toString() + "\n" : "") + "  ACCESS PARAMETERS" + (this.checkUsingCLOB.isSelected() ? " USING CLOB" : "") + " (\n" + "    " + this.textParameters.getText() + "\n" + "  )\n" + "  LOCATION (\n" + locations + "\n" + "  )\n" + ")\n" + "REJECT LIMIT " + ((JTextField)this.comboReject.getEditor().getEditorComponent()).getText() + "\n" + "/";
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.comboLocation = new JComboBox();
        this.tab = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel2 = new JLabel();
        this.comboDirectory = new JComboBox();
        this.jLabel5 = new JLabel();
        this.comboLoader = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textParameters = new TextArea();
        this.checkUsingCLOB = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.tableLocalizations = new Table();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.comboReject = new JComboBox();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add8.gif"));
        this.cmAddRow.setText(this.stringManager.getString("cmAdd-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateExternalTableWizard.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/remove8.gif"));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemove-dd"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateExternalTableWizard.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.tab.setFocusable(false);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("table-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("default-catalog-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("loader-mechanism-dd"));
        this.comboLoader.setModel(new DefaultComboBoxModel<String>(new String[]{"ORACLE_LOADER", "ORACLE_DATAPUMP"}));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("loading-parameters-dd"));
        this.textParameters.setColumns(20);
        this.textParameters.setRows(5);
        this.jScrollPane1.setViewportView((Component)this.textParameters);
        this.checkUsingCLOB.setText(this.stringManager.getString("use-subquery-for-clob"));
        this.jScrollPane2.setMinimumSize(new Dimension(24, 100));
        this.jScrollPane2.setViewportView((Component)this.tableLocalizations);
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("data-localizations-dd"));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.stringManager.getString("throw-lines-dd"));
        this.comboReject.setEditable(true);
        this.comboReject.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "UNLIMITED"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboReject, -2, 138, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonRemoveRow, -1, -1, Short.MAX_VALUE).addComponent(this.buttonAddRow, -2, 60, -2))).addComponent(this.comboDirectory, -2, 222, -2).addComponent((Component)this.textName, -2, 222, -2).addComponent(this.comboLoader, -2, 222, -2).addComponent(this.checkUsingCLOB).addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboDirectory, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboLoader, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUsingCLOB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow)).addComponent(this.jLabel7).addComponent(this.jScrollPane2, -2, 103, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.comboReject, -2, -1, -2)).addGap(23, 23, 23)));
        this.tab.addTab(this.stringManager.getString("basic"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 546, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab).addContainerGap()));
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableLocalizations.getValueAt(this.tableLocalizations.getRowCount() - 1, 0) != null) {
            ((DefaultTableModel)this.tableLocalizations.getModel()).addRow(new Object[]{null, null});
        }
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableLocalizations.getRowCount() > 1) {
            this.tableLocalizations.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
            ((DefaultTableModel)this.tableLocalizations.getModel()).removeRow(this.tableLocalizations.getRowCount() - 1);
        }
    }
}

