/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TablespaceComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateIndexesFromConstraintsWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private JCheckBox checkDefaultTablespace;
    private JComboBox comboTables;
    private JComboBox comboTablespace;
    private JLabel jLabel2;
    private JLabel jLabel8;

    public CreateIndexesFromConstraintsWizard(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboTablespace.setModel(new TablespaceComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
        ((TablespaceComboBoxModel)this.comboTablespace.getModel()).change();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateIndexesFromConstraintsWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateIndexesFromConstraintsWizard-tab-title");
    }

    public String getSqlCode() {
        return "begin\n  for c in (select cc.owner, cc.constraint_name, cc.table_name, cc.column_name\n              from ALL_IND_COLUMNS IC, ALL_CONS_COLUMNS CC, ALL_CONSTRAINTS C\n             where cc.owner = '" + this.schemaName + "'\n" + "               and cc.table_name = '" + this.comboTables.getSelectedItem().toString() + "'\n" + "               and ic.index_owner(+) = cc.owner\n" + "               and ic.table_name(+) = cc.table_name\n" + "               and ic.column_name(+) = cc.column_name\n" + "               and c.owner = cc.owner\n" + "               and c.constraint_type = 'R'\n" + "               and c.constraint_name = cc.constraint_name\n" + "               and ic.index_name is null) loop\n" + "     begin\n" + "       execute immediate \n" + "         'CREATE INDEX '||substr(c.constraint_name, 1, 28)||'_I ON \"'||c.owner||'\".\"'||c.table_name||'\" ('||c.column_name||')" + (!this.checkDefaultTablespace.isSelected() ? " TABLESPACE " + this.comboTablespace.getSelectedItem().toString() : "") + "';\n" + "     exception\n" + "       when others then\n" + "         dbms_output.put_line(c.table_name||'.'||c.constraint_name||': '||SQLErrM(SQLCode));\n" + "     end;\n" + "   end loop;\n" + "end;";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel8 = new JLabel();
        this.comboTablespace = new JComboBox();
        this.checkDefaultTablespace = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.stringManager.getString("tablespace-dd"));
        this.checkDefaultTablespace.setSelected(true);
        this.checkDefaultTablespace.setText(this.stringManager.getString("default"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, GroupLayout.Alignment.LEADING, -1, 115, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboTables, 0, 311, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.comboTablespace, 0, 248, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDefaultTablespace))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.comboTablespace, -2, -1, -2).addComponent(this.checkDefaultTablespace)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

