/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableItemListener;
import pl.mpak.orbada.oracle.services.OracleTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateTableTriggerWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private boolean nameChanged = false;
    private Template template;
    private JButton buttonMoveAllRight;
    private JButton buttonMoveAllRight1;
    private JButton buttonMoveRight;
    private JButton buttonMoveRight1;
    private JCheckBox checkDelete;
    private JCheckBox checkInsert;
    private JCheckBox checkUpdate;
    private Action cmMoveAllLeft;
    private Action cmMoveAllRight;
    private Action cmMoveLeft;
    private Action cmMoveRight;
    private JComboBox comboLevel;
    private JComboBox comboTables;
    private JComboBox comboType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelSelectedColumns;
    private JList listSelectedColumns;
    private JList listTableColumns;
    private TextField textName;
    private TextField textNewRef;
    private TextField textOldRef;
    private TextField textWhen;

    public CreateTableTriggerWizard(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.listTableColumns.setModel(new DefaultListModel());
        this.listSelectedColumns.setModel(new DefaultListModel());
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboTables.addItemListener(new TableItemListener(){

            public void itemChanged(OracleTableInfo info) {
                if (!CreateTableTriggerWizard.this.nameChanged) {
                    CreateTableTriggerWizard.this.updateName();
                }
                CreateTableTriggerWizard.this.updateTableColumns(info);
            }
        });
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(OracleTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(OracleTemplatesSettingsProvider.setTrigger, "oracle-trigger"));
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
    }

    private void updateMoveActions() {
        this.cmMoveRight.setEnabled(this.checkUpdate.isSelected() && this.listTableColumns.getSelectedValue() != null);
        this.cmMoveAllRight.setEnabled(this.checkUpdate.isSelected() && this.listTableColumns.getModel().getSize() > 0);
        this.cmMoveLeft.setEnabled(this.checkUpdate.isSelected() && this.listSelectedColumns.getSelectedValue() != null);
        this.cmMoveAllLeft.setEnabled(this.checkUpdate.isSelected() && this.listSelectedColumns.getModel().getSize() > 0);
    }

    private void updateTableColumns(OracleTableInfo ti) {
        DefaultListModel model = (DefaultListModel)this.listSelectedColumns.getModel();
        model.removeAllElements();
        model = (DefaultListModel)this.listTableColumns.getModel();
        model.removeAllElements();
        DbObjectIdentified list = ti.getObjectInfo("/COLUMNS");
        if (list instanceof DbObjectContainer) {
            for (DbObjectIdentified i : ((DbObjectContainer)list).objectsArray(true)) {
                model.addElement(i);
            }
        }
        this.updateMoveActions();
    }

    private void updateName() {
        String idu = "";
        if (this.comboType.getSelectedIndex() == 0) {
            idu = idu + "_B";
        } else if (this.comboType.getSelectedIndex() == 1) {
            idu = idu + "_A";
        }
        if (this.checkInsert.isSelected()) {
            idu = idu + "_NEW";
        }
        if (this.checkDelete.isSelected()) {
            idu = idu + "_DEL";
        }
        if (this.checkUpdate.isSelected()) {
            idu = idu + "_UPD";
        }
        this.textName.setText(this.comboTables.getSelectedItem().toString() + idu + "_TRG");
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateTableTriggerWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateTableTriggerWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String idu = "";
        if (this.checkInsert.isSelected()) {
            idu = idu + " INSERT";
        }
        if (this.checkDelete.isSelected()) {
            if (!StringUtil.isEmpty((String)idu)) {
                idu = idu + " OR";
            }
            idu = idu + " DELETE";
        }
        if (this.checkUpdate.isSelected()) {
            if (!StringUtil.isEmpty((String)idu)) {
                idu = idu + " OR";
            }
            idu = idu + " UPDATE";
            DefaultListModel sel = (DefaultListModel)this.listSelectedColumns.getModel();
            if (sel.getSize() > 0) {
                idu = idu + " OF ";
                for (int i = 0; i < sel.getSize(); ++i) {
                    if (i > 0) {
                        idu = idu + ", ";
                    }
                    idu = idu + sel.getElementAt(i);
                }
            }
        }
        idu = idu + " ON " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString());
        String ref = "";
        if (!StringUtil.isEmpty((String)this.textOldRef.getText())) {
            ref = ref + " OLD AS " + this.textOldRef.getText();
        }
        if (!StringUtil.isEmpty((String)this.textNewRef.getText())) {
            ref = ref + " NEW AS " + this.textNewRef.getText();
        }
        String type = "  " + (this.comboType.getSelectedIndex() == 0 ? "BEFORE" : "AFTER") + idu + (!StringUtil.isEmpty((String)ref) ? "\n  REFERENCING" + ref : "") + (this.comboLevel.getSelectedIndex() == 0 ? "\n  FOR EACH ROW" : "") + (!StringUtil.isEmpty((String)this.textWhen.getText()) ? "\n  WHEN (" + this.textWhen.getText() + ")" : "");
        if (this.template == null) {
            return "CREATE TRIGGER " + this.textName.getText() + "\n" + type + "\n" + "BEGIN\n" + "  NULL;\n" + "END;";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", this.textName.getText());
        map.put("&type", type);
        map.put("&body", "  NULL;");
        map.put("&description", "");
        return this.template.expand(map);
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmMoveRight = new Action();
        this.cmMoveAllRight = new Action();
        this.cmMoveLeft = new Action();
        this.cmMoveAllLeft = new Action();
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel4 = new JLabel();
        this.comboLevel = new JComboBox();
        this.jLabel5 = new JLabel();
        this.comboType = new JComboBox();
        this.checkInsert = new JCheckBox();
        this.checkDelete = new JCheckBox();
        this.checkUpdate = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.textNewRef = new TextField();
        this.jLabel7 = new JLabel();
        this.textOldRef = new TextField();
        this.jLabel8 = new JLabel();
        this.textWhen = new TextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listTableColumns = new JList();
        this.buttonMoveRight = new JButton();
        this.buttonMoveAllRight = new JButton();
        this.buttonMoveRight1 = new JButton();
        this.buttonMoveAllRight1 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.listSelectedColumns = new JList();
        this.labelSelectedColumns = new JLabel();
        this.cmMoveRight.setActionCommandKey("cmMoveRight");
        this.cmMoveRight.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_right.gif"));
        this.cmMoveRight.setText(this.stringManager.getString("cmMoveRight-text"));
        this.cmMoveRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateTableTriggerWizard.this.cmMoveRightActionPerformed(evt);
            }
        });
        this.cmMoveAllRight.setActionCommandKey("cmMoveAllRight");
        this.cmMoveAllRight.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_all_right.gif"));
        this.cmMoveAllRight.setText(this.stringManager.getString("cmMoveAllRight-text"));
        this.cmMoveAllRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateTableTriggerWizard.this.cmMoveAllRightActionPerformed(evt);
            }
        });
        this.cmMoveLeft.setActionCommandKey("cmMoveLeft");
        this.cmMoveLeft.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_left.gif"));
        this.cmMoveLeft.setText(this.stringManager.getString("cmMoveLeft-text"));
        this.cmMoveLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateTableTriggerWizard.this.cmMoveLeftActionPerformed(evt);
            }
        });
        this.cmMoveAllLeft.setActionCommandKey("cmMoveAllLeft");
        this.cmMoveAllLeft.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_all_left.gif"));
        this.cmMoveAllLeft.setText(this.stringManager.getString("cmMoveAllLeft-text"));
        this.cmMoveAllLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateTableTriggerWizard.this.cmMoveAllLeftActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("trigger-name-dd"));
        this.textName.setText("_TRG");
        this.textName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                CreateTableTriggerWizard.this.textNameKeyPressed(evt);
            }
        });
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("execution-range-dd"));
        this.comboLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"Dla ka\u017cdego wiersza (ROW)", "Dla polecenia SQL (STATEMENT)"}));
        this.comboLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateTableTriggerWizard.this.comboLevelItemStateChanged(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("trigger-type-dd"));
        this.comboType.setModel(new DefaultComboBoxModel<String>(new String[]{"Przed aktualizacj\u0105 danych (BEFORE)", "Po aktualizacji danych (AFTER)"}));
        this.comboType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateTableTriggerWizard.this.comboTypeItemStateChanged(evt);
            }
        });
        this.checkInsert.setText(this.stringManager.getString("inserting"));
        this.checkInsert.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CreateTableTriggerWizard.this.checkInsertStateChanged(evt);
            }
        });
        this.checkDelete.setText(this.stringManager.getString("deleting"));
        this.checkDelete.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CreateTableTriggerWizard.this.checkDeleteStateChanged(evt);
            }
        });
        this.checkUpdate.setText(this.stringManager.getString("updating"));
        this.checkUpdate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CreateTableTriggerWizard.this.checkUpdateStateChanged(evt);
            }
        });
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("reference-new-dd"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("reference-old-dd"));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.stringManager.getString("only-when-dd"));
        this.jLabel1.setText(this.stringManager.getString("available-columns-dd"));
        this.listTableColumns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CreateTableTriggerWizard.this.listTableColumnsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listTableColumns);
        this.buttonMoveRight.setAction((javax.swing.Action)this.cmMoveRight);
        this.buttonMoveRight.setHideActionText(true);
        this.buttonMoveRight.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveRight.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveAllRight.setAction((javax.swing.Action)this.cmMoveAllRight);
        this.buttonMoveAllRight.setHideActionText(true);
        this.buttonMoveAllRight.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveAllRight.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveRight1.setAction((javax.swing.Action)this.cmMoveLeft);
        this.buttonMoveRight1.setHideActionText(true);
        this.buttonMoveRight1.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveRight1.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveAllRight1.setAction((javax.swing.Action)this.cmMoveAllLeft);
        this.buttonMoveAllRight1.setHideActionText(true);
        this.buttonMoveAllRight1.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveAllRight1.setPreferredSize(new Dimension(50, 23));
        this.listSelectedColumns.setEnabled(false);
        this.listSelectedColumns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CreateTableTriggerWizard.this.listSelectedColumnsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.listSelectedColumns);
        this.labelSelectedColumns.setText(this.stringManager.getString("selected-columns-dd"));
        this.labelSelectedColumns.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 177, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonMoveAllRight1, -2, 38, -2).addComponent(this.buttonMoveRight1, -2, 38, -2).addComponent(this.buttonMoveAllRight, -2, 38, -2).addComponent(this.buttonMoveRight, -2, 38, -2))).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 182, Short.MAX_VALUE).addComponent(this.labelSelectedColumns))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboLevel, 0, 278, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 278, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 278, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textWhen, -1, 278, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textOldRef, -1, 278, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textNewRef, -1, 278, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkInsert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUpdate)).addComponent(this.comboType, 0, 278, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkInsert).addComponent(this.checkDelete).addComponent(this.checkUpdate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textNewRef, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.textOldRef, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent((Component)this.textWhen, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labelSelectedColumns)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 110, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(240, 240, 240).addComponent(this.buttonMoveRight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveAllRight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveRight1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveAllRight1, -2, -1, -2))).addContainerGap()));
    }

    private void textNameKeyPressed(KeyEvent evt) {
        this.nameChanged = true;
    }

    private void checkInsertStateChanged(ChangeEvent evt) {
        if (!this.nameChanged) {
            this.updateName();
        }
    }

    private void checkDeleteStateChanged(ChangeEvent evt) {
        if (!this.nameChanged) {
            this.updateName();
        }
    }

    private void checkUpdateStateChanged(ChangeEvent evt) {
        if (!this.nameChanged) {
            this.updateName();
        }
        this.listSelectedColumns.setEnabled(this.checkUpdate.isSelected());
        this.labelSelectedColumns.setEnabled(this.checkUpdate.isSelected());
        this.updateMoveActions();
    }

    private void comboLevelItemStateChanged(ItemEvent evt) {
        this.textWhen.setEnabled(this.comboLevel.getSelectedIndex() == 0);
    }

    private void comboTypeItemStateChanged(ItemEvent evt) {
        if (!this.nameChanged) {
            this.updateName();
        }
    }

    private void listTableColumnsValueChanged(ListSelectionEvent evt) {
        this.updateMoveActions();
    }

    private void listSelectedColumnsValueChanged(ListSelectionEvent evt) {
        this.updateMoveActions();
    }

    private void cmMoveRightActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedColumns.getModel();
        DefaultListModel tab = (DefaultListModel)this.listTableColumns.getModel();
        sel.addElement(this.listTableColumns.getSelectedValue());
        tab.removeElement(this.listTableColumns.getSelectedValue());
        this.updateMoveActions();
    }

    private void cmMoveLeftActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedColumns.getModel();
        DefaultListModel tab = (DefaultListModel)this.listTableColumns.getModel();
        tab.addElement(this.listSelectedColumns.getSelectedValue());
        sel.removeElement(this.listSelectedColumns.getSelectedValue());
        this.updateMoveActions();
    }

    private void cmMoveAllRightActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedColumns.getModel();
        DefaultListModel tab = (DefaultListModel)this.listTableColumns.getModel();
        for (int i = 0; i < tab.getSize(); ++i) {
            sel.addElement(tab.get(i));
        }
        tab.removeAllElements();
        this.updateMoveActions();
    }

    private void cmMoveAllLeftActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedColumns.getModel();
        DefaultListModel tab = (DefaultListModel)this.listTableColumns.getModel();
        for (int i = 0; i < sel.getSize(); ++i) {
            tab.addElement(sel.get(i));
        }
        sel.removeAllElements();
        this.updateMoveActions();
    }
}

