/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.wizards.TableColumnDefinitionWizard;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateTemporaryTableWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private TableColumnDefinitionWizard columnDefinition;
    private ButtonGroup buttonGroup1;
    private JRadioButton checkSession;
    private JRadioButton checkTransaction;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTabbedPane tab;
    private TextField textComment;
    private TextField textName;

    public CreateTemporaryTableWizard(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.columnDefinition = new TableColumnDefinitionWizard(this.database, "TEMPORARY");
        this.tab.addTab(this.columnDefinition.getTabTitle(), (Component)((Object)this.columnDefinition));
    }

    public void wizardShow() {
        this.columnDefinition.wizardShow();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateTemporaryTableWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateTemporaryTableWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String pks = this.columnDefinition.getSqlCodePk(this.schemaName, this.textName.getText());
        String comments = this.columnDefinition.getSqlCodeComments(this.schemaName, this.textName.getText());
        return "CREATE GLOBAL TEMPORARY TABLE " + SQLUtil.createSqlName((String)this.schemaName) + "." + this.textName.getText() + " (\n" + this.columnDefinition.getSqlCode() + "\n) ON COMMIT" + (this.checkTransaction.isSelected() ? " DELETE ROWS" : "") + (this.checkSession.isSelected() ? " PRESERVE ROWS" : "") + "\n/" + (!StringUtil.isEmpty((String)pks) ? "\n" + pks : "") + (!StringUtil.isEmpty((String)this.textComment.getText()) ? "\nCOMMENT ON TABLE " + SQLUtil.createSqlName((String)this.schemaName) + "." + this.textName.getText() + " IS '" + this.textComment.getText() + "'\n/" : "") + (!StringUtil.isEmpty((String)comments) ? "\n" + comments : "");
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tab = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel4 = new JLabel();
        this.textComment = new TextField();
        this.checkTransaction = new JRadioButton();
        this.checkSession = new JRadioButton();
        this.tab.setFocusable(false);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("table-name-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("comment-dd"));
        this.buttonGroup1.add(this.checkTransaction);
        this.checkTransaction.setSelected(true);
        this.checkTransaction.setText(this.stringManager.getString("records-exist-in-the-open-transaction"));
        this.buttonGroup1.add(this.checkSession);
        this.checkSession.setText(this.stringManager.getString("records-exist-only-when-there-is-a-session"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -2, 222, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkTransaction).addComponent((Component)this.textComment, -1, 410, Short.MAX_VALUE).addComponent(this.checkSession)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textComment, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkTransaction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSession).addContainerGap(144, Short.MAX_VALUE)));
        this.tab.addTab(this.stringManager.getString("basic"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 580, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }
}

