/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.oracle.gui.util.SequenceComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableColumnComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableItemListener;
import pl.mpak.orbada.oracle.services.OracleTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateTriggerPKColumnWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private boolean nameChanged = false;
    private Template template;
    private JComboBox comboColumns;
    private JComboBox comboSequences;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private TextField textName;

    public CreateTriggerPKColumnWizard(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrimaryKeyColumn(String schemaName, String tableName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTablePrimaryKey());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TABLE_NAME").setString(tableName);
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("column_name").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return null;
    }

    private void init() {
        this.comboColumns.setModel(new TableColumnComboBoxModel(this.database));
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboSequences.setModel(new SequenceComboBoxModel(this.database));
        this.comboTables.addItemListener(new TableItemListener(){

            public void itemChanged(OracleTableInfo info) {
                int i;
                ((TableColumnComboBoxModel)CreateTriggerPKColumnWizard.this.comboColumns.getModel()).change(info.getSchema().getName(), info.getName());
                String columnName = CreateTriggerPKColumnWizard.this.getPrimaryKeyColumn(info.getSchema().getName(), info.getName());
                if (columnName != null) {
                    for (i = 0; i < CreateTriggerPKColumnWizard.this.comboColumns.getItemCount(); ++i) {
                        if (!CreateTriggerPKColumnWizard.this.comboColumns.getItemAt(i).equals(columnName)) continue;
                        CreateTriggerPKColumnWizard.this.comboColumns.setSelectedIndex(i);
                        break;
                    }
                }
                for (i = 0; i < CreateTriggerPKColumnWizard.this.comboSequences.getItemCount(); ++i) {
                    if (!CreateTriggerPKColumnWizard.this.comboSequences.getItemAt(i).equals(info.getName() + "_SEQ") && !CreateTriggerPKColumnWizard.this.comboSequences.getItemAt(i).equals("ID_" + info.getName()) && CreateTriggerPKColumnWizard.this.comboSequences.getItemAt(i).toString().toUpperCase().indexOf(info.getName().toUpperCase()) < 0) continue;
                    CreateTriggerPKColumnWizard.this.comboSequences.setSelectedIndex(i);
                    break;
                }
                if (!CreateTriggerPKColumnWizard.this.nameChanged) {
                    CreateTriggerPKColumnWizard.this.textName.setText(info.getName() + "_NEW_TRG");
                }
            }
        });
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(OracleTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(OracleTemplatesSettingsProvider.setTrigger, "oracle-trigger"));
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((SequenceComboBoxModel)this.comboSequences.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateTriggerPKColumnWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateTriggerPKColumnWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String body = String.format("  IF :NEW.%1$s IS NULL THEN\n    SELECT %2$s.NEXTVAL INTO :NEW.%1$s FROM DUAL;\n  END IF;", this.comboColumns.getSelectedItem().toString(), this.comboSequences.getSelectedItem().toString());
        String type = String.format("  BEFORE INSERT ON %1$s\n  FOR EACH ROW", this.comboTables.getSelectedItem().toString());
        if (this.template == null) {
            return String.format("CREATE OR REPLACE TRIGGER %1$s\n" + type + "\n" + "BEGIN\n" + body + "\n" + "END;", this.textName.getText());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", this.textName.getText());
        map.put("&type", type);
        map.put("&body", body);
        map.put("&description", this.stringManager.getString("CreateTriggerPKColumnWizard-trigger-info"));
        return this.template.expand(map);
    }

    public boolean execute() {
        try {
            Command command = this.database.createCommand();
            command.setParamCheck(false);
            command.execute(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            ExceptionUtil.processException((Throwable)ex);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel4 = new JLabel();
        this.comboColumns = new JComboBox();
        this.jLabel5 = new JLabel();
        this.comboSequences = new JComboBox();
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("trigger-name-dd"));
        this.textName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                CreateTriggerPKColumnWizard.this.textNameKeyPressed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("column-list-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("sequence-list-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 270, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 270, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboColumns, 0, 270, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSequences, 0, 270, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboColumns, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboSequences, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void textNameKeyPressed(KeyEvent evt) {
        this.nameChanged = true;
    }
}

