/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropTableWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private JCheckBox checkConstraintCascade;
    private JCheckBox checkPurge;
    private JComboBox comboTables;
    private JLabel jLabel2;

    public DropTableWizard(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.checkPurge.setEnabled("true".equalsIgnoreCase(this.database.getUserProperties().getProperty("Ora10+")));
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("DropTableWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("DropTableWizard-tab-title");
    }

    public String getSqlCode() {
        return "DROP TABLE " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + (this.checkConstraintCascade.isSelected() ? " CASCADE CONSTRAINTS" : "") + (this.checkPurge.isSelected() ? " PURGE" : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.checkPurge = new JCheckBox();
        this.checkConstraintCascade = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.checkPurge.setText(this.stringManager.getString("skip-bin"));
        this.checkConstraintCascade.setText(this.stringManager.getString("delete-relations-cascade"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkPurge).addComponent(this.checkConstraintCascade).addComponent(this.comboTables, 0, 196, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkConstraintCascade).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPurge).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

