/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleExceptionTableInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.oracle.gui.util.ExceptionTableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableConstraintComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableItemListener;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class EnableTableConstraintWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private String constraintName;
    private JCheckBox checkExceptions;
    private JComboBox comboConstraints;
    private JComboBox comboExceptionTables;
    private JComboBox comboStatus;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;

    public EnableTableConstraintWizard(Database database, String schemaName, String tableName, String constraintName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.constraintName = constraintName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboConstraints.setModel(new TableConstraintComboBoxModel(this.database));
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboExceptionTables.setModel(new ExceptionTableComboBoxModel(this.database));
        this.comboTables.addItemListener(new TableItemListener(){

            public void itemChanged(OracleTableInfo info) {
                ((TableConstraintComboBoxModel)EnableTableConstraintWizard.this.comboConstraints.getModel()).change(info.getSchema().getName(), info.getName());
            }
        });
        this.comboExceptionTables.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof OracleExceptionTableInfo) {
                    OracleExceptionTableInfo info = (OracleExceptionTableInfo)((Object)value);
                    this.setText(SQLUtil.createSqlName((String)info.getTableOwner(), (String)info.getName()));
                }
                return this;
            }
        });
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
        ((TableConstraintComboBoxModel)this.comboConstraints.getModel()).select(this.constraintName, this.comboConstraints);
        ((ExceptionTableComboBoxModel)this.comboExceptionTables.getModel()).change();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("EnableTableConstraintWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("EnableTableConstraintWizard-tab-title");
    }

    public String getSqlCode() {
        OracleExceptionTableInfo info = null;
        if (this.checkExceptions.isSelected() && this.comboExceptionTables.getSelectedItem() instanceof OracleExceptionTableInfo) {
            info = (OracleExceptionTableInfo)((Object)this.comboExceptionTables.getSelectedItem());
        }
        return (info != null ? "DELETE FROM " + SQLUtil.createSqlName((String)info.getTableOwner(), (String)info.getName()) + " WHERE OWNER = '" + this.schemaName + "' AND TABLE_NAME = '" + this.comboTables.getSelectedItem().toString() + "' AND CONSTRAINT = '" + this.comboConstraints.getSelectedItem().toString() + "'\n/\n" : "") + "ALTER TABLE " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + " " + this.comboStatus.getSelectedItem().toString() + " CONSTRAINT " + SQLUtil.createSqlName((String)this.comboConstraints.getSelectedItem().toString()) + (info != null ? "\n EXCEPTIONS INTO " + SQLUtil.createSqlName((String)info.getTableOwner(), (String)info.getName()) : "") + "\n/";
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboConstraints = new JComboBox();
        this.jLabel4 = new JLabel();
        this.comboStatus = new JComboBox();
        this.comboExceptionTables = new JComboBox();
        this.checkExceptions = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("constraint-list-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("state-dd"));
        this.comboStatus.setModel(new DefaultComboBoxModel<String>(new String[]{"ENABLE", "DISABLE"}));
        this.checkExceptions.setText(this.stringManager.getString("exceptions-put-in-to-dd"));
        this.checkExceptions.setHorizontalAlignment(4);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.checkExceptions, -1, 133, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 133, Short.MAX_VALUE).addComponent(this.jLabel3, -2, 133, -2).addComponent(this.jLabel2, -2, 133, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 243, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboConstraints, 0, 243, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboStatus, 0, 243, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.comboExceptionTables, 0, 243, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboTables, -2, 22, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboConstraints, -2, 22, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboStatus, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboExceptionTables, -2, 22, -2).addComponent(this.checkExceptions)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

