/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.table;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class EnableTableRelatedConstraintWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private JComboBox comboStatus;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public EnableTableRelatedConstraintWizard(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTables.setModel(new TableComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("EnableTableRelatedConstraintWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("EnableTableRelatedConstraintWizard-tab-title");
    }

    public String getSqlCode() {
        return "BEGIN\n  FOR C IN (SELECT FK.OWNER, FK.CONSTRAINT_NAME, FK.TABLE_NAME\n              FROM ALL_CONSTRAINTS FK, ALL_CONSTRAINTS PK\n             WHERE FK.CONSTRAINT_TYPE = 'R'\n               AND PK.OWNER = '" + this.schemaName + "'\n" + "               AND FK.R_CONSTRAINT_NAME = PK.CONSTRAINT_NAME\n" + "               AND PK.TABLE_NAME = '" + this.comboTables.getSelectedItem().toString() + "') LOOP\n" + "    EXECUTE IMMEDIATE 'ALTER TABLE \"'||C.OWNER||'\".\"'||C.TABLE_NAME||'\" MODIFY CONSTRAINT \"'||C.CONSTRAINT_NAME||'\" " + this.comboStatus.getSelectedItem().toString() + "';\n" + "  END LOOP;\n" + "END;";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.comboStatus = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.comboStatus.setModel(new DefaultComboBoxModel<String>(new String[]{"ENABLE", "DISABLE"}));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("state-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 127, -2).addComponent(this.jLabel3, -2, 127, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.comboStatus, GroupLayout.Alignment.LEADING, 0, 227, Short.MAX_VALUE).addComponent(this.comboTables, GroupLayout.Alignment.LEADING, 0, 227, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboStatus, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

