/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleViewColumnInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleViewInfo;
import pl.mpak.orbada.oracle.gui.util.ViewColumnComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.ViewColumnItemListener;
import pl.mpak.orbada.oracle.gui.util.ViewComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.ViewItemListener;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CommentViewColumnWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String viewName;
    private String columnName;
    private JComboBox comboColumns;
    private JComboBox comboView;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private TextField textComments;

    public CommentViewColumnWizard(Database database, String schemaName, String viewName, String columnName) {
        this.database = database;
        this.schemaName = schemaName;
        this.viewName = viewName;
        this.columnName = columnName;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getComments(String schemaName, String tableName, String columnName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTableColumnComment());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TABLE_NAME").setString(tableName);
            query.paramByName("COLUMN_NAME").setString(columnName);
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("comments").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    private void init() {
        this.comboColumns.setModel(new ViewColumnComboBoxModel(this.database));
        this.comboView.setModel(new ViewComboBoxModel(this.database));
        this.comboView.addItemListener(new ViewItemListener(){

            public void itemChanged(OracleViewInfo info) {
                ((ViewColumnComboBoxModel)CommentViewColumnWizard.this.comboColumns.getModel()).change(info.getSchema().getName(), info.getName());
            }
        });
        this.comboColumns.addItemListener(new ViewColumnItemListener(){
            OracleViewColumnInfo lastColumn;

            public void itemChanged(OracleViewColumnInfo info) {
                CommentViewColumnWizard.this.textComments.setText(CommentViewColumnWizard.this.getComments(info.getSchema().getName(), info.getView().getName(), info.getName()));
            }
        });
    }

    public void wizardShow() {
        ((ViewComboBoxModel)this.comboView.getModel()).change(this.schemaName);
        ((ViewComboBoxModel)this.comboView.getModel()).select(this.viewName, this.comboView);
        ((ViewColumnComboBoxModel)this.comboColumns.getModel()).select(this.columnName, this.comboColumns);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CommentViewColumnWizard.this.textComments.requestFocusInWindow();
            }
        });
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CommentViewColumnWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CommentViewColumnWizard-tab-title");
    }

    public String getSqlCode() {
        return "COMMENT ON COLUMN " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboView.getSelectedItem().toString(), (String)this.comboColumns.getSelectedItem().toString()) + " IS '" + this.textComments.getText() + "'";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboView = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textComments = new TextField();
        this.jLabel4 = new JLabel();
        this.comboColumns = new JComboBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("view-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("comment-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("column-list-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboView, 0, 270, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboColumns, 0, 270, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textComments, -1, 270, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboView, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboColumns, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textComments, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

