/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleViewInfo;
import pl.mpak.orbada.oracle.gui.util.ViewComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.ViewItemListener;
import pl.mpak.orbada.oracle.services.OracleTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateViewTriggerWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String viewName;
    private boolean nameChanged = false;
    private Template template;
    private JCheckBox checkDelete;
    private JCheckBox checkInsert;
    private JCheckBox checkUpdate;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private TextField textName;
    private TextField textNewRef;
    private TextField textOldRef;

    public CreateViewTriggerWizard(Database database, String schemaName, String viewName) {
        this.database = database;
        this.schemaName = schemaName;
        this.viewName = viewName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTables.setModel(new ViewComboBoxModel(this.database));
        this.comboTables.addItemListener(new ViewItemListener(){

            public void itemChanged(OracleViewInfo info) {
                if (!CreateViewTriggerWizard.this.nameChanged) {
                    CreateViewTriggerWizard.this.updateName();
                }
            }
        });
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(OracleTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(OracleTemplatesSettingsProvider.setTrigger, "oracle-trigger"));
        ((ViewComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((ViewComboBoxModel)this.comboTables.getModel()).select(this.viewName, this.comboTables);
    }

    private void updateName() {
        String idu = "";
        if (this.checkInsert.isSelected()) {
            idu = idu + "_NEW";
        }
        if (this.checkDelete.isSelected()) {
            idu = idu + "_DEL";
        }
        if (this.checkUpdate.isSelected()) {
            idu = idu + "_UPD";
        }
        this.textName.setText(this.comboTables.getSelectedItem().toString() + idu + "_TRG");
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateViewTriggerWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateViewTriggerWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String idu = "";
        if (this.checkInsert.isSelected()) {
            idu = idu + " INSERT";
        }
        if (this.checkDelete.isSelected()) {
            if (!StringUtil.isEmpty((String)idu)) {
                idu = idu + " OR";
            }
            idu = idu + " DELETE";
        }
        if (this.checkDelete.isSelected()) {
            if (!StringUtil.isEmpty((String)idu)) {
                idu = idu + " OR";
            }
            idu = idu + " UPDATE";
        }
        idu = idu + " ON " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString());
        String ref = "";
        if (!StringUtil.isEmpty((String)this.textOldRef.getText())) {
            ref = ref + " OLD AS " + this.textOldRef.getText();
        }
        if (!StringUtil.isEmpty((String)this.textNewRef.getText())) {
            ref = ref + " NEW AS " + this.textNewRef.getText();
        }
        String type = "  INSTEAD OF" + idu + (!StringUtil.isEmpty((String)ref) ? "\n  REFERENCING" + ref : "");
        if (this.template == null) {
            return "CREATE TRIGGER " + this.textName.getText() + "\n" + type + "\nBEGIN\n" + "  NULL;\n" + "END;";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", this.textName.getText());
        map.put("&type", type);
        map.put("&body", "  NULL;");
        map.put("&description", "");
        return this.template.expand(map);
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.checkInsert = new JCheckBox();
        this.checkDelete = new JCheckBox();
        this.checkUpdate = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.textNewRef = new TextField();
        this.jLabel7 = new JLabel();
        this.textOldRef = new TextField();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("view-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("trigger-name-dd"));
        this.textName.setText("_TRG");
        this.textName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                CreateViewTriggerWizard.this.textNameKeyPressed(evt);
            }
        });
        this.checkInsert.setText(this.stringManager.getString("inserting"));
        this.checkInsert.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CreateViewTriggerWizard.this.checkInsertStateChanged(evt);
            }
        });
        this.checkDelete.setText(this.stringManager.getString("deleting"));
        this.checkDelete.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CreateViewTriggerWizard.this.checkDeleteStateChanged(evt);
            }
        });
        this.checkUpdate.setText(this.stringManager.getString("updating"));
        this.checkUpdate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CreateViewTriggerWizard.this.checkUpdateStateChanged(evt);
            }
        });
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("reference-new-dd"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("reference-old-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textOldRef, -1, 273, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textNewRef, -1, 273, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(131, 131, 131).addComponent(this.checkInsert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUpdate)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 273, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 273, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkInsert).addComponent(this.checkDelete).addComponent(this.checkUpdate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textNewRef, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.textOldRef, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void textNameKeyPressed(KeyEvent evt) {
        this.nameChanged = true;
    }

    private void checkInsertStateChanged(ChangeEvent evt) {
        if (!this.nameChanged) {
            this.updateName();
        }
    }

    private void checkDeleteStateChanged(ChangeEvent evt) {
        if (!this.nameChanged) {
            this.updateName();
        }
    }

    private void checkUpdateStateChanged(ChangeEvent evt) {
        if (!this.nameChanged) {
            this.updateName();
        }
    }
}

