/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.services;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.util.OracleUtil;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.TextTransfer;

public class OracleCopySqlFromSourceActionProvider
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OracleCopySqlFromSourceActionProvider.this.getComponent() instanceof SyntaxEditor) {
                    SyntaxEditor textArea = (SyntaxEditor)OracleCopySqlFromSourceActionProvider.this.getComponent();
                    try {
                        new TextTransfer().setClipboardContents(OracleUtil.prepareSqlFromPLSQL(textArea.getTokensCurrentText()));
                    }
                    catch (BadLocationException ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"Oracle".equals(database.getDriverType())) {
            return false;
        }
        if (StringUtil.anyOfString((String)actionType, (String[])new String[]{"oracle-package-source-actions", "oracle-function-source-actions", "oracle-procedure-source-actions", "oracle-type-source-actions", "oracle-trigger-source-actions"}) == -1) {
            return false;
        }
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/sky/res/copy.gif"));
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("OracleCopySqlFromSourceActionProvider-hint"));
        this.setActionCommandKey("OracleCopySqlFromSourceActionProvider");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("OracleCopySqlFromSourceActionProvider-description");
    }

    public String getGroupName() {
        return "Oracle";
    }

    public boolean isToolButton() {
        return true;
    }
}

