/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.services;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.universal.ExplainPlanPanel;
import pl.mpak.orbada.oracle.services.OracleSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OracleExplainPlanProvider
extends UniversalActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private ISettings settings;

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        if ("Oracle".equals(database.getDriverType())) {
            this.setShortCut(69, 2);
            this.setText(this.stringManager.getString("OracleExplainPlanProvider-text"));
            this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/explain_plan.gif"));
            this.setActionCommandKey("OracleExplainPlanProvider");
            this.addActionListener(this.createActionListener());
            this.settings = this.application.getSettings(OracleSettingsProvider.settingsName);
            return true;
        }
        return false;
    }

    public boolean addToolButton() {
        return true;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("OracleExplainPlanProvider-description");
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String sqlCode = OracleExplainPlanProvider.this.accessibilities.getSyntaxEditor().getCurrentText();
                Component[] array = OracleExplainPlanProvider.this.accessibilities.getResultTabs(ExplainPlanPanel.class);
                if (array.length > 0 && !OracleExplainPlanProvider.this.settings.getValue(OracleSettingsProvider.setMultiExplainPlan, Boolean.valueOf(false)).booleanValue()) {
                    ExplainPlanPanel panel = (ExplainPlanPanel)array[0];
                    panel.updatePlan(sqlCode);
                    OracleExplainPlanProvider.this.accessibilities.setSelectedTab((Component)panel);
                    OracleExplainPlanProvider.this.accessibilities.setTabTooltip((Component)panel, SQLUtil.createTooltipFromSql((String)sqlCode));
                } else {
                    ExplainPlanPanel panel = new ExplainPlanPanel(OracleExplainPlanProvider.this.accessibilities.getViewAccesibilities().getDatabase(), sqlCode);
                    OracleExplainPlanProvider.this.accessibilities.addResultTab(OracleExplainPlanProvider.this.getText(), (JComponent)panel);
                    OracleExplainPlanProvider.this.accessibilities.setTabTooltip((Component)panel, SQLUtil.createTooltipFromSql((String)sqlCode));
                }
            }
        };
    }

    public String getGroupName() {
        return "Oracle";
    }
}

