/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.services;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.cm.CompileAllObjectsAction;
import pl.mpak.orbada.oracle.cm.CopyTableAction;
import pl.mpak.orbada.oracle.cm.CopyViewAsTableAction;
import pl.mpak.orbada.oracle.cm.CreateDbLinkAction;
import pl.mpak.orbada.oracle.cm.CreateExternalTableAction;
import pl.mpak.orbada.oracle.cm.CreateFunctionAction;
import pl.mpak.orbada.oracle.cm.CreateIndexAction;
import pl.mpak.orbada.oracle.cm.CreateJavaSourceAction;
import pl.mpak.orbada.oracle.cm.CreateNormalTableAction;
import pl.mpak.orbada.oracle.cm.CreateObjectTypeAction;
import pl.mpak.orbada.oracle.cm.CreatePackageAction;
import pl.mpak.orbada.oracle.cm.CreateProcedureAction;
import pl.mpak.orbada.oracle.cm.CreateSequenceAction;
import pl.mpak.orbada.oracle.cm.CreateSynonymAction;
import pl.mpak.orbada.oracle.cm.CreateTableTriggerAction;
import pl.mpak.orbada.oracle.cm.CreateTableTypeAction;
import pl.mpak.orbada.oracle.cm.CreateTemporaryTableAction;
import pl.mpak.orbada.oracle.cm.CreateTriggerPKColumnAction;
import pl.mpak.orbada.oracle.cm.CreateVarrayTypeAction;
import pl.mpak.orbada.oracle.cm.CreateViewTriggerAction;
import pl.mpak.orbada.oracle.cm.CurrentSchemaAction;
import pl.mpak.orbada.oracle.cm.CursorSharingAction;
import pl.mpak.orbada.oracle.cm.DdlWaitForLocksAction;
import pl.mpak.orbada.oracle.cm.IsolationLevelAction;
import pl.mpak.orbada.oracle.cm.PlSqlCcFlagsAction;
import pl.mpak.orbada.oracle.cm.PlSqlCodeTypeAction;
import pl.mpak.orbada.oracle.cm.PlSqlDebugAction;
import pl.mpak.orbada.oracle.cm.PlSqlOptimizeLevelAction;
import pl.mpak.orbada.oracle.cm.PlSqlWarningsAction;
import pl.mpak.orbada.oracle.cm.QueryRewriteEnabledAction;
import pl.mpak.orbada.oracle.cm.QueryRewriteIntegrityAction;
import pl.mpak.orbada.oracle.cm.SqlTraceAction;
import pl.mpak.orbada.oracle.cm.StarTransformationEnabledAction;
import pl.mpak.orbada.oracle.cm.StatisticsLevelAction;
import pl.mpak.orbada.oracle.cm.SubmitJobAction;
import pl.mpak.orbada.oracle.gui.freezing.FreezeFactory;
import pl.mpak.orbada.oracle.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.IDatabaseObject;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class OraclePerspectiveProvider
extends PerspectiveProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Oracle".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("OraclePerspectiveProvider-description");
    }

    public String getGroupName() {
        return "Oracle";
    }

    public void initialize() {
        final JMenu wizards = new JMenu(this.stringManager.getString("wizzards"));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                wizards.add((Action)((Object)new CreateNormalTableAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateExternalTableAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateTemporaryTableAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.addSeparator();
                wizards.add((Action)((Object)new CopyTableAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CopyViewAsTableAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new SubmitJobAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.addSeparator();
                wizards.add((Action)((Object)new CreateTriggerPKColumnAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateTableTriggerAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateViewTriggerAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.addSeparator();
                wizards.add((Action)((Object)new CreateIndexAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.addSeparator();
                wizards.add((Action)((Object)new CreateSequenceAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateSynonymAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateDbLinkAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.addSeparator();
                wizards.add((Action)((Object)new CreateObjectTypeAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateTableTypeAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateVarrayTypeAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreatePackageAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateJavaSourceAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateProcedureAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateFunctionAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.addSeparator();
                wizards.add((Action)((Object)new CompileAllObjectsAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                ComponentActionProvider[] capa = (ComponentActionProvider[])OraclePerspectiveProvider.this.application.getServiceArray(ComponentActionProvider.class);
                if (capa != null && capa.length > 0) {
                    boolean first = true;
                    for (ComponentActionProvider cap : capa) {
                        if (!cap.isForComponent(OraclePerspectiveProvider.this.accesibilities.getDatabase(), "oracle-wizards-actions")) continue;
                        cap.setDatabase(OraclePerspectiveProvider.this.accesibilities.getDatabase());
                        if (first) {
                            wizards.addSeparator();
                        }
                        wizards.add((Action)cap);
                        first = false;
                    }
                }
            }
        });
        final JMenu oracle = new JMenu("Oracle");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                oracle.add((Action)((Object)OrbadaOraclePlugin.findObjectAction));
                oracle.add((Action)((Object)OrbadaOraclePlugin.callObjectAction));
                oracle.addSeparator();
                oracle.add((Action)((Object)new PlSqlDebugAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new PlSqlCodeTypeAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new PlSqlOptimizeLevelAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new PlSqlWarningsAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new PlSqlCcFlagsAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.addSeparator();
                oracle.add((Action)((Object)new QueryRewriteEnabledAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new QueryRewriteIntegrityAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new CursorSharingAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new DdlWaitForLocksAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new SqlTraceAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new StarTransformationEnabledAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new StatisticsLevelAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.addSeparator();
                oracle.add((Action)((Object)new CurrentSchemaAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                oracle.add((Action)((Object)new IsolationLevelAction(OraclePerspectiveProvider.this.accesibilities.getDatabase())));
                ComponentActionProvider[] capa = (ComponentActionProvider[])OraclePerspectiveProvider.this.application.getServiceArray(ComponentActionProvider.class);
                if (capa != null && capa.length > 0) {
                    boolean first = true;
                    for (ComponentActionProvider cap : capa) {
                        if (!cap.isForComponent(OraclePerspectiveProvider.this.accesibilities.getDatabase(), "oracle-actions")) continue;
                        cap.setDatabase(OraclePerspectiveProvider.this.accesibilities.getDatabase());
                        if (first) {
                            oracle.addSeparator();
                        }
                        oracle.add((Action)cap);
                        first = false;
                    }
                }
            }
        });
        this.accesibilities.addMenu(oracle);
        this.accesibilities.addMenu(wizards);
        JToolBar toolBar = new JToolBar("Oracle");
        toolBar.add((Component)new ToolButton((Action)((Object)OrbadaOraclePlugin.findObjectAction)));
        toolBar.add((Component)new ToolButton((Action)((Object)OrbadaOraclePlugin.callObjectAction)));
        toolBar.addSeparator();
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateNormalTableAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CopyTableAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateTableTriggerAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new SubmitJobAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateSequenceAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateSynonymAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateDbLinkAction(this.accesibilities.getDatabase()))));
        toolBar.addSeparator();
        toolBar.add((Component)new ToolButton((Action)((Object)new CurrentSchemaAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new IsolationLevelAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CompileAllObjectsAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new PlSqlDebugAction(this.accesibilities.getDatabase()))));
        this.accesibilities.addToolBar(toolBar);
    }

    public void processMessage(PluginMessage message) {
        if (this.getAccesibilities() != null && this.getAccesibilities().getDatabase() != null && this.getAccesibilities().getDatabase().getUniqueID().equals(message.getDestinationId()) && message.isMessageId("freeze-object")) {
            final IDatabaseObject object = (IDatabaseObject)message.getObject();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FreezeViewService service = new FreezeFactory().createInstance(object.getObjectType(), StringUtil.nvl((String)object.getSchemaName(), (String)object.getCatalogName()), object.getObjectName());
                    IPerspectiveAccesibilities accessibilities = OraclePerspectiveProvider.this.application.getActivePerspective();
                    if (service != null && accessibilities != null) {
                        accessibilities.createView((ViewProvider)service);
                    }
                }
            });
            message.setServed(true);
        }
    }
}

