/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.services;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.functions.FunctionArgumentsPanel;
import pl.mpak.orbada.oracle.gui.javas.JavaMethodsPanel;
import pl.mpak.orbada.oracle.gui.mviews.MViewColumnsPanel;
import pl.mpak.orbada.oracle.gui.packages.PackageMethodsPanel;
import pl.mpak.orbada.oracle.gui.procedures.ProcedureArgumentsPanel;
import pl.mpak.orbada.oracle.gui.tables.TableColumnsPanel;
import pl.mpak.orbada.oracle.gui.types.TypeMethodsPanel;
import pl.mpak.orbada.oracle.gui.views.ViewColumnsPanel;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalColumnProvider
extends UniversalActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        if ("Oracle".equals(database.getDriverType())) {
            this.setText(this.stringManager.getString("UniversalColumnProvider-text"));
            this.setShortCut(117, 2);
            this.setTooltip(this.stringManager.getString("UniversalColumnProvider-hint"));
            this.setActionCommandKey("UniversalColumnProvider");
            this.addActionListener(this.createActionListener());
            return true;
        }
        return false;
    }

    public boolean addToolButton() {
        return false;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("UniversalColumnProvider-description");
    }

    private boolean resolveObject(String type, String schema, String object) {
        if ("TABLE".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("columns"));
            TableColumnsPanel panel = new TableColumnsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("VIEW".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("columns"));
            ViewColumnsPanel panel = new ViewColumnsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("MATERIALIZED VIEW".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("columns"));
            MViewColumnsPanel panel = new MViewColumnsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("PROCEDURE".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("UniversalColumnProvider-parameters"));
            ProcedureArgumentsPanel panel = new ProcedureArgumentsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("FUNCTION".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("UniversalColumnProvider-parameters"));
            FunctionArgumentsPanel panel = new FunctionArgumentsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("PACKAGE".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("package-functions"));
            PackageMethodsPanel panel = new PackageMethodsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("JAVA CLASS".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("class-methods"));
            JavaMethodsPanel panel = new JavaMethodsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("TYPE".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("type-methods"));
            TypeMethodsPanel panel = new TypeMethodsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, schema, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
            return true;
        }
        return false;
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                block12: {
                    try {
                        String[] words = UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getWordsAt(UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getCaretPosition());
                        String object = null;
                        String schema = null;
                        if (words == null || words.length <= 0) break block12;
                        if (words.length == 1) {
                            object = SQLUtil.normalizeSqlName((String)words[0]);
                        } else {
                            schema = SQLUtil.normalizeSqlName((String)words[0]);
                            object = SQLUtil.normalizeSqlName((String)words[1]);
                        }
                        boolean found = false;
                        Query query = UniversalColumnProvider.this.accessibilities.getViewAccesibilities().getDatabase().createQuery();
                        try {
                            query.setSqlText(Sql.resolveObject());
                            query.paramByName("schema_name").setString(schema);
                            query.paramByName("object_name").setString(object);
                            query.open();
                            if (!query.eof()) {
                                schema = query.fieldByName("schema_name").getString();
                                object = query.fieldByName("object_name").getString();
                                found = UniversalColumnProvider.this.resolveObject(query.fieldByName("object_type").getString(), schema, object);
                            }
                            if (!found) {
                                object = schema;
                                schema = null;
                                query.close();
                                query.paramByName("schema_name").setString(schema);
                                query.paramByName("object_name").setString(object);
                                query.open();
                                if (!query.eof()) {
                                    schema = query.fieldByName("schema_name").getString();
                                    object = query.fieldByName("object_name").getString();
                                    String type = query.fieldByName("object_type").getString();
                                    found = UniversalColumnProvider.this.resolveObject(type, schema, object);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public String getGroupName() {
        return "Oracle";
    }
}

