/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.services;

import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalErrorPosition
extends UniversalActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private int beforeStartPosition = -1;
    private int beforeEndPosition = -1;
    private String sqlText;

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Oracle".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return false;
    }

    public boolean addMenuItem() {
        return false;
    }

    public boolean addToEditor() {
        return false;
    }

    public String getDescription() {
        return this.stringManager.getString("UniversalErrorPosition-description");
    }

    public String getGroupName() {
        return "Oracle";
    }

    private void beforeSql() {
        this.beforeStartPosition = this.accessibilities.getSyntaxEditor().getStartCurrentText();
        this.beforeEndPosition = this.accessibilities.getSyntaxEditor().getEndCurrentText();
    }

    private void onError(ParametrizedCommand cmd, Exception ex) {
        if (this.accessibilities.getSyntaxEditor().getStartCurrentText() == this.beforeStartPosition && this.accessibilities.getSyntaxEditor().getEndCurrentText() == this.beforeEndPosition && !this.commandTransformed) {
            Command command = cmd.getDatabase().createCommand();
            try {
                command.setSqlText(Sql.getErrorPosition());
                command.paramByName("sql").setString(cmd.getSqlText());
                command.paramByName("result").setParamMode(4, 4);
                command.execute();
                if (!command.paramByName("result").getValue().isNullValue()) {
                    this.accessibilities.getSyntaxEditor().setCaretPosition(this.beforeStartPosition + command.paramByName("result").getInteger(), true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void beforeOpenQuery(Query query) {
        this.beforeSql();
    }

    public void queryError(Query query, Exception ex) {
        this.onError((ParametrizedCommand)query, ex);
    }

    public void beforeExecuteCommand(Command command) {
        this.beforeSql();
    }

    public void commandError(Command command, Exception ex) {
        this.onError((ParametrizedCommand)command, ex);
    }
}

