/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.syntax.parser;

import java.util.ArrayList;
import pl.mpak.orbada.oracle.syntax.parser.Package;
import pl.mpak.orbada.oracle.syntax.parser.Pragma;
import pl.mpak.orbada.oracle.syntax.parser.TypeObject;
import pl.mpak.sky.gui.swing.syntax.structure.BlockElement;
import pl.mpak.sky.gui.swing.syntax.structure.CallableElement;
import pl.mpak.sky.gui.swing.syntax.structure.CallableParameter;
import pl.mpak.sky.gui.swing.syntax.structure.CaseBlock;
import pl.mpak.sky.gui.swing.syntax.structure.CaseElse;
import pl.mpak.sky.gui.swing.syntax.structure.CaseWhen;
import pl.mpak.sky.gui.swing.syntax.structure.CatchException;
import pl.mpak.sky.gui.swing.syntax.structure.CodeElement;
import pl.mpak.sky.gui.swing.syntax.structure.Condition;
import pl.mpak.sky.gui.swing.syntax.structure.Constant;
import pl.mpak.sky.gui.swing.syntax.structure.Cursor;
import pl.mpak.sky.gui.swing.syntax.structure.DeclaredElement;
import pl.mpak.sky.gui.swing.syntax.structure.Else;
import pl.mpak.sky.gui.swing.syntax.structure.Exception;
import pl.mpak.sky.gui.swing.syntax.structure.ExceptionBlock;
import pl.mpak.sky.gui.swing.syntax.structure.Expression;
import pl.mpak.sky.gui.swing.syntax.structure.For;
import pl.mpak.sky.gui.swing.syntax.structure.Function;
import pl.mpak.sky.gui.swing.syntax.structure.GotoLabel;
import pl.mpak.sky.gui.swing.syntax.structure.If;
import pl.mpak.sky.gui.swing.syntax.structure.Loop;
import pl.mpak.sky.gui.swing.syntax.structure.ParserException;
import pl.mpak.sky.gui.swing.syntax.structure.Procedure;
import pl.mpak.sky.gui.swing.syntax.structure.SqlStructureParser;
import pl.mpak.sky.gui.swing.syntax.structure.Statement;
import pl.mpak.sky.gui.swing.syntax.structure.Trigger;
import pl.mpak.sky.gui.swing.syntax.structure.Type;
import pl.mpak.sky.gui.swing.syntax.structure.Variable;
import pl.mpak.sky.gui.swing.syntax.structure.While;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OraclePlSqlStructureParser
extends SqlStructureParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockElement parse() {
        Object block = null;
        try {
            while (this.nextToken(true) != null) {
                if (this.isToken("function")) {
                    block = new Function(null);
                    this.parseCallable((CallableElement)block);
                } else if (this.isToken("procedure")) {
                    block = new Procedure(null);
                    this.parseCallable((CallableElement)((Procedure)block));
                } else if (this.isToken("package")) {
                    block = new Package(null);
                    this.parsePackage((Package)((Object)block));
                } else if (this.isToken("type")) {
                    block = new TypeObject(null);
                    this.parseTypeObject((TypeObject)((Object)block));
                } else {
                    if (!this.isToken("trigger")) continue;
                    block = new Trigger(null);
                    this.parseTrigger((Trigger)block);
                }
                break;
            }
        }
        catch (ParserException parserException) {
        }
        finally {
            this.updateKeyWordStyles();
        }
        return block;
    }

    private String parseIdentifier() throws ParserException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 9);
        this.nextToken(true);
        while (this.isToken(".")) {
            sb.append(this.getTokenString());
            this.nextToken(true);
            sb.append(this.getTokenString());
            this.putKeyWord(this.getTokenString(), 9);
            this.nextToken(true);
        }
        return sb.toString();
    }

    private DeclaredElement parseParameter(CodeElement callable) throws ParserException {
        this.skipBlank();
        CallableParameter param = new CallableParameter(callable);
        param.setStartOffset(this.getStartOffset());
        param.setName(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 21);
        this.nextToken(true);
        StringBuilder sb = new StringBuilder();
        int brackets = 0;
        while (!this.isToken(")") && !this.isToken(",") || brackets > 0) {
            if (this.getToken().styleId != 2 && this.getToken().styleId != 16) {
                if (this.isToken("(")) {
                    ++brackets;
                } else if (this.isToken(")")) {
                    --brackets;
                }
                String t = this.getTokenString();
                if (!t.trim().equals(t) && t.trim().length() == 0) {
                    t = " ";
                }
                sb.append(t);
            }
            if (this.nextToken() != null) continue;
        }
        param.setType(sb.toString().trim());
        param.setEndOffset(this.getEndOffset());
        return param;
    }

    private DeclaredElement parseDeclaration(BlockElement block) throws ParserException {
        Constant declare;
        this.skipBlank();
        int start = this.getStartOffset();
        String name = this.getTokenString();
        this.nextToken(true);
        if (this.isToken("constant")) {
            this.putKeyWord(name, 21);
            declare = new Constant((CodeElement)block);
            this.nextToken(true);
        } else if (this.isToken("exception")) {
            this.putKeyWord(name, 7);
            declare = new Exception((CodeElement)block);
            this.nextToken(true);
        } else {
            this.putKeyWord(name, 21);
            declare = new Variable((CodeElement)block);
        }
        declare.setStartOffset(start);
        declare.setName(name);
        StringBuilder sb = new StringBuilder();
        int roundedParenth = 0;
        int quadParenth = 0;
        while (!this.isToken(";")) {
            if (this.getToken().styleId != 2 && this.getToken().styleId != 16) {
                sb.append(this.getTokenString());
            } else {
                sb.append(" ");
            }
            if (this.isToken("(")) {
                ++roundedParenth;
            } else if (this.isToken(")")) {
                --roundedParenth;
            } else if (this.isToken("[")) {
                ++quadParenth;
            } else if (this.isToken("]")) {
                --quadParenth;
            }
            this.nextToken();
            if (!this.isToken(",") || roundedParenth != 0 || quadParenth != 0) continue;
        }
        declare.setType(sb.toString().trim());
        declare.setEndOffset(this.getEndOffset());
        return declare;
    }

    private DeclaredElement parsePragma(BlockElement block) throws ParserException {
        this.nextToken(true);
        Pragma declare = new Pragma((CodeElement)block);
        declare.setStartOffset(this.getStartOffset());
        declare.setName(this.getTokenString());
        this.nextToken(true);
        StringBuilder sb = new StringBuilder();
        int roundedParenth = 0;
        while (!this.isToken(";")) {
            if (this.getToken().styleId != 2 && this.getToken().styleId != 16) {
                sb.append(this.getTokenString());
            } else {
                sb.append(" ");
            }
            if (this.isToken("(")) {
                ++roundedParenth;
            } else if (this.isToken(")")) {
                --roundedParenth;
            }
            this.nextToken(true);
            if (!this.isToken(",") || roundedParenth != 0) continue;
        }
        declare.setType(sb.toString().trim());
        declare.setEndOffset(this.getEndOffset());
        return declare;
    }

    private void declareElement(BlockElement block) throws ParserException {
        if (this.isToken("cursor")) {
            block.putCallable((CallableElement)this.parseCursor(new Cursor((CodeElement)block)));
        } else if (this.isToken("function")) {
            block.putCallable(this.parseCallable((CallableElement)new Function((CodeElement)block)));
        } else if (this.isToken("procedure")) {
            block.putCallable(this.parseCallable((CallableElement)new Procedure((CodeElement)block)));
        } else if (this.isToken("constructor") || this.isToken("member") || this.isToken("static")) {
            this.nextToken(true);
            if (this.isToken("function")) {
                block.putCallable(this.parseCallable((CallableElement)new Function((CodeElement)block)));
            } else if (this.isToken("procedure")) {
                block.putCallable(this.parseCallable((CallableElement)new Procedure((CodeElement)block)));
            }
        } else if (this.isToken("type")) {
            block.putDeclare((DeclaredElement)this.parseType(new Type((CodeElement)block)));
        } else if (this.isToken("pragma")) {
            block.putDeclare(this.parsePragma(block));
        } else {
            block.putDeclare(this.parseDeclaration(block));
        }
        if (this.isToken(";") || this.isToken(",")) {
            this.nextToken(true);
        }
    }

    private void parseDeclares(BlockElement block) throws ParserException {
        if (!this.isToken("begin") && !this.isToken("end")) {
            this.declareElement(block);
            while (!(this.isToken("begin") || this.isToken("end") || this.isToken(")"))) {
                this.declareElement(block);
            }
        }
    }

    private void parseParameters(CodeElement block, ArrayList<DeclaredElement> parameterList) throws ParserException {
        this.nextToken(true);
        if (!this.isToken(")")) {
            parameterList.add(this.parseParameter(block));
            while (this.isToken(",")) {
                this.nextToken(true);
                parameterList.add(this.parseParameter(block));
            }
            this.nextToken(true);
        }
    }

    private If parseIf(If block) throws ParserException {
        block.setStartOffset(this.getEndOffset());
        this.nextToken(true);
        Condition cond = null;
        while (!this.isToken("then")) {
            if (cond == null) {
                cond = new Condition((CodeElement)block);
                cond.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (cond != null) {
            block.setCondition(cond);
            cond.setEndOffset(this.getEndOffset());
        }
        this.parseBlockStatements((BlockElement)block);
        while (this.isToken("elsif") || this.isToken("else")) {
            Else eb = new Else((CodeElement)block);
            eb.setStartOffset(this.getStartOffset());
            if (this.isToken("elsif")) {
                block.setElseBlock(eb);
                block.getElseBlock().getCodeList().add(this.parseIf(new If((CodeElement)block.getElseBlock())));
                eb.setEndOffset(this.getEndOffset());
                block.setEndOffset(this.getEndOffset());
                return block;
            }
            block.setElseBlock((Else)this.parseBlockStatements((BlockElement)eb));
            eb.setEndOffset(this.getEndOffset());
        }
        this.nextToken(true);
        if (this.isToken("if")) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private For parseFor(For block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Variable declare = new Variable((CodeElement)block);
        declare.setStartOffset(this.getStartOffset());
        declare.setName(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 21);
        this.nextToken(true);
        declare.setEndOffset(this.getEndOffset());
        block.putDeclare((DeclaredElement)declare);
        if (this.isToken("in")) {
            this.nextToken(true);
        }
        Expression expr = null;
        while (!this.isToken("loop")) {
            if (expr == null) {
                expr = new Expression((CodeElement)block);
                expr.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (expr != null) {
            block.setExpression(expr);
            expr.setEndOffset(this.getEndOffset());
        }
        this.parseBlockStatements((BlockElement)block);
        this.nextToken(true);
        if (this.isToken("loop")) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private While parseWhile(While block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Expression expr = null;
        while (!this.isToken("loop")) {
            if (expr == null) {
                expr = new Expression((CodeElement)block);
                expr.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (expr != null) {
            block.setExpression(expr);
            expr.setEndOffset(this.getEndOffset());
        }
        this.parseBlockStatements((BlockElement)block);
        this.nextToken(true);
        if (this.isToken("loop")) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private Loop parseLoop(Loop block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.parseBlockStatements((BlockElement)block);
        this.nextToken(true);
        if (this.isToken("loop")) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private CatchException parseCatchException(CatchException block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Expression expr = null;
        while (!this.isToken("then")) {
            if (expr == null) {
                expr = new Expression((CodeElement)block);
                expr.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (expr != null) {
            block.setExpression(expr);
            expr.setEndOffset(this.getEndOffset());
        }
        this.parseBlockStatements((BlockElement)block);
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private ExceptionBlock parseException(ExceptionBlock block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        while (this.isToken("when")) {
            block.getCatchList().add(this.parseCatchException(new CatchException((CodeElement)block)));
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private CaseWhen parseCaseWhen(CaseWhen block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Expression expr = null;
        while (!this.isToken("then")) {
            if (expr == null) {
                expr = new Expression((CodeElement)block);
                expr.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (expr != null) {
            block.setExpression(expr);
            expr.setEndOffset(this.getEndOffset());
        }
        this.parseBlockStatements((BlockElement)block);
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private CaseElse parseCaseElse(CaseElse block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.parseBlockStatements((BlockElement)block);
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private CaseBlock parseCase(CaseBlock block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Expression expr = null;
        while (!this.isToken("when")) {
            if (expr == null) {
                expr = new Expression((CodeElement)block);
                expr.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (expr != null) {
            block.setExpression(expr);
            expr.setEndOffset(this.getEndOffset());
        }
        while (this.isToken("when")) {
            block.getWhenList().add(this.parseCaseWhen(new CaseWhen((CodeElement)block)));
        }
        if (this.isToken("else")) {
            block.setElseBlock((BlockElement)this.parseCaseElse(new CaseElse((CodeElement)block)));
        }
        this.nextToken(true);
        if (this.isToken("case")) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private Statement parseStatement(BlockElement block, Statement statement) throws ParserException {
        statement.setStartOffset(this.getStartOffset());
        while (!this.isToken(";")) {
            this.nextToken(true);
        }
        statement.setEndOffset(this.getEndOffset());
        return statement;
    }

    private GotoLabel parseGotoLabel(GotoLabel block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        block.setName(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 21);
        this.nextToken(true);
        if (this.isToken(">>")) {
            block.setEndOffset(this.getEndOffset() + 2);
        } else {
            block.setEndOffset(this.getEndOffset());
        }
        return block;
    }

    private BlockElement parseBlockStatements(BlockElement block) throws ParserException {
        while (this.nextToken(true) != null) {
            if (this.isToken("else")) {
                return block;
            }
            if (this.isToken("elsif")) {
                return block;
            }
            if (this.isToken("end")) {
                return block;
            }
            if (this.isToken("when")) {
                return block;
            }
            if (this.isToken("if")) {
                block.putCode((CodeElement)this.parseIf(new If((CodeElement)block)));
                continue;
            }
            if (this.isToken("for")) {
                block.putCode((CodeElement)this.parseFor(new For((CodeElement)block)));
                continue;
            }
            if (this.isToken("while")) {
                block.putCode((CodeElement)this.parseWhile(new While((CodeElement)block)));
                continue;
            }
            if (this.isToken("loop")) {
                block.putCode((CodeElement)this.parseLoop(new Loop((CodeElement)block)));
                continue;
            }
            if (this.isToken("case")) {
                block.putCode((CodeElement)this.parseCase(new CaseBlock((CodeElement)block)));
                continue;
            }
            if (this.isToken("declare") || this.isToken("begin")) {
                block.putCode((CodeElement)this.parseBlockCode(new BlockElement((CodeElement)block, "Block")));
                continue;
            }
            if (this.isToken("<<")) {
                block.putCode((CodeElement)this.parseGotoLabel(new GotoLabel((CodeElement)block)));
                continue;
            }
            if (this.isToken("exception")) {
                return block;
            }
            block.putCode((CodeElement)this.parseStatement(block, new Statement((CodeElement)block)));
        }
        return block;
    }

    private BlockElement parseBlockCode(BlockElement block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.parseBlock(block);
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private BlockElement parseBlock(BlockElement block) throws ParserException {
        this.skipBlank();
        if (this.isToken("declare")) {
            this.nextToken(true);
        }
        this.parseDeclares(block);
        block.setBeginBlockOffset(this.getStartOffset());
        if (!this.isToken("end") && !this.isToken(")")) {
            this.parseBlockStatements(block);
            if (this.isToken("exception")) {
                block.setExceptionBlock(this.parseException(new ExceptionBlock((CodeElement)block)));
            }
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private CallableElement parseCallable(CallableElement block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        block.setName(this.parseIdentifier());
        this.skipBlank();
        if (this.isToken("(")) {
            this.parseParameters((CodeElement)block, block.getParameterList());
        }
        if (this.isToken("return")) {
            this.nextToken(true);
            CallableParameter param = new CallableParameter((CodeElement)block);
            param.setStartOffset(this.getStartOffset());
            if (this.isToken("self")) {
                param.setName(this.getTokenString());
                this.nextToken(true);
                if (this.isToken("as")) {
                    this.nextToken(true);
                }
            }
            StringBuilder sb = new StringBuilder();
            while (!(this.isToken("is") || this.isToken("as") || this.isToken(";") || this.isToken(","))) {
                if (this.getToken().styleId != 2 && this.getToken().styleId != 16) {
                    sb.append(this.getTokenString());
                } else {
                    sb.append("");
                }
                this.nextToken(true);
            }
            param.setType(sb.toString().trim());
            param.setEndOffset(this.getEndOffset());
            block.getParameterList().add(param);
        }
        if (!this.isToken(";") && !this.isToken(",")) {
            while (!this.isToken("as") && !this.isToken("is")) {
                this.nextToken(true);
            }
            this.nextToken(true);
            this.parseBlock((BlockElement)block);
            if (this.isToken(block.getName())) {
                this.nextToken(true);
            }
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private Trigger parseTrigger(Trigger block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        block.setName(this.parseIdentifier());
        while (!this.isToken("begin") && !this.isToken("declare")) {
            this.nextToken(true);
        }
        this.parseBlock((BlockElement)block);
        if (this.isToken(block.getName())) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private Cursor parseCursor(Cursor block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        block.setName(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 9);
        this.nextToken(true);
        if (this.isToken("(")) {
            this.parseParameters((CodeElement)block, block.getParameterList());
            this.nextToken(true);
        }
        this.nextToken(true);
        while (!this.isToken(";")) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private Type parseType(Type block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        block.setName(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 10);
        this.nextToken(true);
        int roundedParenth = 0;
        while (!this.isToken(";")) {
            if (this.isToken("(")) {
                ++roundedParenth;
            } else if (this.isToken(")")) {
                --roundedParenth;
            }
            this.nextToken(true);
            if (!this.isToken(",") || roundedParenth != 0) continue;
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private BlockElement parsePackage(Package block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        if (this.isToken("body")) {
            this.nextToken(true);
        }
        block.setName(this.parseIdentifier());
        while (!this.isToken("as") && !this.isToken("is")) {
            this.nextToken(true);
        }
        this.nextToken(true);
        this.parseBlock(block);
        if (this.isToken(block.getName())) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private BlockElement parseTypeObject(TypeObject block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        if (this.isToken("body")) {
            this.nextToken(true);
        }
        block.setName(this.parseIdentifier());
        this.putKeyWord(this.getTokenString(), 10);
        while (!this.isToken("as") && !this.isToken("is")) {
            this.nextToken(true);
        }
        this.nextToken(true);
        if (this.isToken("object")) {
            this.nextToken(true);
        }
        if (this.isToken("(")) {
            this.nextToken(true);
            this.parseBlock(block);
            if (this.isToken(")")) {
                this.nextToken(true);
            }
        } else {
            this.parseBlock(block);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }
}

