/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.syntax.SyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleUtil {
    public static SyntaxDocument.LineMark[] getErrLines(Query errorQuery, Color bkColor, ImageIcon errIcon) {
        ArrayList<SyntaxDocument.LineMark> lineList = new ArrayList<SyntaxDocument.LineMark>();
        try {
            errorQuery.first();
            while (!errorQuery.eof()) {
                lineList.add(new SyntaxDocument.LineMark(errorQuery.fieldByName("line").getInteger(), bkColor, errIcon, errorQuery.fieldByName("text").getString()));
                errorQuery.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        return lineList.toArray(new SyntaxDocument.LineMark[lineList.size()]);
    }

    public static Icon getObjectIcon(String objectType) {
        if ("TRIGGER".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/trigger.gif");
        }
        if ("FUNCTION".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/function.gif");
        }
        if ("JAVA CLASS".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/java_class.gif");
        }
        if ("JAVA SOURCE".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/java_source.gif");
        }
        if ("MATERIALIZED VIEW".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/mview.gif");
        }
        if ("PACKAGE".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/package.gif");
        }
        if ("PACKAGE BODY".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/package.gif");
        }
        if ("PROCEDURE".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/procedure.gif");
        }
        if ("TABLE".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/table.gif");
        }
        if ("TYPE".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/type.gif");
        }
        if ("VIEW".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/view.gif");
        }
        if ("DATABASE LINK".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/db_link.gif");
        }
        if ("SYNONYM".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/synonym.gif");
        }
        if ("DIRECTORY".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/directory.gif");
        }
        if ("SEQUENCE".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/sequence.gif");
        }
        if ("INDEX".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/index.gif");
        }
        if ("COLUMN".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/column.gif");
        }
        if ("ATTRIBUTE".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/member.gif");
        }
        if ("MEMBER".equalsIgnoreCase(objectType)) {
            return ImageManager.getImage((String)"/pl/mpak/res/icons/member.gif");
        }
        return null;
    }

    public static String prepareSqlFromPLSQL(List<SyntaxEditor.TokenRef> tokens) {
        if (tokens == null) {
            return null;
        }
        boolean select = false;
        boolean insert = false;
        Iterator<SyntaxEditor.TokenRef> i = tokens.iterator();
        block0: while (i.hasNext()) {
            SyntaxEditor.TokenRef token = i.next();
            if (token.isTokenIgnoreCase("CURSOR")) {
                i.remove();
                while (i.hasNext()) {
                    token = i.next();
                    i.remove();
                    if (!token.isTokenIgnoreCase("IS")) continue;
                }
            }
            if (!select && !insert && token.isTokenIgnoreCase("SELECT")) {
                select = true;
            }
            if (!select && !insert && token.isTokenIgnoreCase("INSERT")) {
                insert = true;
            }
            if (token.styleId == 21) {
                token.token = ":" + token.token;
                if (!i.hasNext() || !(token = i.next()).isToken(".")) continue;
                token.token = "_";
                continue;
            }
            if (token.styleId == 15) {
                if (!i.hasNext() || !(token = i.next()).isToken(".")) continue;
                token.token = "_";
                continue;
            }
            if (!insert && token.isTokenIgnoreCase("INTO")) {
                token.token = "/*" + token.token;
                while (i.hasNext()) {
                    token = i.next();
                    if (!token.isTokenIgnoreCase("FROM")) continue;
                    token.token = "*/ " + token.token;
                    continue block0;
                }
                continue;
            }
            if (i.hasNext() || !token.isToken(";")) continue;
            i.remove();
        }
        StringBuilder sb = new StringBuilder();
        for (SyntaxEditor.TokenRef token : tokens) {
            sb.append(token.token);
        }
        return sb.toString();
    }
}

