/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.util;

import java.awt.EventQueue;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class SourceCreator {
    private ISettings settings;
    private Database database;
    private SyntaxTextArea textArea;

    public SourceCreator(Database database) {
        this.database = database;
    }

    public SourceCreator(Database database, SyntaxTextArea textArea) {
        this(database);
        this.textArea = textArea;
        this.settings = Application.get().getSettings(database.getUserProperties().getProperty("schemaId"), "oracle-source-creator-settings");
    }

    public String getSource(String schemaName, String objectType, String objectName) {
        return this.getSource(schemaName, objectType, objectName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSource(final String schemaName, final String objectType, final String objectName, String overload) {
        String source;
        PleaseWait wait;
        if (this.textArea != null) {
            wait = PleaseWait.createSqlWait();
            Application.get().startPleaseWait(wait);
        } else {
            wait = null;
        }
        try {
            if (!StringUtil.equals((String)objectName, (String)"")) {
                if ("CALL".equalsIgnoreCase(objectType)) {
                    source = this.getCall(schemaName, objectName, overload);
                } else if (StringUtil.equalAnyOfString((String)objectType, (String[])new String[]{"FUNCTION", "PROCEDURE", "PACKAGE", "PACKAGE SPEC", "PACKAGE BODY", "TYPE", "TYPE BODY", "TRIGGER", "JAVA SOURCE"}, (boolean)true)) {
                    source = this.getPlSql(schemaName, objectType, objectName);
                } else {
                    this.setTransformSettings(null);
                    source = this.getDDL(schemaName, objectType, objectName);
                }
            } else {
                source = "";
            }
        }
        finally {
            if (wait != null) {
                Application.get().stopPleaseWait(wait);
            }
        }
        if (this.textArea != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (SourceCreator.this.textArea instanceof OrbadaSyntaxTextArea) {
                        ((OrbadaSyntaxTextArea)SourceCreator.this.textArea).setDatabaseObject(schemaName, objectType, objectName, source);
                    } else if (SourceCreator.this.textArea instanceof OrbadaJavaSyntaxTextArea) {
                        ((OrbadaJavaSyntaxTextArea)SourceCreator.this.textArea).setDatabaseObject(schemaName, objectType, objectName, source);
                    }
                    SourceCreator.this.textArea.getEditorArea().setCaretPosition(0);
                }
            });
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCall(String schemaName, String objectName, String overload) {
        String resultTo = "";
        StringBuffer sqlText = new StringBuffer();
        Query args = this.database.createQuery();
        try {
            String objectCall;
            block13: {
                objectCall = "UNKNOWN";
                Query ocall = this.database.createQuery();
                try {
                    ocall.setSqlText(Sql.getObjectForCall());
                    ocall.paramByName("SCHEMA_NAME").setString(schemaName);
                    ocall.paramByName("OBJECT_NAME").setString(objectName);
                    ocall.open();
                    if (!ocall.eof()) {
                        objectCall = SQLUtil.createSqlName((String)ocall.fieldByName("schema_name").getString(), (String)ocall.fieldByName("package_name").getString(), (String)ocall.fieldByName("object_name").getString());
                        break block13;
                    }
                    String string = null;
                    return string;
                }
                finally {
                    ocall.close();
                }
            }
            args.setSqlText(Sql.getArgumentsForCall());
            args.paramByName("SCHEMA_NAME").setString(schemaName);
            args.paramByName("OBJECT_NAME").setString(objectName);
            args.paramByName("OVERLOAD").setString(overload);
            args.open();
            sqlText.append("BEGIN\n");
            if (!args.eof() && args.fieldByName("position").getInteger() == 0) {
                sqlText.setLength(0);
                sqlText.append("DECLARE\n");
                sqlText.append("  " + args.fieldByName("argument_name").getString() + " VARCHAR(4000);\n");
                sqlText.append("BEGIN\n");
                resultTo = "  DBMS_OUTPUT.PUT_LINE( " + args.fieldByName("argument_name").getString() + " );\n";
                sqlText.append("  " + args.fieldByName("argument_name").getString() + " := /* " + args.fieldByName("data_type").getString() + " */\n");
                args.next();
            }
            sqlText.append("    " + objectCall + "(");
            int ic = 0;
            while (!args.eof()) {
                if (ic > 0) {
                    sqlText.append(",");
                }
                sqlText.append("\n      :" + args.fieldByName("argument_name").getString() + " /* " + args.fieldByName("data_type").getString() + " " + args.fieldByName("in_out").getString() + " */");
                args.next();
                ++ic;
            }
            sqlText.append((ic > 0 ? "\n    " : "") + ");\n");
            sqlText.append(resultTo);
            sqlText.append("END;");
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            args.close();
        }
        return sqlText.toString();
    }

    private void setTransformSettings(String obejctType) {
        Command command;
        if (obejctType == null) {
            command = this.database.createCommand();
            try {
                command.setSqlText(Sql.getSourceCreatorAll());
                command.paramByName("&PRETTY").setBoolean(this.settings.getValue("ALL-PRETTY", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&SQLTERMINATOR").setBoolean(this.settings.getValue("ALL-SQLTERMINATOR", Boolean.valueOf(false)).booleanValue());
                command.execute();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        if ("TABLE".equals(obejctType)) {
            command = this.database.createCommand();
            try {
                command.setSqlText(Sql.getSourceCreatorTable());
                command.paramByName("&SEGMENT_ATTRIBUTES").setBoolean(this.settings.getValue("TABLE-SEGMENT_ATTRIBUTES", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&STORAGE").setBoolean(this.settings.getValue("TABLE-STORAGE", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&TABLESPACE").setBoolean(this.settings.getValue("TABLE-TABLESPACE", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&CONSTRAINTS").setBoolean(this.settings.getValue("TABLE-CONSTRAINTS", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&REF_CONSTRAINTS").setBoolean(this.settings.getValue("TABLE-REF_CONSTRAINTS", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&CONSTRAINTS_AS_ALTER").setBoolean(this.settings.getValue("TABLE-CONSTRAINTS_AS_ALTER", Boolean.valueOf(false)).booleanValue());
                command.paramByName("&SIZE_BYTE_KEYWORD").setBoolean(this.settings.getValue("TABLE-SIZE_BYTE_KEYWORD", Boolean.valueOf(false)).booleanValue());
                command.execute();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        if ("INDEX".equals(obejctType)) {
            command = this.database.createCommand();
            try {
                command.setSqlText(Sql.getSourceCreatorIndex());
                command.paramByName("&SEGMENT_ATTRIBUTES").setBoolean(this.settings.getValue("INDEX-SEGMENT_ATTRIBUTES", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&STORAGE").setBoolean(this.settings.getValue("INDEX-STORAGE", Boolean.valueOf(true)).booleanValue());
                command.paramByName("&TABLESPACE").setBoolean(this.settings.getValue("INDEX-TABLESPACE", Boolean.valueOf(true)).booleanValue());
                command.execute();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        if ("VIEW".equals(obejctType)) {
            command = this.database.createCommand();
            try {
                command.setSqlText(Sql.getSourceCreatorView());
                command.paramByName("&FORCE").setBoolean(this.settings.getValue("VIEW-FORCE", Boolean.valueOf(false)).booleanValue());
                command.execute();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDDL(String schemaName, String objectType, String objectName) {
        this.setTransformSettings(objectType);
        StringBuffer sqlText = new StringBuffer();
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getObjectDDL());
            source.paramByName("SCHEMA_NAME").setString(schemaName);
            source.paramByName("OBJECT_TYPE").setString(objectType);
            source.paramByName("OBJECT_NAME").setString(objectName);
            if (this.settings.getValue("ALL-LATEST", Boolean.valueOf(false)).booleanValue()) {
                source.paramByName("VERSION").setString("LATEST");
            } else {
                source.paramByName("VERSION").setString("COMPATIBLE");
            }
            source.open();
            if (source.eof()) {
                String string = null;
                return string;
            }
            sqlText.append(source.fieldByName("SOURCE").getString().trim());
            sqlText.append("\n/\n");
        }
        catch (Exception ex) {
            if ("VIEW".equals(objectType)) {
                sqlText.append(this.createView(schemaName, objectName));
            } else if ("TABLE".equals(objectType)) {
                sqlText.append(this.createTable(schemaName, objectName));
            } else {
                sqlText.append("-- Nie mo\u017cna pobra\u0107 skryptu " + objectType + " przy pomocy DBMS_METADATA.GET_DDL()\n");
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        finally {
            source.close();
        }
        if (StringUtil.equalAnyOfString((String)objectType, (String[])new String[]{"TABLE", "MATERIALIZED_VIEW"}, (boolean)true)) {
            this.setTransformSettings("INDEX");
            Query indexes = this.database.createQuery();
            try {
                indexes.setSqlText(Sql.getIndexSource());
                indexes.paramByName("SCHEMA_NAME").setString(schemaName);
                indexes.paramByName("TABLE_NAME").setString(objectName);
                if (this.settings.getValue("ALL-LATEST", Boolean.valueOf(false)).booleanValue()) {
                    indexes.paramByName("VERSION").setString("LATEST");
                } else {
                    indexes.paramByName("VERSION").setString("COMPATIBLE");
                }
                indexes.open();
                while (!indexes.eof()) {
                    sqlText.append(indexes.fieldByName("SOURCE").getString().trim());
                    sqlText.append("\n/\n");
                    indexes.next();
                }
            }
            catch (Exception ex) {
                sqlText.append(this.createIndexes(schemaName, objectName));
            }
            finally {
                indexes.close();
            }
        }
        if (StringUtil.equalAnyOfString((String)objectType, (String[])new String[]{"TABLE", "VIEW", "MATERIALIZED_VIEW"}, (boolean)true)) {
            this.appendComments(sqlText, schemaName, objectName);
        }
        return sqlText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendComments(StringBuffer sqlText, String schemaName, String objectName) {
        Query comments = this.database.createQuery();
        try {
            comments.setSqlText(Sql.getTableComments());
            comments.paramByName("SCHEMA_NAME").setString(schemaName);
            comments.paramByName("TABLE_NAME").setString(objectName);
            comments.open();
            while (!comments.eof()) {
                sqlText.append(comments.fieldByName("SOURCE").getString());
                sqlText.append("\n/\n");
                comments.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            comments.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createView(String schemaName, String objectName) {
        String refrMode = "";
        StringBuffer columns = new StringBuffer();
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getViewColumnDestList());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("VIEW_NAME").setString(objectName);
            query.open();
            int clength = 0;
            while (!query.eof()) {
                if (columns.length() > 0) {
                    columns.append(", ");
                    if ((clength += 2) > 60) {
                        columns.append("\n");
                        clength = 0;
                    }
                }
                columns.append("\"" + query.fieldByName("COLUMN_NAME").getString() + "\"");
                clength += query.fieldByName("COLUMN_NAME").getString().length() + 2;
                query.next();
            }
            query.setSqlText(Sql.getViewSource());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("VIEW_NAME").setString(objectName);
            query.open();
            if (!query.eof()) {
                String view = query.fieldByName("text").getString();
                String string = String.format("CREATE OR REPLACE VIEW %s (\n%s) AS\n%s\n/\n", SQLUtil.createSqlName((String)schemaName, (String)objectName), columns, view);
                return string;
            }
            query.setSqlText(Sql.getSnapshotSource());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("VIEW_NAME").setString(objectName);
            query.open();
            String view = query.fieldByName("text").getString();
            if (StringUtil.equalAnyOfString((String)query.fieldByName("REFRESH_MODE").getString(), (String[])new String[]{"DEMAND", "COMMIT"}, (boolean)true)) {
                refrMode = " ON " + query.fieldByName("REFRESH_MODE").getString();
            } else if (StringUtil.equalAnyOfString((String)query.fieldByName("REFRESH_MODE").getString(), (String[])new String[]{"PRIMARY KEY", "ROWID"}, (boolean)true)) {
                refrMode = " WITH " + query.fieldByName("REFRESH_MODE").getString();
            } else if (!query.fieldByName("REFRESH_MODE").isNull()) {
                refrMode = " " + query.fieldByName("REFRESH_MODE").getString();
            }
            String string = String.format("CREATE OR REPLACE MATERIALIZED VIEW %s%s AS\n%s\n/\n", SQLUtil.createSqlName((String)schemaName, (String)objectName), refrMode, view);
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createIndexColumnList(String schemaName, String indexName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getIndexColumnListForScript());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("INDEX_NAME").setString(indexName);
            query.open();
            String result = "(";
            boolean firstTime = true;
            while (!query.eof()) {
                if (!firstTime) {
                    result = result + ", ";
                }
                result = result + "\"" + query.fieldByName("COLUMN_NAME").getString() + "\"";
                if (!"ASC".equals(query.fieldByName("DESCEND").getString())) {
                    result = result + " DESC";
                }
                firstTime = false;
                query.next();
            }
            String string = result + ")";
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    private String createIndex(String schemaName, String indexName, String unique, String tableOwner, String tableName) {
        String result = "CREATE " + ("UNIQUE".equals(unique) ? "UNIQUE " : "") + "INDEX " + SQLUtil.createSqlName((String)schemaName, (String)indexName);
        result = result + " ON " + SQLUtil.createSqlName((String)tableOwner, (String)tableName) + this.createIndexColumnList(schemaName, indexName);
        return result + "\n/\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createIndexes(String schemaName, String objectName) {
        StringBuffer sb = new StringBuffer();
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getIndexListForScript());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TABLE_NAME").setString(objectName);
            query.open();
            while (!query.eof()) {
                sb.append(this.createIndex(query.fieldByName("OWNER").getString(), query.fieldByName("INDEX_NAME").getString(), query.fieldByName("UNIQUENESS").getString(), query.fieldByName("TABLE_OWNER").getString(), query.fieldByName("TABLE_NAME").getString()));
                query.next();
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createConstraintColumnList(String schemaName, String constrName, Boolean ref) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getConstraintColumnListForScript());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("CONSTRAINT_NAME").setString(constrName);
            query.open();
            String result = "";
            if (ref.booleanValue()) {
                result = result + SQLUtil.createSqlName((String)query.fieldByName("OWNER").getString(), (String)query.fieldByName("TABLE_NAME").getString());
            }
            result = result + "(";
            boolean firstTime = true;
            while (!query.eof()) {
                if (!firstTime) {
                    result = result + ", ";
                }
                result = result + "\"" + query.fieldByName("COLUMN_NAME").getString() + "\"";
                firstTime = false;
                query.next();
            }
            String string = result + ")";
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    private String createConstraint(String schemaName, String tableName, String constrName, String rOwner, String rConstrName, String constrType, String deleteRule, String condition, String status, String deferrable, String deferred) {
        String state = "";
        String result = "ALTER TABLE " + SQLUtil.createSqlName((String)schemaName, (String)tableName) + " ADD CONSTRAINT " + SQLUtil.createSqlName((String)schemaName, (String)constrName) + "\n";
        if ("C".equals(constrType)) {
            result = result + "  CHECK (" + condition + ")";
        } else if ("U".equals(constrType)) {
            result = result + "  UNIQUE " + this.createConstraintColumnList(schemaName, constrName, false);
        } else if ("P".equals(constrType)) {
            result = result + "  PRIMARY KEY " + this.createConstraintColumnList(schemaName, constrName, false);
        } else if ("R".equals(constrType)) {
            result = result + "  FOREIGN KEY " + this.createConstraintColumnList(schemaName, constrName, false) + " REFERENCES " + this.createConstraintColumnList(rOwner, rConstrName, true);
            if (!"NO ACTION".equals(deleteRule)) {
                result = result + " ON DELETE " + deleteRule;
            }
        }
        if (!"NOT DEFERRABLE".equals(deferrable)) {
            state = state + " " + deferrable;
        }
        if (!"IMMEDIATE".equals(deferred)) {
            state = state + " INITIALLY " + deferred;
        }
        if (!"ENABLED".equals(status)) {
            state = state + " DISABLE ";
        }
        if (!"".equals(state)) {
            result = result + "\n " + state;
        }
        return result + "\n/\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createConstraints(String schemaName, String objectName) {
        StringBuffer sb = new StringBuffer();
        Query query = this.database.createQuery();
        try {
            String searchCond;
            query.setSqlText(Sql.getConstraintListForScript());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TABLE_NAME").setString(objectName);
            query.open();
            while (!query.eof()) {
                searchCond = query.fieldByName("SEARCH_CONDITION").getString();
                sb.append(this.createConstraint(query.fieldByName("OWNER").getString(), objectName, query.fieldByName("CONSTRAINT_NAME").getString(), query.fieldByName("R_OWNER").getString(), query.fieldByName("R_CONSTRAINT_NAME").getString(), query.fieldByName("CONSTRAINT_TYPE").getString(), query.fieldByName("DELETE_RULE").getString(), searchCond, query.fieldByName("STATUS").getString(), query.fieldByName("DEFERRABLE").getString(), query.fieldByName("DEFERRED").getString()));
                query.next();
            }
            searchCond = sb.toString();
            return searchCond;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTable(String schemaName, String objectName) {
        StringBuilder columns = new StringBuilder();
        Query query = this.database.createQuery();
        try {
            String defaultValue;
            query.setSqlText(Sql.getColumnList(null));
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TABLE_NAME").setString(objectName);
            query.open();
            while (!query.eof()) {
                if (columns.length() > 0) {
                    columns.append(",\n");
                }
                defaultValue = query.fieldByName("data_default").getString().trim();
                columns.append("  \"" + query.fieldByName("COLUMN_NAME").getString() + "\" " + query.fieldByName("display_type").getString());
                if (!StringUtil.isEmpty((String)defaultValue)) {
                    columns.append(" DEFAULT " + defaultValue);
                }
                if (!"YES".equals(query.fieldByName("nullable").getString())) {
                    columns.append(" NOT NULL");
                }
                query.next();
            }
            defaultValue = String.format("CREATE TABLE %s (\n%s\n)\n/\n%s", SQLUtil.createSqlName((String)schemaName, (String)objectName), columns.toString(), this.createConstraints(schemaName, objectName));
            return defaultValue;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPlSql(String schemaName, String objectType, String objectName) {
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getObjectPlSql());
            source.paramByName("SCHEMA_NAME").setString(schemaName);
            if ("PACKAGE SPEC".equals(objectType)) {
                objectType = "PACKAGE";
            }
            source.paramByName("OBJECT_TYPE").setString(objectType);
            source.paramByName("OBJECT_NAME").setString(objectName);
            source.open();
            StringBuffer sb = new StringBuffer();
            if (!source.eof()) {
                if ("JAVA SOURCE".equals(objectType)) {
                    sb.append("CREATE OR REPLACE AND COMPILE JAVA SOURCE NAMED " + SQLUtil.createSqlName((String)schemaName, (String)objectName) + " AS\n");
                } else {
                    sb.append("CREATE OR REPLACE ");
                }
                while (!source.eof()) {
                    sb.append(source.fieldByName("SOURCE").getString());
                    source.next();
                }
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return null;
    }
}

