/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import pl.mpak.mpak.oracle.tune.OrbadaOracleTunePlugin;
import pl.mpak.mpak.oracle.tune.Sql;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class AutotracePanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleTunePlugin.class);
    private Database database;
    private HashMap<String, String> fullMap;
    private ArrayList<String[]> fullList;
    private ArrayList<String[]> diffList;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private Table tableLastSql;
    private Table tableSession;

    public AutotracePanel(Database database) {
        this.database = database;
        this.fullMap = new HashMap();
        this.fullList = new ArrayList();
        this.diffList = new ArrayList();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableLastSql.setSelectionMode(0);
        this.tableLastSql.setModel((TableModel)new AbstractTableModel(){

            public String getColumnName(int column) {
                if (column == 0) {
                    return AutotracePanel.this.stringManager.getString("name");
                }
                if (column == 1) {
                    return AutotracePanel.this.stringManager.getString("value");
                }
                return "???";
            }

            public int getRowCount() {
                return AutotracePanel.this.diffList.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])AutotracePanel.this.diffList.get(rowIndex))[columnIndex];
            }
        });
        this.tableSession.setSelectionMode(0);
        this.tableSession.setModel((TableModel)new AbstractTableModel(){

            public String getColumnName(int column) {
                if (column == 0) {
                    return AutotracePanel.this.stringManager.getString("name");
                }
                if (column == 1) {
                    return AutotracePanel.this.stringManager.getString("value");
                }
                return "???";
            }

            public int getRowCount() {
                return AutotracePanel.this.fullList.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])AutotracePanel.this.fullList.get(rowIndex))[columnIndex];
            }
        });
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeSql() {
        this.diffList.clear();
        this.fullList.clear();
        Query query = this.database.createQuery();
        try {
            query.open(Sql.getStatsList());
            while (!query.eof()) {
                this.fullMap.put(query.fieldByName("name").getString(), query.fieldByName("value").getString());
                query.next();
            }
            for (Map.Entry<String, String> e : this.fullMap.entrySet()) {
                this.fullList.add(new String[]{e.getKey(), e.getValue()});
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.tableLastSql.revalidate();
        this.tableSession.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSql() {
        Query query = this.database.createQuery();
        try {
            query.open(Sql.getStatsList());
            while (!query.eof()) {
                String value = this.fullMap.get(query.fieldByName("name").getString());
                if (value != null && !value.equals(query.fieldByName("value").getString())) {
                    value = String.valueOf(query.fieldByName("value").getLong() - Long.parseLong(value));
                    this.diffList.add(new String[]{query.fieldByName("name").getString(), value});
                }
                this.fullMap.put(query.fieldByName("name").getString(), query.fieldByName("value").getString());
                query.next();
            }
            for (Map.Entry<String, String> e : this.fullMap.entrySet()) {
                this.fullList.add(new String[]{e.getKey(), e.getValue()});
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.tableLastSql.revalidate();
        this.tableSession.revalidate();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.tableLastSql = new Table();
        this.jScrollPane2 = new JScrollPane();
        this.tableSession = new Table();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setFocusable(false);
        this.tableLastSql.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Nazwa parametru", "Warto\u015b\u0107"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableLastSql.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView((Component)this.tableLastSql);
        this.jTabbedPane1.addTab(this.stringManager.getString("sql-command"), this.jScrollPane1);
        this.tableSession.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Nazwa parametru", "Warto\u015b\u0107"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableSession.setAutoResizeMode(4);
        this.jScrollPane2.setViewportView((Component)this.tableSession);
        this.jTabbedPane1.addTab(this.stringManager.getString("session"), this.jScrollPane2);
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

