/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pl.mpak.mpak.oracle.tune.OrbadaOracleTunePlugin;
import pl.mpak.mpak.oracle.tune.Sql;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.freezing.FreezeFactory;
import pl.mpak.orbada.oracle.gui.freezing.FreezeViewService;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class SqlPlanPanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleTunePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private FreezeFactory freezeFactory;
    private ISettings settings;
    private Timer timer;
    private boolean ora10plus;
    private boolean schemaChanged;
    private boolean col_last_active_time;
    private boolean col_parsing_schema_name;
    private ToolButton buttonActionsObjects;
    private ToolButton buttonActionsSql;
    private ToolButton buttonFilter;
    private ToolButton buttonFreeze;
    private ToolButton buttonRefresh;
    private ToolButton buttonSearch;
    private ToolButton buttonSelectSchema;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private Action cmSearch;
    private Action cmSelectSchema;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar jToolBar1;
    private JPopupMenu menuActionsObjects;
    private JPopupMenu menuActionsSql;
    private JPanel panelSearch;
    private JSplitPane splitObjects;
    private JSplitPane splitPlan;
    private JSplitPane splitSql;
    private QueryTableStatusBar statusBar;
    private QueryTableStatusBar statusBarObjects;
    private OrbadaSyntaxTextArea syntaxSql;
    private ViewTable tableObjects;
    private ViewTable tableSql;
    private TextField textSearch;
    private JToolBar toolBar;
    private JTree treePlan;

    public SqlPlanPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.freezeFactory = new FreezeFactory(accesibilities);
        this.ora10plus = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("Ora10+"));
        this.col_last_active_time = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("V%SQL.LAST_ACTIVE_TIME"));
        this.col_parsing_schema_name = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("V%SQL.PARSING_SCHEMA_NAME"));
        this.initComponents();
        this.init();
    }

    private void init() {
        this.syntaxSql.setDatabase(this.getDatabase());
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                SqlPlanPanelView.this.refreshPlan();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-tune-sql-plan-panel");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlPlanPanelView.this.splitPlan.setDividerLocation(SqlPlanPanelView.this.settings.getValue("split-plan", Long.valueOf(SqlPlanPanelView.this.splitPlan.getDividerLocation())).intValue());
                SqlPlanPanelView.this.splitObjects.setDividerLocation(SqlPlanPanelView.this.settings.getValue("split-objects", Long.valueOf((long)SqlPlanPanelView.this.splitObjects.getWidth() - 250L)).intValue());
                SqlPlanPanelView.this.splitSql.setDividerLocation(SqlPlanPanelView.this.settings.getValue("split-sql", Long.valueOf((long)((float)SqlPlanPanelView.this.splitSql.getWidth() * 0.4f))).intValue());
            }
        });
        this.cmSelectSchema.setEnabled(this.ora10plus);
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema((Database)this.getDatabase());
        this.tableObjects.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SqlPlanPanelView.this.tableObjects.getSelectedRow() >= 0) {
                    try {
                        SqlPlanPanelView.this.tableObjects.getQuery().getRecord(SqlPlanPanelView.this.tableObjects.getSelectedRow());
                        SqlPlanPanelView.this.cmFreezeObject.setEnabled(SqlPlanPanelView.this.freezeFactory.canCreate(SqlPlanPanelView.this.tableObjects.getQuery().fieldByName("object_type").getString()));
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableSql.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SqlPlanPanelView.this.timer.restart();
            }
        });
        this.tableSql.getQuery().setDatabase(this.getDatabase());
        try {
            if (this.ora10plus) {
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("optimizer_mode", this.stringManager.getString("optimizer-mode"), 100));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("optimizer_cost", this.stringManager.getString("optimizer-cost"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("sql_fulltext", this.stringManager.getString("sql-fulltext"), 400));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("cpu_time", this.stringManager.getString("cpu-time"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("elapsed_time", this.stringManager.getString("elapsed-time"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("sharable_mem", this.stringManager.getString("sharable-mem"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("persistent_mem", this.stringManager.getString("persistent-mem"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("runtime_mem", this.stringManager.getString("runtime-mem"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("fetches", this.stringManager.getString("fetches"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("executions", this.stringManager.getString("executions"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("parse_calls", this.stringManager.getString("parse-calls"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("disk_reads", this.stringManager.getString("disk-reads"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("direct_writes", this.stringManager.getString("direct-writes"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("buffer_gets", this.stringManager.getString("buffer-gets"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("concurrency_wait_time", this.stringManager.getString("concurrency-wait-time"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("user_io_wait_time", this.stringManager.getString("user-io-wait-time"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("plsql_exec_time", this.stringManager.getString("plsql-exec-time"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("rows_processed", this.stringManager.getString("rows-processed"), 70));
                if (this.col_last_active_time) {
                    this.tableSql.addColumn((TableColumn)new QueryTableColumn("last_active_time", this.stringManager.getString("last-active-time"), 120));
                }
            } else {
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("optimizer_mode", this.stringManager.getString("optimizer-mode"), 100));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("optimizer_cost", this.stringManager.getString("optimizer-cost"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("sql_text", this.stringManager.getString("sql-fulltext"), 400));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("cpu_time", this.stringManager.getString("cpu-time"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("elapsed_time", this.stringManager.getString("elapsed-time"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("sharable_mem", this.stringManager.getString("sharable-mem"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("persistent_mem", this.stringManager.getString("persistent-mem"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("runtime_mem", this.stringManager.getString("runtime-mem"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("fetches", this.stringManager.getString("fetches"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("executions", this.stringManager.getString("executions"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("parse_calls", this.stringManager.getString("parse-calls"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("disk_reads", this.stringManager.getString("disk-reads"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("buffer_gets", this.stringManager.getString("buffer-gets"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("rows_processed", this.stringManager.getString("rows-processed"), 70));
                this.tableSql.addColumn((TableColumn)new QueryTableColumn("last_load_time", this.stringManager.getString("last-active-time"), 120));
            }
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("s.optimizer_mode", this.stringManager.getString("optimizer-mode"), new String[]{"'CHOOSE'", "'RULE'", "'ALL_ROWS'", "'FIRST_ROWS'"}));
            def.add(new SqlFilterDefComponent("s.optimizer_cost", this.stringManager.getString("optimizer-cost"), (String[])null));
            def.add(new SqlFilterDefComponent("s.cpu_time", this.stringManager.getString("cpu-time"), (String[])null));
            def.add(new SqlFilterDefComponent("s.executions", this.stringManager.getString("executions"), (String[])null));
            def.add(new SqlFilterDefComponent("s.rows_processed", this.stringManager.getString("rows-processed"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-tune-sqls-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.tableObjects.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("object_owner", this.stringManager.getString("schema-name"), 100));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 150));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 100));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.textSearch.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.tableSql));
        SwingUtil.addAction((JComponent)this.textSearch, (javax.swing.Action)this.cmSearch);
        SwingUtil.addAction((JComponent)this.tableObjects, (javax.swing.Action)this.cmFreezeObject);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableSql, (JButton)this.buttonActionsSql, this.menuActionsSql, "oracle-tune-sql-plan-actions");
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableObjects, (JButton)this.buttonActionsObjects, this.menuActionsObjects, "oracle-tune-sql-plan-objects-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlPlanPanelView.this.textSearch.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema((Database)this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
            this.schemaChanged = true;
        }
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void fillTree(Query query, DefaultMutableTreeNode node) {
        try {
            if (query.eof()) {
                return;
            }
            long firstLevel = query.fieldByName("level").getLong();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(query.fieldByName("plan_output").getString());
            node.add(newNode);
            query.next();
            while (!query.eof()) {
                if (query.fieldByName("level").getLong() > firstLevel) {
                    this.fillTree(query, newNode);
                    continue;
                }
                if (query.fieldByName("level").getLong() >= firstLevel) {
                    newNode = new DefaultMutableTreeNode(query.fieldByName("plan_output").getString());
                    node.add(newNode);
                    query.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void refreshPlan() {
        int index = this.tableSql.getSelectedRow();
        if (index >= 0) {
            try {
                this.tableSql.getQuery().getRecord(index);
                EventQueue.invokeLater(new Runnable(){
                    String text;
                    {
                        this.text = SqlPlanPanelView.this.tableSql.getQuery().fieldByName(SqlPlanPanelView.this.ora10plus ? "sql_fulltext" : "sql_text").getString();
                    }

                    public void run() {
                        SqlPlanPanelView.this.syntaxSql.setText(this.text);
                        SqlPlanPanelView.this.syntaxSql.setChanged(false);
                        SqlPlanPanelView.this.syntaxSql.getEditorArea().setCaretPosition(0, true);
                    }
                });
                int column = this.tableObjects.getSelectedColumn();
                this.tableObjects.getQuery().close();
                this.tableObjects.getQuery().setSqlText(Sql.getSqlObjectsList());
                this.tableObjects.getQuery().paramByName("ADDRESS").setString(this.tableSql.getQuery().fieldByName("ADDRESS").getString());
                this.tableObjects.getQuery().paramByName("HASH_VALUE").setString(this.tableSql.getQuery().fieldByName("HASH_VALUE").getString());
                this.tableObjects.getQuery().paramByName("CHILD_NUMBER").setString(this.tableSql.getQuery().fieldByName("CHILD_NUMBER").getString());
                this.tableObjects.getQuery().open();
                if (!this.tableObjects.getQuery().isEmpty()) {
                    this.tableObjects.changeSelection(Math.min(index, this.tableObjects.getRowCount() - 1), column, false, false);
                }
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Query query = SqlPlanPanelView.this.getDatabase().createQuery();
                        try {
                            query.setSqlText(Sql.getSqlPlanList(SqlPlanPanelView.this.ora10plus));
                            query.paramByName("ADDRESS").setString(SqlPlanPanelView.this.tableSql.getQuery().fieldByName("ADDRESS").getString());
                            query.paramByName("HASH_VALUE").setString(SqlPlanPanelView.this.tableSql.getQuery().fieldByName("HASH_VALUE").getString());
                            query.paramByName("CHILD_NUMBER").setString(SqlPlanPanelView.this.tableSql.getQuery().fieldByName("CHILD_NUMBER").getString());
                            query.open();
                            DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
                            SqlPlanPanelView.this.fillTree(query, root);
                            SqlPlanPanelView.this.treePlan.setModel(new DefaultTreeModel(root));
                            if (root.getChildCount() > 0) {
                                SqlPlanPanelView.this.treePlan.setSelectionInterval(0, 0);
                            }
                            SqlPlanPanelView.this.expandAll(SqlPlanPanelView.this.treePlan, new TreePath(root), true);
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                });
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        } else {
            this.syntaxSql.setText("");
            this.syntaxSql.setChanged(false);
            this.treePlan.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("root")));
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlPlanPanelView.this.refreshTableList();
            }
        });
    }

    private void refreshTableList() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableSql.getQuery().isActive() && this.tableSql.getSelectedRow() >= 0) {
                this.tableSql.getQuery().getRecord(this.tableSql.getSelectedRow());
                objectName = this.tableSql.getQuery().fieldByName("address").getString();
            }
            this.refreshTableList(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refreshTableList(String objectName) {
        try {
            int column = this.tableSql.getSelectedColumn();
            int index = Math.max(0, this.tableSql.getSelectedRow());
            this.tableSql.getQuery().close();
            this.tableSql.getQuery().setSqlText(Sql.getSqlList(this.filter.getSqlText(), this.ora10plus, this.col_last_active_time, this.col_parsing_schema_name));
            if (this.ora10plus) {
                this.tableSql.getQuery().paramByName("SCHEMA_NAME").setString(this.currentSchemaName);
            }
            this.tableSql.getQuery().paramByName("SEARCH").setString(this.textSearch.getText());
            this.tableSql.getQuery().open();
            if (!this.schemaChanged) {
                if (objectName != null && this.tableSql.getQuery().locate("address", new Variant(objectName))) {
                    this.tableSql.changeSelection(this.tableSql.getQuery().getCurrentRecord().getIndex(), column);
                } else if (!this.tableSql.getQuery().isEmpty()) {
                    this.tableSql.changeSelection(Math.min(index, this.tableSql.getRowCount() - 1), column);
                }
            } else if (!this.tableSql.getQuery().isEmpty()) {
                this.tableSql.changeSelection(0, column);
            }
            this.schemaChanged = false;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.timer.cancel();
        this.settings.setValue("split-plan", Long.valueOf(this.splitPlan.getDividerLocation()));
        this.settings.setValue("split-objects", Long.valueOf(this.splitObjects.getDividerLocation()));
        this.settings.setValue("split-sql", Long.valueOf(this.splitSql.getDividerLocation()));
        this.tableSql.getQuery().close();
        this.tableObjects.getQuery().close();
        this.syntaxSql.setDatabase(null);
        this.syntaxSql = null;
        this.accesibilities = null;
        this.settings.store();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActionsSql = new JPopupMenu();
        this.cmSearch = new Action();
        this.cmFreezeObject = new Action();
        this.menuActionsObjects = new JPopupMenu();
        this.splitPlan = new JSplitPane();
        this.splitObjects = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableSql = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActionsSql = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.panelSearch = new JPanel();
        this.jLabel1 = new JLabel();
        this.textSearch = new TextField();
        this.buttonSearch = new ToolButton();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.buttonActionsObjects = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonFreeze = new ToolButton();
        this.jPanel6 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tableObjects = new ViewTable();
        this.statusBarObjects = new QueryTableStatusBar();
        this.jPanel7 = new JPanel();
        this.splitSql = new JSplitPane();
        this.syntaxSql = new OrbadaSyntaxTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.treePlan = new JTree();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlPlanPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlPlanPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlPlanPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmSearch.setActionCommandKey("cmSearch");
        this.cmSearch.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmSearch.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_object16.gif"));
        this.cmSearch.setText(this.stringManager.getString("cmSearch-text"));
        this.cmSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlPlanPanelView.this.cmSearchActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlPlanPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SqlPlanPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitPlan.setBorder(null);
        this.splitPlan.setDividerLocation(300);
        this.splitPlan.setOrientation(0);
        this.splitPlan.setContinuousLayout(true);
        this.splitPlan.setOneTouchExpandable(true);
        this.splitObjects.setBorder(null);
        this.splitObjects.setDividerLocation(500);
        this.splitObjects.setContinuousLayout(true);
        this.splitObjects.setOneTouchExpandable(true);
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableSql);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableSql);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.jPanel3.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActionsSql);
        this.toolBar.add(this.jSeparator2);
        this.panelSearch.setLayout(new FlowLayout(0, 2, 3));
        this.jLabel1.setDisplayedMnemonic('S');
        this.jLabel1.setLabelFor((Component)this.textSearch);
        this.jLabel1.setText(this.stringManager.getString("search-dd"));
        this.panelSearch.add(this.jLabel1);
        this.textSearch.setPreferredSize(new Dimension(120, 20));
        this.panelSearch.add((Component)this.textSearch);
        this.toolBar.add(this.panelSearch);
        this.buttonSearch.setAction((javax.swing.Action)this.cmSearch);
        this.buttonSearch.setHorizontalTextPosition(0);
        this.buttonSearch.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSearch);
        this.jPanel2.add(this.toolBar);
        this.jPanel3.add((Component)this.jPanel2, "North");
        this.splitObjects.setLeftComponent(this.jPanel3);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new FlowLayout(0, 0, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonActionsObjects.setHorizontalTextPosition(0);
        this.buttonActionsObjects.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonActionsObjects);
        this.jToolBar1.add(this.jSeparator3);
        this.buttonFreeze.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreeze.setHorizontalTextPosition(0);
        this.buttonFreeze.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonFreeze);
        this.buttonFreeze.getAccessibleContext().setAccessibleParent(this.toolBar);
        this.jPanel5.add(this.jToolBar1);
        this.jPanel4.add((Component)this.jPanel5, "North");
        this.jPanel6.setLayout(new BorderLayout());
        this.tableObjects.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SqlPlanPanelView.this.tableObjectsMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.tableObjects);
        this.jPanel6.add((Component)this.jScrollPane2, "Center");
        this.statusBarObjects.setShowFieldType(false);
        this.statusBarObjects.setShowOpenTime(false);
        this.statusBarObjects.setTable((QueryTable)this.tableObjects);
        this.jPanel6.add((Component)this.statusBarObjects, "South");
        this.jPanel4.add((Component)this.jPanel6, "Center");
        this.splitObjects.setRightComponent(this.jPanel4);
        this.splitPlan.setLeftComponent(this.splitObjects);
        this.jPanel7.setLayout(new BorderLayout());
        this.splitSql.setBorder(null);
        this.splitSql.setDividerLocation(400);
        this.splitSql.setContinuousLayout(true);
        this.splitSql.setOneTouchExpandable(true);
        this.syntaxSql.setEditable(false);
        this.splitSql.setLeftComponent((Component)this.syntaxSql);
        this.treePlan.setModel(null);
        this.treePlan.setRootVisible(false);
        this.treePlan.setRowHeight(18);
        this.treePlan.setShowsRootHandles(true);
        this.jScrollPane3.setViewportView(this.treePlan);
        this.splitSql.setRightComponent(this.jScrollPane3);
        this.jPanel7.add((Component)this.splitSql, "Center");
        this.splitPlan.setRightComponent(this.jPanel7);
        this.add((Component)this.splitPlan, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refreshTableList();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableSql.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(pl.mpak.orbada.oracle.Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    SqlPlanPanelView.this.setCurrentSchemaName(o.toString());
                    SqlPlanPanelView.this.refreshTableList();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmSearchActionPerformed(ActionEvent evt) {
        this.refreshTableList();
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableObjects.getSelectedRow() >= 0) {
            try {
                this.tableObjects.getQuery().getRecord(this.tableObjects.getSelectedRow());
                String objectName = this.tableObjects.getQuery().fieldByName("object_name").getString();
                String objectType = this.tableObjects.getQuery().fieldByName("object_type").getString();
                FreezeViewService service = this.freezeFactory.createInstance(objectType, this.currentSchemaName, objectName);
                if (service != null) {
                    this.accesibilities.createView((ViewProvider)service);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void tableObjectsMouseClicked(MouseEvent evt) {
        if (this.tableObjects.getSelectedRow() >= 0 && evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.cmFreezeObject.performe();
        }
    }
}

