/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.gui.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import pl.mpak.mpak.oracle.tune.OrbadaOracleTunePlugin;
import pl.mpak.mpak.oracle.tune.Sql;
import pl.mpak.mpak.oracle.tune.gui.profiler.RunsPanel;
import pl.mpak.mpak.oracle.tune.gui.profiler.SourcePanel;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class DatasPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleTunePlugin.class);
    private IViewAccesibilities accesibilities;
    private Timer timer;
    private SqlFilter filter;
    private SourcePanel sourcePanel;
    private RunsPanel runsPanel;
    private long runid;
    private String schemaName;
    private String objectType;
    private String objectName;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar queryTableStatusBar1;
    private JSplitPane split;
    private ViewTable tableDatas;

    public DatasPanel(IViewAccesibilities accesibilities, RunsPanel runsPanel) {
        this.accesibilities = accesibilities;
        this.runsPanel = runsPanel;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.sourcePanel = new SourcePanel(this.accesibilities);
        this.split.setBottomComponent(this.sourcePanel);
        this.timer = new Timer(200L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                DatasPanel.this.refreshLine();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tableDatas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DatasPanel.this.timer.restart();
            }
        });
        this.tableDatas.getQuery().setDatabase(this.getDatabase());
        this.tableDatas.addColumn((TableColumn)new QueryTableColumn("line#", this.stringManager.getString("line"), 70));
        this.tableDatas.addColumn((TableColumn)new QueryTableColumn("total_occur", this.stringManager.getString("total-occur"), 70));
        this.tableDatas.addColumn((TableColumn)new QueryTableColumn("total_time", this.stringManager.getString("total-time"), 120));
        this.tableDatas.addColumn((TableColumn)new QueryTableColumn("min_time", this.stringManager.getString("min-time"), 120));
        this.tableDatas.addColumn((TableColumn)new QueryTableColumn("max_time", this.stringManager.getString("max-time"), 120));
        this.tableDatas.addColumn((TableColumn)new QueryTableColumn("avg_time", this.stringManager.getString("avg-time"), 120));
        this.tableDatas.addColumn((TableColumn)new QueryTableColumn("perc_total_time", this.stringManager.getString("perc-total-time"), 70));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("line#", this.stringManager.getString("line"), (String[])null));
        def.add(new SqlFilterDefComponent("total_occur", this.stringManager.getString("total-occur"), (String[])null));
        def.add(new SqlFilterDefComponent("total_occur > 0", this.stringManager.getString("any-occur")));
        def.add(new SqlFilterDefComponent("total_time", this.stringManager.getString("total-time"), (String[])null));
        def.add(new SqlFilterDefComponent("min_time", this.stringManager.getString("min-time"), (String[])null));
        def.add(new SqlFilterDefComponent("max_time", this.stringManager.getString("max-time"), (String[])null));
        def.add(new SqlFilterDefComponent("avg_time", this.stringManager.getString("avg-time"), (String[])null));
        def.add(new SqlFilterDefComponent("perc_total_time", this.stringManager.getString("perc-total-time"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-tune-profiler-datas-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableDatas, (JButton)this.buttonActions, this.menuActions, "oracle-tune-profiler-datas-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DatasPanel.this.split.setDividerLocation(0.5);
            }
        });
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTableList(String lineNo) {
        try {
            int column = this.tableDatas.getSelectedColumn();
            int index = Math.max(0, this.tableDatas.getSelectedRow());
            if (lineNo == null & this.tableDatas.getQuery().isActive() && this.tableDatas.getSelectedRow() >= 0 && this.tableDatas.getQuery().getRecord(this.tableDatas.getSelectedRow()) != null) {
                lineNo = this.tableDatas.getQuery().fieldByName("line#").getString();
            }
            this.tableDatas.getQuery().close();
            this.tableDatas.getQuery().setSqlText(Sql.getProfilerDataList(this.filter.getSqlText()));
            this.tableDatas.getQuery().paramByName("runid").setLong(this.runid);
            this.tableDatas.getQuery().paramByName("unit_owner").setString(this.schemaName);
            this.tableDatas.getQuery().paramByName("unit_type").setString(this.objectType);
            this.tableDatas.getQuery().paramByName("unit_name").setString(this.objectName);
            this.tableDatas.getQuery().paramByName("prec").setLong(this.runsPanel.getUnitPrecision());
            this.tableDatas.getQuery().open();
            this.tableDatas.getQuery().flushAll();
            if (!this.tableDatas.getQuery().isEmpty()) {
                if ("-1".equals(lineNo)) {
                    this.tableDatas.changeSelection(0, column);
                } else if (lineNo != null && this.tableDatas.getQuery().locate("line#", new Variant(lineNo))) {
                    this.tableDatas.changeSelection(this.tableDatas.getQuery().getCurrentRecord().getIndex(), column);
                } else {
                    this.tableDatas.changeSelection(Math.min(index, this.tableDatas.getRowCount() - 1), column);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.timer.restart();
        }
    }

    public void refresh(long runid, String schemaName, String objectType, String objectName) {
        this.runid = runid;
        this.schemaName = schemaName;
        this.objectType = objectType;
        this.objectName = objectName;
        this.refreshTableList("-1");
        this.sourcePanel.refresh(schemaName, objectType, objectName);
    }

    private void refreshLine() {
        if (this.tableDatas.getSelectedRow() >= 0) {
            try {
                if (this.tableDatas.getQuery().getRecord(this.tableDatas.getSelectedRow()) != null) {
                    this.sourcePanel.gotoLine(this.tableDatas.getQuery().fieldByName("line#").getInteger());
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableDatas.getQuery().close();
        this.sourcePanel.close();
        this.sourcePanel = null;
        this.runsPanel = null;
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.split = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableDatas = new ViewTable();
        this.queryTableStatusBar1 = new QueryTableStatusBar();
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonFilter);
        this.jToolBar1.add(this.jSeparator1);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonActions);
        this.jPanel1.add(this.jToolBar1);
        this.add((Component)this.jPanel1, "First");
        this.split.setBorder(null);
        this.split.setDividerLocation(200);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableDatas);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.queryTableStatusBar1.setTable((QueryTable)this.tableDatas);
        this.jPanel2.add((Component)this.queryTableStatusBar1, "South");
        this.split.setTopComponent(this.jPanel2);
        this.add((Component)this.split, "Center");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableList(null);
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refreshTableList(null);
        }
    }
}

