/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.gui.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import pl.mpak.mpak.oracle.tune.OrbadaOracleTunePlugin;
import pl.mpak.mpak.oracle.tune.Sql;
import pl.mpak.mpak.oracle.tune.gui.profiler.UnitsPanel;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.VerticalFlowLayout;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class RunsPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleTunePlugin.class);
    private IViewAccesibilities accesibilities;
    private Timer timer;
    private SqlFilter filter;
    private UnitsPanel unitsPanel;
    private boolean viewClosing;
    private ProfileState profileState = ProfileState.Stopped;
    private long runidProfile;
    private long unitPrecision;
    private ToolButton buttonActions;
    private ToolButton buttonAllRuns;
    private ToolButton buttonFilter;
    private ToolButton buttonMilisecondUnit;
    private ToolButton buttonRefresh;
    private Action cmAllRuns;
    private Action cmDeleteRun;
    private Action cmFilter;
    private Action cmFind;
    private Action cmMilisecondUnit;
    private Action cmPauseProfile;
    private Action cmRefresh;
    private Action cmResumeProfile;
    private Action cmStartProfile;
    private Action cmStopProfile;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JPopupMenu menuActions;
    private JMenu menuProfiler;
    private QueryTableStatusBar queryTableStatusBar1;
    private JSplitPane split;
    private ViewTable tableRuns;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;
    private ToolButton toolButton4;
    private ToolButton toolButton5;

    public RunsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.unitPrecision = 1L;
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getProfilerUnitPrecision());
            if (!query.eof()) {
                this.unitPrecision = query.fieldByName("prec").getLong();
            }
        }
        catch (Exception ex) {
            try {
                query.open("select 'LINUX' platform from v$version where upper(banner) like '%LINUX:%' union all select 'WINDOWS' platform from v$version where upper(banner) like '%WINDOWS:%'");
                if (!query.eof()) {
                    if ("LINUX".equals(query.fieldByName("platform").getString())) {
                        this.unitPrecision = 1000000L;
                    } else if ("WINDOWS".equals(query.fieldByName("platform").getString())) {
                        this.unitPrecision = 1000000000L;
                    }
                }
            }
            catch (Exception ex2) {
                this.unitPrecision = 1000000000L;
            }
        }
        finally {
            query.close();
        }
        this.accesibilities.addMenu(this.menuProfiler);
        this.unitsPanel = new UnitsPanel(this.accesibilities, this);
        this.split.setBottomComponent(this.unitsPanel);
        this.timer = new Timer(200L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                RunsPanel.this.refreshUnits();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tableRuns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RunsPanel.this.timer.restart();
            }
        });
        this.tableRuns.getQuery().setDatabase(this.getDatabase());
        this.tableRuns.addColumn((TableColumn)new QueryTableColumn("runid", this.stringManager.getString("id"), 60));
        this.tableRuns.addColumn((TableColumn)new QueryTableColumn("run_date", this.stringManager.getString("date"), 120));
        this.tableRuns.addColumn((TableColumn)new QueryTableColumn("run_total_time", this.stringManager.getString("total-time"), 120));
        this.tableRuns.addColumn((TableColumn)new QueryTableColumn("run_comment1", this.stringManager.getString("comment"), 250));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("runid", this.stringManager.getString("id"), (String[])null));
        def.add(new SqlFilterDefComponent("run_date", this.stringManager.getString("date"), (String[])null));
        def.add(new SqlFilterDefComponent("run_total_time", this.stringManager.getString("total-time"), (String[])null));
        def.add(new SqlFilterDefComponent("run_comment1", this.stringManager.getString("comment"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-tune-profiler-runs-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableRuns, (JButton)this.buttonActions, this.menuActions, "oracle-tune-profiler-runs-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RunsPanel.this.split.setDividerLocation(0.3f);
            }
        });
        this.enableControls();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTableList(String runId) {
        try {
            String findFilter = this.filter.getSqlText();
            if (!this.buttonAllRuns.isSelected()) {
                findFilter = findFilter != null ? findFilter + "\n  and " : "";
                findFilter = findFilter + "run_comment1 = 'SESSIONID:'||userenv('SESSIONID')||' TERMINA:'||userenv('TERMINAL')||' USER:'||USER";
            }
            int column = this.tableRuns.getSelectedColumn();
            int index = Math.max(0, this.tableRuns.getSelectedRow());
            if (runId == null & this.tableRuns.getQuery().isActive() && this.tableRuns.getSelectedRow() >= 0 && this.tableRuns.getQuery().getRecord(this.tableRuns.getSelectedRow()) != null) {
                runId = this.tableRuns.getQuery().fieldByName("runid").getString();
            }
            this.tableRuns.getQuery().close();
            this.tableRuns.getQuery().setSqlText(Sql.getProfilerRunList(findFilter));
            this.tableRuns.getQuery().paramByName("prec").setLong(this.getUnitPrecision());
            this.tableRuns.getQuery().open();
            this.tableRuns.getQuery().flushAll();
            if (!this.tableRuns.getQuery().isEmpty()) {
                if ("".equals(runId)) {
                    this.tableRuns.changeSelection(0, column);
                } else if (runId != null && this.tableRuns.getQuery().locate("runid", new Variant(runId))) {
                    this.tableRuns.changeSelection(this.tableRuns.getQuery().getCurrentRecord().getIndex(), column);
                } else {
                    this.tableRuns.changeSelection(Math.min(index, this.tableRuns.getRowCount() - 1), column);
                }
            } else {
                this.refreshUnits();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.timer.restart();
        }
    }

    private void refreshUnits() {
        if (this.tableRuns.getSelectedRow() >= 0) {
            try {
                this.tableRuns.getQuery().getRecord(this.tableRuns.getSelectedRow());
                this.unitsPanel.refresh(this.tableRuns.getQuery().fieldByName("runid").getLong());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        } else {
            this.unitsPanel.refresh(-1L);
        }
    }

    public void close() throws IOException {
        this.viewClosing = true;
        if (this.profileState != ProfileState.Stopped) {
            this.cmStopProfile.performe();
        }
        this.timer.cancel();
        this.tableRuns.getQuery().close();
        this.unitsPanel.close();
        this.unitsPanel = null;
        this.accesibilities = null;
    }

    private void enableControls() {
        this.cmStartProfile.setEnabled(this.profileState == ProfileState.Stopped);
        this.cmStopProfile.setEnabled(this.profileState == ProfileState.Started || this.profileState == ProfileState.Paused);
        this.cmPauseProfile.setEnabled(this.profileState == ProfileState.Started);
        this.cmResumeProfile.setEnabled(this.profileState == ProfileState.Paused);
    }

    public long getUnitPrecision() {
        return this.buttonMilisecondUnit.isSelected() ? this.unitPrecision : 1L;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.cmFind = new Action();
        this.cmAllRuns = new Action();
        this.cmDeleteRun = new Action();
        this.cmStartProfile = new Action();
        this.cmStopProfile = new Action();
        this.cmPauseProfile = new Action();
        this.cmResumeProfile = new Action();
        this.menuProfiler = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMenuItem6 = new JMenuItem();
        this.cmMilisecondUnit = new Action();
        this.split = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jToolBar2 = new JToolBar();
        this.toolButton2 = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.toolButton4 = new ToolButton();
        this.toolButton5 = new ToolButton();
        this.jToolBar1 = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonAllRuns = new ToolButton();
        this.buttonMilisecondUnit = new ToolButton();
        this.buttonActions = new ToolButton();
        this.toolButton1 = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableRuns = new ViewTable();
        this.queryTableStatusBar1 = new QueryTableStatusBar();
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmFind.setActionCommandKey("cmFind");
        this.cmFind.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmFind.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_source.gif"));
        this.cmFind.setText(this.stringManager.getString("cmFind-text"));
        this.cmFind.setTooltip(this.stringManager.getString("cmFind-hint"));
        this.cmFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmFindActionPerformed(evt);
            }
        });
        this.cmAllRuns.setActionCommandKey("cmAllRuns");
        this.cmAllRuns.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/group.gif"));
        this.cmAllRuns.setText(this.stringManager.getString("cmAllRuns-text"));
        this.cmAllRuns.setTooltip(this.stringManager.getString("cmAllRuns-hint"));
        this.cmAllRuns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmAllRunsActionPerformed(evt);
            }
        });
        this.cmDeleteRun.setActionCommandKey("cmDeleteRun");
        this.cmDeleteRun.setShortCut(KeyStroke.getKeyStroke(119, 2));
        this.cmDeleteRun.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDeleteRun.setText(this.stringManager.getString("cmDeleteRun-text"));
        this.cmDeleteRun.setTooltip(this.stringManager.getString("cmDeleteRun-hint"));
        this.cmDeleteRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmDeleteRunActionPerformed(evt);
            }
        });
        this.cmStartProfile.setActionCommandKey("cmStartProfile");
        this.cmStartProfile.setShortCut(KeyStroke.getKeyStroke(116, 2));
        this.cmStartProfile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmStartProfile.setText(this.stringManager.getString("cmStartProfile-text"));
        this.cmStartProfile.setTooltip(this.stringManager.getString("cmStartProfile-hint"));
        this.cmStartProfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmStartProfileActionPerformed(evt);
            }
        });
        this.cmStopProfile.setActionCommandKey("cmStopProfile");
        this.cmStopProfile.setShortCut(KeyStroke.getKeyStroke(113, 2));
        this.cmStopProfile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/stop16.gif"));
        this.cmStopProfile.setText(this.stringManager.getString("cmStopProfile-text"));
        this.cmStopProfile.setTooltip(this.stringManager.getString("cmStopProfile-hint"));
        this.cmStopProfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmStopProfileActionPerformed(evt);
            }
        });
        this.cmPauseProfile.setActionCommandKey("cmPauseProfile");
        this.cmPauseProfile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/debug_pause.gif"));
        this.cmPauseProfile.setText(this.stringManager.getString("cmPauseProfile-text"));
        this.cmPauseProfile.setTooltip(this.stringManager.getString("cmPauseProfile-hint"));
        this.cmPauseProfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmPauseProfileActionPerformed(evt);
            }
        });
        this.cmResumeProfile.setActionCommandKey("cmResumeProfile");
        this.cmResumeProfile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/debug_resume.gif"));
        this.cmResumeProfile.setText(this.stringManager.getString("cmResumeProfile-text"));
        this.cmResumeProfile.setTooltip(this.stringManager.getString("cmResumeProfile-hint"));
        this.cmResumeProfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmResumeProfileActionPerformed(evt);
            }
        });
        this.menuProfiler.setText(this.stringManager.getString("menu-profiler"));
        this.jMenuItem1.setAction((javax.swing.Action)this.cmStartProfile);
        this.menuProfiler.add(this.jMenuItem1);
        this.jMenuItem2.setAction((javax.swing.Action)this.cmStopProfile);
        this.menuProfiler.add(this.jMenuItem2);
        this.jMenuItem3.setAction((javax.swing.Action)this.cmPauseProfile);
        this.menuProfiler.add(this.jMenuItem3);
        this.jMenuItem4.setAction((javax.swing.Action)this.cmResumeProfile);
        this.menuProfiler.add(this.jMenuItem4);
        this.menuProfiler.add(this.jSeparator3);
        this.jMenuItem5.setAction((javax.swing.Action)this.cmAllRuns);
        this.menuProfiler.add(this.jMenuItem5);
        this.jMenuItem7.setAction((javax.swing.Action)this.cmMilisecondUnit);
        this.menuProfiler.add(this.jMenuItem7);
        this.menuProfiler.add(this.jSeparator4);
        this.jMenuItem6.setAction((javax.swing.Action)this.cmDeleteRun);
        this.menuProfiler.add(this.jMenuItem6);
        this.cmMilisecondUnit.setActionCommandKey("cmMilisecondUnit");
        this.cmMilisecondUnit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/ms.gif"));
        this.cmMilisecondUnit.setText(this.stringManager.getString("cmMilisecondUnit-text"));
        this.cmMilisecondUnit.setTooltip(this.stringManager.getString("cmMilisecondUnit-hint"));
        this.cmMilisecondUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunsPanel.this.cmMilisecondUnitActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                RunsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(200);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel2.setLayout(new BorderLayout());
        VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
        verticalFlowLayout1.setVgap(0);
        verticalFlowLayout1.setHgap(0);
        this.jPanel1.setLayout((LayoutManager)verticalFlowLayout1);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.toolButton2.setAction((javax.swing.Action)this.cmStartProfile);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.jToolBar2.add((Component)this.toolButton2);
        this.toolButton3.setAction((javax.swing.Action)this.cmStopProfile);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.jToolBar2.add((Component)this.toolButton3);
        this.toolButton4.setAction((javax.swing.Action)this.cmPauseProfile);
        this.toolButton4.setHorizontalTextPosition(0);
        this.toolButton4.setVerticalTextPosition(3);
        this.jToolBar2.add((Component)this.toolButton4);
        this.toolButton5.setAction((javax.swing.Action)this.cmResumeProfile);
        this.toolButton5.setHorizontalTextPosition(0);
        this.toolButton5.setVerticalTextPosition(3);
        this.jToolBar2.add((Component)this.toolButton5);
        this.jPanel1.add(this.jToolBar2);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonFilter);
        this.jToolBar1.add(this.jSeparator1);
        this.buttonAllRuns.setAction((javax.swing.Action)this.cmAllRuns);
        this.buttonAllRuns.setHorizontalTextPosition(0);
        this.buttonAllRuns.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonAllRuns);
        this.buttonMilisecondUnit.setAction((javax.swing.Action)this.cmMilisecondUnit);
        this.buttonMilisecondUnit.setHorizontalTextPosition(0);
        this.buttonMilisecondUnit.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonMilisecondUnit);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonActions);
        this.toolButton1.setAction((javax.swing.Action)this.cmDeleteRun);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.toolButton1);
        this.jPanel1.add(this.jToolBar1);
        this.jPanel2.add((Component)this.jPanel1, "First");
        this.jScrollPane1.setViewportView((Component)this.tableRuns);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.queryTableStatusBar1.setTable((QueryTable)this.tableRuns);
        this.jPanel2.add((Component)this.queryTableStatusBar1, "South");
        this.split.setTopComponent(this.jPanel2);
        this.add((Component)this.split, "Center");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableList(null);
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refreshTableList(null);
        }
    }

    private void cmFindActionPerformed(ActionEvent evt) {
        this.refreshTableList(null);
    }

    private void cmAllRunsActionPerformed(ActionEvent evt) {
        this.buttonAllRuns.setSelected(!this.buttonAllRuns.isSelected());
        this.refreshTableList(null);
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.isVisible() && !this.viewClosing && !this.tableRuns.getQuery().isActive()) {
            this.refreshTableList(null);
        }
    }

    private void cmDeleteRunActionPerformed(ActionEvent evt) {
        if (this.tableRuns.getSelectedRow() >= 0) {
            try {
                this.tableRuns.getQuery().getRecord(this.tableRuns.getSelectedRow());
                long runid = this.tableRuns.getQuery().fieldByName("runid").getLong();
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)this.stringManager.getString("RunsPanel-delete-profile-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                    Command command = this.getDatabase().createCommand();
                    command.setSqlText(Sql.getDeleteRunProfiler());
                    command.paramByName("runid").setLong(runid);
                    command.execute();
                    this.refreshTableList(null);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmStartProfileActionPerformed(ActionEvent evt) {
        try {
            Command command = this.getDatabase().createCommand();
            command.setSqlText(Sql.getStartProfiler());
            command.paramByName("runid").setParamMode(4, -5);
            command.execute();
            this.profileState = ProfileState.Started;
            this.runidProfile = command.paramByName("runid").getLong();
            this.refreshTableList(String.valueOf(this.runidProfile));
            this.refreshUnits();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.enableControls();
    }

    private void cmStopProfileActionPerformed(ActionEvent evt) {
        try {
            Command command = this.getDatabase().createCommand();
            command.setSqlText(Sql.getStopProfiler());
            command.paramByName("runid").setLong(this.runidProfile);
            command.execute();
            command.setSqlText(Sql.getCorrectTriggerLinesProfiler());
            command.paramByName("runid").setLong(this.runidProfile);
            command.execute();
            this.profileState = ProfileState.Stopped;
            this.refreshTableList(String.valueOf(this.runidProfile));
            this.refreshUnits();
            this.runidProfile = -1L;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.enableControls();
    }

    private void cmPauseProfileActionPerformed(ActionEvent evt) {
        try {
            Command command = this.getDatabase().createCommand();
            command.setSqlText(Sql.getPauseProfiler());
            command.paramByName("runid").setLong(this.runidProfile);
            command.execute();
            this.profileState = ProfileState.Paused;
            this.refreshTableList(String.valueOf(this.runidProfile));
            this.refreshUnits();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.enableControls();
    }

    private void cmResumeProfileActionPerformed(ActionEvent evt) {
        try {
            Command command = this.getDatabase().createCommand();
            command.setSqlText(Sql.getResumeProfiler());
            command.execute();
            this.profileState = ProfileState.Started;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.enableControls();
    }

    private void cmMilisecondUnitActionPerformed(ActionEvent evt) {
        this.buttonMilisecondUnit.setSelected(!this.buttonMilisecondUnit.isSelected());
        this.refreshTableList(null);
        this.refreshUnits();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProfileState {
        Started,
        Stopped,
        Paused;

    }
}

