/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.gui.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.oracle.util.SourceCreator;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.syntax.SyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.util.StringUtil;

public class SourcePanel
extends JPanel
implements Closeable {
    private IViewAccesibilities accesibilities;
    private String schemaName;
    private String objectType;
    private String objectName;
    private SourceCreator sourceCreator;
    private SyntaxDocument.LineMark lineMark;
    private OrbadaSyntaxTextArea source;

    public SourcePanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.source.setDatabase(this.accesibilities.getDatabase());
        this.sourceCreator = new SourceCreator(this.accesibilities.getDatabase(), (SyntaxTextArea)this.source);
        this.lineMark = new SyntaxDocument.LineMark(-1, Color.getColor("activeCaption", new Color(204, 204, 255)), ImageManager.getImage((String)"/pl/mpak/res/icons/line_point.gif"));
    }

    public void refresh(String schemaName, String objectType, String objectName) {
        if (!(StringUtil.equals((String)this.schemaName, (String)schemaName) && StringUtil.equals((String)this.objectType, (String)objectType) && StringUtil.equals((String)this.objectName, (String)objectName))) {
            this.schemaName = schemaName;
            this.objectType = objectType;
            this.objectName = objectName;
            if (!"ANONYMOUS BLOCK".equals(objectType)) {
                this.sourceCreator.getSource(schemaName, objectType, objectName);
            } else {
                this.source.setDatabaseObject(schemaName, objectType, objectName, "");
            }
        }
    }

    public void close() throws IOException {
        this.source.setDatabase(null);
        this.source = null;
        this.sourceCreator = null;
    }

    public void gotoLine(final int lineNo) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SourcePanel.this.source.removeLineMark(SourcePanel.this.lineMark);
                SourcePanel.this.lineMark.setLine(lineNo);
                SourcePanel.this.source.setLineMark(SourcePanel.this.lineMark);
                int offset = SourcePanel.this.source.getEditorArea().getLineStartOffset(lineNo - 1);
                SourcePanel.this.source.getEditorArea().setCaretPosition(offset, true);
                SourcePanel.this.source.repaint();
            }
        });
    }

    private void initComponents() {
        this.source = new OrbadaSyntaxTextArea();
        this.setLayout(new BorderLayout());
        this.source.setEditable(false);
        this.add((Component)this.source, "Center");
    }
}

