/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.gui.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.mpak.oracle.tune.OrbadaOracleTunePlugin;
import pl.mpak.mpak.oracle.tune.Sql;
import pl.mpak.mpak.oracle.tune.gui.profiler.DatasPanel;
import pl.mpak.mpak.oracle.tune.gui.profiler.RunsPanel;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.freezing.FreezeFactory;
import pl.mpak.orbada.oracle.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class UnitsPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleTunePlugin.class);
    private IViewAccesibilities accesibilities;
    private Timer timer;
    private SqlFilter filter;
    private DatasPanel datasPanel;
    private FreezeFactory freezeFactory;
    private RunsPanel runsPanel;
    private long runid;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonFreeze;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmFind;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar queryTableStatusBar1;
    private JSplitPane split;
    private ViewTable tableUnits;
    private TextField textFind;
    private ToolButton toolButton1;

    public UnitsPanel(IViewAccesibilities accesibilities, RunsPanel runsPanel) {
        this.accesibilities = accesibilities;
        this.runsPanel = runsPanel;
        this.freezeFactory = new FreezeFactory(accesibilities);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.datasPanel = new DatasPanel(this.accesibilities, this.runsPanel);
        this.split.setBottomComponent(this.datasPanel);
        this.textFind.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.tableUnits));
        this.timer = new Timer(200L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                UnitsPanel.this.refreshDatas();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tableUnits.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                UnitsPanel.this.timer.restart();
                if (UnitsPanel.this.tableUnits.getSelectedRow() >= 0) {
                    try {
                        if (UnitsPanel.this.tableUnits.getQuery().getRecord(UnitsPanel.this.tableUnits.getSelectedRow()) != null) {
                            UnitsPanel.this.cmFreezeObject.setEnabled(UnitsPanel.this.freezeFactory.canCreate(UnitsPanel.this.tableUnits.getQuery().fieldByName("unit_type").getString()));
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableUnits.getQuery().setDatabase(this.getDatabase());
        this.tableUnits.addColumn((TableColumn)new QueryTableColumn("unit_type", this.stringManager.getString("object-type"), 150));
        this.tableUnits.addColumn((TableColumn)new QueryTableColumn("unit_owner", this.stringManager.getString("schema"), 150));
        this.tableUnits.addColumn((TableColumn)new QueryTableColumn("unit_name", this.stringManager.getString("obejct-name"), 250, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableUnits.addColumn((TableColumn)new QueryTableColumn("total_time", this.stringManager.getString("total-time"), 120));
        this.tableUnits.addColumn((TableColumn)new QueryTableColumn("perc_total_time", this.stringManager.getString("perc-total-time"), 70));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("unit_type", this.stringManager.getString("object-type"), (String[])null));
        def.add(new SqlFilterDefComponent("unit_owner", this.stringManager.getString("schema"), (String[])null));
        def.add(new SqlFilterDefComponent("unit_name", this.stringManager.getString("obejct-name"), (String[])null));
        def.add(new SqlFilterDefComponent("total_time", this.stringManager.getString("total-time"), (String[])null));
        def.add(new SqlFilterDefComponent("perc_total_time", this.stringManager.getString("perc-total-time"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-tune-profiler-units-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableUnits, (JButton)this.buttonActions, this.menuActions, "oracle-tune-profiler-units-actions");
        SwingUtil.addAction((JComponent)this.textFind, (javax.swing.Action)this.cmFind);
        SwingUtil.addAction((JComponent)this.tableUnits, (javax.swing.Action)this.cmFreezeObject);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UnitsPanel.this.split.setDividerLocation(0.4f);
            }
        });
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTableList(String objectName) {
        try {
            String findFilter = this.filter.getSqlText();
            String find = this.textFind.getText();
            if (!"".equals(find)) {
                findFilter = findFilter != null ? findFilter + "\n  and " : "";
                findFilter = findFilter + "(unit_name like '%'||upper(:FIND)||'%' or unit_type = '%'||upper(:FIND)||'%')";
            }
            int column = this.tableUnits.getSelectedColumn();
            int index = Math.max(0, this.tableUnits.getSelectedRow());
            if (objectName == null & this.tableUnits.getQuery().isActive() && this.tableUnits.getSelectedRow() >= 0 && this.tableUnits.getQuery().getRecord(this.tableUnits.getSelectedRow()) != null) {
                objectName = this.tableUnits.getQuery().fieldByName("unit_name").getString();
            }
            this.tableUnits.getQuery().close();
            this.tableUnits.getQuery().setSqlText(Sql.getProfilerUnitList(findFilter));
            this.tableUnits.getQuery().paramByName("runid").setLong(this.runid);
            this.tableUnits.getQuery().paramByName("prec").setLong(this.runsPanel.getUnitPrecision());
            if (!"".equals(find)) {
                this.tableUnits.getQuery().paramByName("FIND").setString(find);
            }
            this.tableUnits.getQuery().open();
            this.tableUnits.getQuery().flushAll();
            if (!this.tableUnits.getQuery().isEmpty()) {
                if ("".equals(objectName)) {
                    this.tableUnits.changeSelection(0, column);
                } else if (objectName != null && this.tableUnits.getQuery().locate("unit_name", new Variant(objectName))) {
                    this.tableUnits.changeSelection(this.tableUnits.getQuery().getCurrentRecord().getIndex(), column);
                } else {
                    this.tableUnits.changeSelection(Math.min(index, this.tableUnits.getRowCount() - 1), column);
                }
            } else {
                this.refreshDatas();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.timer.restart();
        }
    }

    public void refresh(long runid) {
        this.runid = runid;
        this.refreshTableList("");
    }

    private void refreshDatas() {
        if (this.tableUnits.getSelectedRow() >= 0) {
            try {
                this.tableUnits.getQuery().getRecord(this.tableUnits.getSelectedRow());
                this.datasPanel.refresh(this.runid, this.tableUnits.getQuery().fieldByName("unit_owner").getString(), this.tableUnits.getQuery().fieldByName("unit_type").getString(), this.tableUnits.getQuery().fieldByName("unit_name").getString());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        } else {
            this.datasPanel.refresh(this.runid, null, null, null);
        }
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableUnits.getQuery().close();
        this.datasPanel.close();
        this.datasPanel = null;
        this.runsPanel = null;
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.cmFind = new Action();
        this.cmFreezeObject = new Action();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonFreeze = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.textFind = new TextField();
        this.toolButton1 = new ToolButton();
        this.split = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableUnits = new ViewTable();
        this.queryTableStatusBar1 = new QueryTableStatusBar();
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmFind.setActionCommandKey("cmFind");
        this.cmFind.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmFind.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_source.gif"));
        this.cmFind.setText(this.stringManager.getString("cmFind-text"));
        this.cmFind.setTooltip(this.stringManager.getString("cmFind-hint"));
        this.cmFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitsPanel.this.cmFindActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitsPanel.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonFilter);
        this.jToolBar1.add(this.jSeparator1);
        this.buttonFreeze.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreeze.setHorizontalTextPosition(0);
        this.buttonFreeze.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonFreeze);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonActions);
        this.jPanel5.setLayout(new FlowLayout(1, 2, 3));
        this.jLabel2.setDisplayedMnemonic('S');
        this.jLabel2.setLabelFor((Component)this.textFind);
        this.jLabel2.setText(this.stringManager.getString("search-dd"));
        this.jPanel5.add(this.jLabel2);
        this.textFind.setPreferredSize(new Dimension(120, 20));
        this.jPanel5.add((Component)this.textFind);
        this.jToolBar1.add(this.jPanel5);
        this.toolButton1.setAction((javax.swing.Action)this.cmFind);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.toolButton1);
        this.jPanel1.add(this.jToolBar1);
        this.add((Component)this.jPanel1, "First");
        this.split.setBorder(null);
        this.split.setDividerLocation(200);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableUnits);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.queryTableStatusBar1.setTable((QueryTable)this.tableUnits);
        this.jPanel2.add((Component)this.queryTableStatusBar1, "South");
        this.split.setTopComponent(this.jPanel2);
        this.add((Component)this.split, "Center");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableList(null);
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refreshTableList(null);
        }
    }

    private void cmFindActionPerformed(ActionEvent evt) {
        this.refreshTableList(null);
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableUnits.getSelectedRow() >= 0) {
            try {
                this.tableUnits.getQuery().getRecord(this.tableUnits.getSelectedRow());
                String objectName = this.tableUnits.getQuery().fieldByName("unit_name").getString();
                String objectType = this.tableUnits.getQuery().fieldByName("unit_type").getString();
                String schemaName = this.tableUnits.getQuery().fieldByName("unit_owner").getString();
                FreezeViewService service = this.freezeFactory.createInstance(objectType, schemaName, objectName);
                if (service != null) {
                    this.accesibilities.createView((ViewProvider)service);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

