/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.services;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import pl.mpak.mpak.oracle.tune.OrbadaOracleTunePlugin;
import pl.mpak.mpak.oracle.tune.gui.AutotracePanel;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class OracleAutotraceProvider
extends UniversalActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleTunePlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        if ("Oracle".equals(database.getDriverType())) {
            this.setShortCut(84, 2);
            this.setText(this.stringManager.getString("OracleAutotraceProvider-text"));
            this.setTooltip("<html>" + this.getText() + "<br>\n" + this.stringManager.getString("OracleAutotraceProvider-hint"));
            this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/autotrace.gif"));
            this.setActionCommandKey("OracleAutotraceProvider");
            this.addActionListener(this.createActionListener());
            if (!StringUtil.toBoolean((String)database.getUserProperties().getProperty("autotrace", "false"))) {
                this.setTooltip(this.stringManager.getString("OracleAutotraceProvider-no-statistics-hint"));
                this.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    public boolean addToolButton() {
        return true;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return "Oracle " + this.getText();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OracleAutotraceProvider.this.openResultTab();
            }
        };
    }

    private void openResultTab() {
        Component[] array = this.accessibilities.getResultTabs(AutotracePanel.class);
        if (array.length > 0) {
            AutotracePanel panel = (AutotracePanel)array[0];
            this.accessibilities.setSelectedTab((Component)panel);
        } else {
            AutotracePanel panel = new AutotracePanel(this.accessibilities.getViewAccesibilities().getDatabase());
            panel.afterSql();
            this.accessibilities.addResultTab(this.getText(), (JComponent)panel);
        }
    }

    private void beforeSql() {
        Component[] array = this.accessibilities.getResultTabs(AutotracePanel.class);
        if (array.length > 0) {
            AutotracePanel panel = (AutotracePanel)array[0];
            panel.beforeSql();
        }
    }

    private void afterSql() {
        Component[] array = this.accessibilities.getResultTabs(AutotracePanel.class);
        if (array.length > 0) {
            AutotracePanel panel = (AutotracePanel)array[0];
            panel.afterSql();
        }
    }

    public void beforeOpenQuery(Query query) {
        this.beforeSql();
    }

    public void afterOpenQuery(Query query) {
        this.afterSql();
    }

    public void beforeExecuteCommand(Command command) {
        this.beforeSql();
    }

    public void afterExecuteCommand(Command command) {
        this.afterSql();
    }

    public String getGroupName() {
        return "Oracle";
    }
}

