/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.mpak.oracle.tune.services;

import java.awt.Component;
import javax.swing.Icon;
import pl.mpak.mpak.oracle.tune.OrbadaOracleTunePlugin;
import pl.mpak.mpak.oracle.tune.Sql;
import pl.mpak.mpak.oracle.tune.gui.profiler.RunsPanel;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OracleSqlProfilerView
extends ViewProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleTunePlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component createView(IViewAccesibilities accesibilities) {
        Query query = accesibilities.getDatabase().createQuery();
        try {
            query.open(Sql.getProfilerTableExists());
            if (!query.eof() && query.fieldByName("cnt").getInteger() >= 3) {
                RunsPanel runsPanel = new RunsPanel(accesibilities);
                return runsPanel;
            }
            MessageBox.show((String)this.getPublicName(), (String)this.stringManager.getString("OracleSqlProfilerView-no-objects-info"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return null;
    }

    public String getPublicName() {
        return this.stringManager.getString("OracleSqlProfilerView-public-name");
    }

    public String getViewId() {
        return "orbada-oracle-tune-profiler-view";
    }

    public Icon getIcon() {
        return ImageManager.getImage((String)"/pl/mpak/res/icons/profiler.gif");
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Oracle".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("OracleSqlProfilerView-description");
    }

    public String getGroupName() {
        return "Oracle";
    }

    public String[] getSubmenu() {
        return new String[]{OrbadaOracleTunePlugin.tuneGroup};
    }
}

