/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.datamove.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import pl.mpak.orbada.datamove.OrbadaDataMovePlugin;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class DataMoveConfig {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDataMovePlugin.class);
    private String tableName;
    private String insertCommand;
    private String selectCommand;
    private String updateCommand;
    private boolean commit = true;
    private int commitCount;
    private boolean noUpdate = true;
    private boolean ignoreErrors;
    private boolean destParamTypes = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        Properties props = new Properties();
        FileInputStream is = new FileInputStream(file);
        try {
            props.loadFromXML(is);
            this.tableName = props.getProperty("table-name");
            this.insertCommand = props.getProperty("insert-command");
            this.selectCommand = props.getProperty("select-command");
            this.updateCommand = props.getProperty("update-command");
            this.commit = StringUtil.toBoolean((String)props.getProperty("commit"));
            this.commitCount = Integer.parseInt(props.getProperty("commit-count", "1"));
            this.noUpdate = StringUtil.toBoolean((String)props.getProperty("no-update"));
            this.ignoreErrors = StringUtil.toBoolean((String)props.getProperty("ignore-errors"));
            this.destParamTypes = StringUtil.toBoolean((String)props.getProperty("dest-param-types"));
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        Properties props = new Properties();
        FileOutputStream os = new FileOutputStream(file);
        try {
            props.setProperty("table-name", this.tableName);
            props.setProperty("insert-command", this.insertCommand);
            props.setProperty("select-command", this.selectCommand);
            props.setProperty("update-command", this.updateCommand);
            props.setProperty("commit", this.commit ? "true" : "false");
            props.setProperty("commit-count", String.valueOf(this.commitCount));
            props.setProperty("no-update", this.noUpdate ? "true" : "false");
            props.setProperty("ignore-errors", this.ignoreErrors ? "true" : "false");
            props.setProperty("dest-param-types", this.destParamTypes ? "true" : "false");
            props.storeToXML(os, "Orbada Data Move Config");
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public boolean isCommit() {
        return this.commit;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public String getInsertCommand() {
        return this.insertCommand;
    }

    public void setInsertCommand(String insertCommand) {
        this.insertCommand = insertCommand;
    }

    public boolean isNoUpdate() {
        return this.noUpdate;
    }

    public void setNoUpdate(boolean noUpdate) {
        this.noUpdate = noUpdate;
    }

    public String getSelectCommand() {
        return this.selectCommand;
    }

    public void setSelectCommand(String selectCommand) {
        this.selectCommand = selectCommand;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getUpdateCommand() {
        return this.updateCommand;
    }

    public void setUpdateCommand(String updateCommand) {
        this.updateCommand = updateCommand;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isDestParamTypes() {
        return this.destParamTypes;
    }

    public void setDestParamTypes(boolean destParamTypes) {
        this.destParamTypes = destParamTypes;
    }
}

