/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.datamove.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.datamove.OrbadaDataMovePlugin;
import pl.mpak.orbada.datamove.gui.DataMoveConfig;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.usedb.core.Parameter;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryField;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.files.PatternFilenameFilter;
import pl.mpak.util.files.WildCard;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskExecutor;
import pl.mpak.util.task.TaskPool;

public class MoveDataDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDataMovePlugin.class);
    private Query query;
    private ISettings settings;
    private DataMoveConfig config = new DataMoveConfig();
    private int modalResult = 0;
    private boolean nameChanged;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonOpen;
    private JCheckBox checkBackgroundTask;
    private JCheckBox checkCommit;
    private JCheckBox checkDestTypes;
    private JCheckBox checkIgnoreIU;
    private JCheckBox checkNoUpdate;
    private Action cmCancel;
    private Action cmCreateInsertCommand;
    private Action cmCreateSelectCommand;
    private Action cmCreateUpdateCommand;
    private Action cmOk;
    private Action cmOpen;
    private Action cmSave;
    private ComboBox comboConnections;
    private ComboBox comboDefs;
    private ComboBox comboTable;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JSpinner spinCommit;
    private OrbadaSyntaxTextArea textCheckSelect;
    private OrbadaSyntaxTextArea textInsert;
    private OrbadaSyntaxTextArea textUpdate;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;

    public MoveDataDialog(Query query) {
        super(SwingUtil.getRootFrame(), true);
        this.query = query;
        this.initComponents();
        this.init();
    }

    public static boolean show(Query query) {
        MoveDataDialog dialog = new MoveDataDialog(query);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-data-move-dialog");
        this.textInsert.setDatabase(this.query.getDatabase());
        this.textCheckSelect.setDatabase(this.query.getDatabase());
        this.textUpdate.setDatabase(this.query.getDatabase());
        ((JTextField)this.comboDefs.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                MoveDataDialog.this.nameChanged = true;
            }

            public void removeUpdate(DocumentEvent e) {
                MoveDataDialog.this.nameChanged = true;
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.comboDefs.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (MoveDataDialog.this.nameChanged && !StringUtil.isEmpty((String)MoveDataDialog.this.comboDefs.getText())) {
                    MoveDataDialog.this.loadConfig();
                }
            }
        });
        File[] files = new File(OrbadaDataMovePlugin.getDefaultPath()).listFiles((FilenameFilter)new PatternFilenameFilter(WildCard.getRegex((String)"*.datamove")));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        for (File file : files) {
            model.addElement(file.getPath());
        }
        this.comboDefs.setModel(model);
        model = new DefaultComboBoxModel();
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            Database database = DatabaseManager.getManager().getDatabase(i);
            if (database.equals(InternalDatabase.get()) && !Application.get().isUserAdmin()) continue;
            model.addElement((String)database);
        }
        this.comboConnections.setModel(model);
        this.comboConnections.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Database database = (Database)value;
                    String text = "<html>";
                    text = database.getPublicName() == null ? text + "<b>" + database.getUserName() + "</b>" : text + "<b>" + database.getPublicName() + "</b> as " + database.getUserName();
                    text = text + " (" + (database.getUrl().length() > 40 ? database.getUrl().substring(0, 39) + "..." : database.getUrl()) + ")";
                    label.setText(text);
                    label.setVerticalAlignment(1);
                }
                return label;
            }
        });
        this.textInsert.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                MoveDataDialog.this.enableActions();
            }

            public void removeUpdate(DocumentEvent e) {
                MoveDataDialog.this.enableActions();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.enableActions();
        this.checkBackgroundTask.setSelected(this.settings.getValue("background-task", Boolean.valueOf(false)));
        this.setBounds(0, 0, this.settings.getValue("width", Long.valueOf(650L)).intValue(), this.settings.getValue("height", Long.valueOf(450L)).intValue());
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void enableActions() {
        this.cmOk.setEnabled(this.comboConnections.getItemCount() > 0 && !StringUtil.isEmpty((String)this.textInsert.getText()));
    }

    private void loadConfig() {
        this.nameChanged = false;
        try {
            this.config.load(new File(this.comboDefs.getText()));
            this.comboTable.setText(this.config.getTableName());
            this.textInsert.setText(this.config.getInsertCommand());
            this.textInsert.setChanged(false);
            this.textInsert.getEditorArea().getUndoManager().discardAllEdits();
            this.textCheckSelect.setText(this.config.getSelectCommand());
            this.textCheckSelect.setChanged(false);
            this.textCheckSelect.getEditorArea().getUndoManager().discardAllEdits();
            this.textUpdate.setText(this.config.getUpdateCommand());
            this.textUpdate.setChanged(false);
            this.textUpdate.getEditorArea().getUndoManager().discardAllEdits();
            this.checkCommit.setSelected(this.config.isCommit());
            this.spinCommit.setValue(this.config.getCommitCount());
            this.checkNoUpdate.setSelected(this.config.isNoUpdate());
            this.checkIgnoreIU.setSelected(this.config.isIgnoreErrors());
            this.checkDestTypes.setSelected(this.config.isDestParamTypes());
        }
        catch (IOException ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void updateConfig() {
        this.config.setTableName(this.comboTable.getText());
        this.config.setInsertCommand(this.textInsert.getText());
        this.config.setSelectCommand(this.textCheckSelect.getText());
        this.config.setUpdateCommand(this.textUpdate.getText());
        this.config.setCommit(this.checkCommit.isSelected());
        this.config.setCommitCount((Integer)this.spinCommit.getValue());
        this.config.setNoUpdate(this.checkNoUpdate.isSelected() || StringUtil.isEmpty((String)this.textCheckSelect.getText()) || StringUtil.isEmpty((String)this.textUpdate.getText()));
        this.config.setIgnoreErrors(this.checkIgnoreIU.isSelected());
        this.config.setDestParamTypes(this.checkDestTypes.isSelected());
    }

    private void saveConfig(File file) {
        this.comboDefs.setText(file.getPath());
        this.nameChanged = false;
        try {
            this.updateConfig();
            this.config.save(file);
        }
        catch (IOException ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void dispose() {
        this.settings.setValue("background-task", Boolean.valueOf(this.checkBackgroundTask.isSelected()));
        this.settings.setValue("width", Long.valueOf(this.getWidth()));
        this.settings.setValue("height", Long.valueOf(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveData() {
        block42: {
            boolean background;
            Query dest;
            Query select;
            Query source;
            block41: {
                PleaseWait pw = null;
                source = this.query;
                Database destDatabase = (Database)this.comboConnections.getSelectedItem();
                select = destDatabase.createQuery();
                Command insert = destDatabase.createCommand();
                Command update = destDatabase.createCommand();
                Command commit = destDatabase.createCommand();
                dest = destDatabase.createQuery();
                Task task = null;
                if (Thread.currentThread() instanceof TaskExecutor) {
                    task = ((TaskExecutor)Thread.currentThread()).getCurrentTask();
                }
                background = this.checkBackgroundTask.isSelected();
                try {
                    if (background) {
                        source = (Query)this.query.clone();
                        if (source == null) {
                            throw new UseDBException(stringManager.getString("mdd-cant-background-move-data"));
                        }
                        source.setCacheData(false);
                        source.open();
                        pw = new PleaseWait((Image)null, stringManager.getString("mdd-moving-data"));
                        Application.get().startPleaseWait(pw);
                    } else {
                        source.first();
                    }
                    insert.setSqlText(this.config.getInsertCommand());
                    if (!this.config.isNoUpdate()) {
                        select.setSqlText(this.config.getSelectCommand());
                        update.setSqlText(this.config.getUpdateCommand());
                    }
                    commit.setSqlText("COMMIT");
                    if (this.config.isDestParamTypes()) {
                        try {
                            dest.setSqlText("select * from " + this.config.getTableName() + " where 1 = 0");
                            dest.open();
                        }
                        catch (Exception ex) {
                            dest.close();
                            dest = null;
                        }
                    }
                    Parameter[] insParams = new Parameter[source.getFieldCount()];
                    Parameter[] selParams = new Parameter[source.getFieldCount()];
                    Parameter[] updParams = new Parameter[source.getFieldCount()];
                    QueryField[] destFields = new QueryField[source.getFieldCount()];
                    for (int i = 0; i < source.getFieldCount(); ++i) {
                        QueryField field = source.getField(i);
                        String paramName = SQLUtil.paramNameFromColumnName((String)field.getFieldName().toUpperCase());
                        insParams[i] = insert.getParameterList().findParamByName(paramName);
                        if (insParams[i] == null) {
                            insParams[i] = insert.getParameterList().findParamByName('&' + paramName);
                        }
                        if (dest != null) {
                            destFields[i] = dest.findFieldByName(field.getFieldName());
                        }
                        if (this.config.isNoUpdate()) continue;
                        selParams[i] = select.getParameterList().findParamByName(paramName);
                        if (selParams[i] == null) {
                            selParams[i] = select.getParameterList().findParamByName('&' + paramName);
                        }
                        updParams[i] = update.getParameterList().findParamByName(paramName);
                        if (updParams[i] != null) continue;
                        updParams[i] = update.getParameterList().findParamByName('&' + paramName);
                    }
                    int count = 1;
                    while (!source.eof()) {
                        block40: {
                            if (pw != null && count % 100 == 0) {
                                pw.setMessage(String.format(stringManager.getString("mdd-moving-data-count"), count));
                            }
                            for (int i = 0; i < source.getFieldCount(); ++i) {
                                QueryField field = source.getField(i);
                                if (insParams[i] != null) {
                                    insParams[i].setValue((Object)field.getValue(), destFields[i] != null ? destFields[i].getDataType() : field.getDataType());
                                }
                                if (this.config.isNoUpdate()) continue;
                                if (select.isActive()) {
                                    select.close();
                                }
                                if (selParams[i] != null) {
                                    selParams[i].setValue((Object)field.getValue(), destFields[i] != null ? destFields[i].getDataType() : field.getDataType());
                                }
                                if (updParams[i] == null) continue;
                                updParams[i].setValue((Object)field.getValue(), destFields[i] != null ? destFields[i].getDataType() : field.getDataType());
                            }
                            try {
                                if (this.config.isNoUpdate()) {
                                    insert.execute();
                                } else {
                                    select.open();
                                    if (!select.eof()) {
                                        update.execute();
                                    } else {
                                        insert.execute();
                                    }
                                }
                                if (this.config.isCommit() && count % this.config.getCommitCount() == 0) {
                                    commit.execute();
                                }
                            }
                            catch (Exception ex) {
                                if (this.config.isIgnoreErrors()) break block40;
                                throw ex;
                            }
                        }
                        if (task != null) {
                            if (task.isCanceled()) break;
                            if (count % 100 == 0) {
                                task.setDescription(String.format(stringManager.getString("mdd-moving-data-count"), count));
                            }
                        }
                        ++count;
                        source.next();
                    }
                    if (this.config.isCommit()) {
                        commit.execute();
                    }
                    if (pw == null) break block41;
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                    if (background) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                            }
                        });
                    } else {
                        MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                    }
                    break block42;
                }
                finally {
                    if (pw != null) {
                        Application.get().stopPleaseWait(pw);
                    }
                    if (dest != null) {
                        dest.close();
                    }
                    if (background) {
                        source.close();
                    }
                    select.close();
                }
                Application.get().stopPleaseWait(pw);
            }
            if (dest != null) {
                dest.close();
            }
            if (background) {
                source.close();
            }
            select.close();
        }
        return true;
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmOpen = new Action();
        this.cmCreateInsertCommand = new Action();
        this.cmCreateUpdateCommand = new Action();
        this.cmSave = new Action();
        this.cmCreateSelectCommand = new Action();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.comboDefs = new ComboBox();
        this.buttonOpen = new JButton();
        this.jLabel2 = new JLabel();
        this.comboConnections = new ComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.comboTable = new ComboBox();
        this.jToolBar1 = new JToolBar();
        this.toolButton1 = new ToolButton();
        this.textInsert = new OrbadaSyntaxTextArea();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.textCheckSelect = new OrbadaSyntaxTextArea();
        this.jLabel5 = new JLabel();
        this.jToolBar2 = new JToolBar();
        this.toolButton2 = new ToolButton();
        this.textUpdate = new OrbadaSyntaxTextArea();
        this.jToolBar3 = new JToolBar();
        this.toolButton3 = new ToolButton();
        this.jPanel4 = new JPanel();
        this.checkCommit = new JCheckBox();
        this.spinCommit = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jButton1 = new JButton();
        this.checkNoUpdate = new JCheckBox();
        this.checkIgnoreIU = new JCheckBox();
        this.checkDestTypes = new JCheckBox();
        this.checkBackgroundTask = new JCheckBox();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setText(stringManager.getString("ok-amp"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveDataDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cancel-amp"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveDataDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmOpen.setActionCommandKey("cmOpen");
        this.cmOpen.setText(stringManager.getString("mdd-cmopen-text"));
        this.cmOpen.setTooltip(stringManager.getString("mdd-cmopen-hint"));
        this.cmOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveDataDialog.this.cmOpenActionPerformed(evt);
            }
        });
        this.cmCreateInsertCommand.setActionCommandKey("cmCreateInsertCommand");
        this.cmCreateInsertCommand.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/add_table16.gif")));
        this.cmCreateInsertCommand.setText(stringManager.getString("mdd-cmcreateinsert-text"));
        this.cmCreateInsertCommand.setTooltip(stringManager.getString("mdd-cmcreateinsert-hint"));
        this.cmCreateInsertCommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveDataDialog.this.cmCreateInsertCommandActionPerformed(evt);
            }
        });
        this.cmCreateUpdateCommand.setActionCommandKey("cmCreateUpdateCommand");
        this.cmCreateUpdateCommand.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/add_table16.gif")));
        this.cmCreateUpdateCommand.setText(stringManager.getString("mdd-cmcreateupdate-text"));
        this.cmCreateUpdateCommand.setTooltip(stringManager.getString("mdd-cmcreateupdate-hint"));
        this.cmCreateUpdateCommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveDataDialog.this.cmCreateUpdateCommandActionPerformed(evt);
            }
        });
        this.cmSave.setActionCommandKey("cmSave");
        this.cmSave.setText(stringManager.getString("save-amp"));
        this.cmSave.setTooltip(stringManager.getString("mdd-cmsave-hint"));
        this.cmSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveDataDialog.this.cmSaveActionPerformed(evt);
            }
        });
        this.cmCreateSelectCommand.setActionCommandKey("cmCreateSelectCommand");
        this.cmCreateSelectCommand.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/add_table16.gif")));
        this.cmCreateSelectCommand.setText(stringManager.getString("mdd-cmcreateselect-text"));
        this.cmCreateSelectCommand.setTooltip(stringManager.getString("mdd-cmcreateselect-hint"));
        this.cmCreateSelectCommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoveDataDialog.this.cmCreateSelectCommandActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("mdd-title"));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.jTabbedPane1.setFocusable(false);
        this.jLabel1.setText(stringManager.getString("mdd-select-definition-dd"));
        this.comboDefs.setEditable(true);
        this.buttonOpen.setAction((javax.swing.Action)this.cmOpen);
        this.buttonOpen.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOpen.setPreferredSize(new Dimension(85, 25));
        this.jLabel2.setText(stringManager.getString("mdd-select-dest-connection-dd"));
        this.comboConnections.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MoveDataDialog.this.comboConnectionsItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.comboConnections, -1, 580, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.comboDefs, -1, 489, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOpen, -2, -1, -2)).addComponent(this.jLabel1).addComponent(this.jLabel2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboDefs, -2, -1, -2).addComponent(this.buttonOpen, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboConnections, -2, -1, -2).addContainerGap(222, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(stringManager.getString("definition"), this.jPanel1);
        this.jLabel3.setText(stringManager.getString("mdd-dest-table-dd"));
        this.comboTable.setEditable(true);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.toolButton1.setAction((javax.swing.Action)this.cmCreateInsertCommand);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.toolButton1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboTable, -1, 460, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textInsert, -1, 546, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.comboTable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 288, Short.MAX_VALUE).addComponent((Component)this.textInsert, -1, 288, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("insert-command"), this.jPanel2);
        this.jLabel4.setText(stringManager.getString("mdd-select-update-dd"));
        this.jLabel5.setText(stringManager.getString("mdd-update-data-command-dd"));
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setOrientation(1);
        this.jToolBar2.setRollover(true);
        this.toolButton2.setAction((javax.swing.Action)this.cmCreateUpdateCommand);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.jToolBar2.add((Component)this.toolButton2);
        this.jToolBar3.setFloatable(false);
        this.jToolBar3.setOrientation(1);
        this.jToolBar3.setRollover(true);
        this.toolButton3.setAction((javax.swing.Action)this.cmCreateSelectCommand);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.jToolBar3.add((Component)this.toolButton3);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jToolBar2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textUpdate, -1, 546, Short.MAX_VALUE)).addComponent(this.jLabel4).addComponent(this.jLabel5).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jToolBar3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textCheckSelect, -1, 546, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textCheckSelect, -1, 129, Short.MAX_VALUE).addComponent(this.jToolBar3, -1, 129, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textUpdate, -1, 141, Short.MAX_VALUE).addComponent(this.jToolBar2, -1, 141, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("update-command"), this.jPanel3);
        this.checkCommit.setText(stringManager.getString("mdd-execute-commit"));
        this.spinCommit.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1));
        this.jLabel6.setText(stringManager.getString("mdd-commands"));
        this.jButton1.setAction((javax.swing.Action)this.cmSave);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.setPreferredSize(new Dimension(85, 25));
        this.checkNoUpdate.setText(stringManager.getString("mdd-do-not-execute-update"));
        this.checkIgnoreIU.setText(stringManager.getString("mdd-ignore-error-insert-update"));
        this.checkDestTypes.setText(stringManager.getString("mdd-types-equal-dest-table"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.checkCommit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinCommit, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addContainerGap(366, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(505, Short.MAX_VALUE).addComponent(this.jButton1, -2, -1, -2).addContainerGap()).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.checkNoUpdate).addContainerGap(407, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.checkIgnoreIU).addContainerGap(323, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.checkDestTypes).addContainerGap(357, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkCommit).addComponent(this.spinCommit, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNoUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkIgnoreIU).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDestTypes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 201, Short.MAX_VALUE).addComponent(this.jButton1, -2, -1, -2).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("execution"), this.jPanel4);
        this.checkBackgroundTask.setText(stringManager.getString("execute-background"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.checkBackgroundTask).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 336, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.jTabbedPane1, -1, 605, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 363, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.checkBackgroundTask)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.updateConfig();
        if (this.checkBackgroundTask.isSelected()) {
            TaskPool.getTaskPool((String)"move-data-plugin").addTask(new Task(){

                public void run() {
                    MoveDataDialog.this.moveData();
                }
            });
            this.modalResult = 1;
            this.dispose();
        } else if (this.moveData()) {
            this.modalResult = 1;
            this.dispose();
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOpenActionPerformed(ActionEvent evt) {
        File file = FileUtil.selectFileToOpen((Component)this, (String)stringManager.getString("mdd-open-data-move-file"), (String)OrbadaDataMovePlugin.getDefaultPath(), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("data-move-file"), ".datamove")});
        if (file != null) {
            this.comboDefs.setText(file.getPath());
        }
    }

    private void cmSaveActionPerformed(ActionEvent evt) {
        File file;
        File lastFile = null;
        if (!StringUtil.isEmpty((String)this.comboDefs.getText())) {
            lastFile = new File(this.comboDefs.getText());
        }
        if ((file = FileUtil.selectFileToSave((Component)this, (String)stringManager.getString("mdd-save-data-move-file"), (String)OrbadaDataMovePlugin.getDefaultPath(), (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("data-move-file"), ".datamove")})) != null) {
            this.saveConfig(file);
        }
    }

    private void cmCreateInsertCommandActionPerformed(ActionEvent evt) {
        StringBuffer columns = new StringBuffer();
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < this.query.getFieldCount(); ++i) {
            QueryField field = this.query.getField(i);
            columns.append((columns.length() > 0 ? ", " : "") + SQLUtil.createSqlName((String)field.getFieldName()));
            params.append((params.length() > 0 ? ", " : "") + ":" + SQLUtil.paramNameFromColumnName((String)field.getFieldName().toUpperCase()));
        }
        this.textInsert.setText("INSERT INTO " + this.comboTable.getText() + " (" + columns.toString() + ")\n" + "VALUES (" + params.toString() + ")");
    }

    private void cmCreateUpdateCommandActionPerformed(ActionEvent evt) {
        StringBuffer columns = new StringBuffer();
        QueryField firstField = null;
        for (int i = 0; i < this.query.getFieldCount(); ++i) {
            QueryField field = this.query.getField(i);
            if (firstField == null) {
                firstField = field;
                continue;
            }
            columns.append((columns.length() > 0 ? ",\n  " : "") + SQLUtil.createSqlName((String)field.getFieldName()) + " = :" + SQLUtil.paramNameFromColumnName((String)field.getFieldName().toUpperCase()));
        }
        this.textUpdate.setText("UPDATE " + this.comboTable.getText() + " SET\n" + "  " + columns.toString() + "\n" + " WHERE " + SQLUtil.createSqlName((String)firstField.getFieldName()) + " = :" + SQLUtil.paramNameFromColumnName((String)firstField.getFieldName().toUpperCase()));
    }

    private void cmCreateSelectCommandActionPerformed(ActionEvent evt) {
        QueryField firstField = this.query.getField(0);
        this.textCheckSelect.setText("SELECT 0 TEST_COLUMN\n  FROM " + this.comboTable.getText() + "\n" + " WHERE " + SQLUtil.createSqlName((String)firstField.getFieldName()) + " = :" + SQLUtil.paramNameFromColumnName((String)firstField.getFieldName().toUpperCase()));
    }

    private void comboConnectionsItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.textInsert.setDatabase((Database)evt.getItem());
            this.textCheckSelect.setDatabase((Database)evt.getItem());
            this.textUpdate.setDatabase((Database)evt.getItem());
        }
    }
}

