/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.datamove.gui;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.datamove.OrbadaDataMovePlugin;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class QueryCreateTableWizardPanel
extends SqlCodeWizardPanel {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDataMovePlugin.class);
    private Query query;
    private ComboBox comboConnections;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private ComboBox textQuotedChar;
    private TextField textTableName;

    public QueryCreateTableWizardPanel(Query query) {
        this.query = query;
        this.initComponents();
    }

    public void wizardShow() {
        DefaultComboBoxModel<Database> model = new DefaultComboBoxModel<Database>();
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            Database database = DatabaseManager.getManager().getDatabase(i);
            if (database.equals(InternalDatabase.get()) && !Application.get().isUserAdmin()) continue;
            model.addElement(database);
        }
        this.comboConnections.setModel(model);
        this.comboConnections.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Database database = (Database)value;
                    String text = "<html>";
                    text = database.getPublicName() == null ? text + "<b>" + database.getUserName() + "</b>" : text + "<b>" + database.getPublicName() + "</b> as " + database.getUserName();
                    label.setText(text);
                    label.setVerticalAlignment(1);
                }
                return label;
            }
        });
    }

    public String getDialogTitle() {
        return stringManager.getString("qctwp-create-table-command");
    }

    public String getTabTitle() {
        return stringManager.getString("table");
    }

    public String getSqlCode() {
        try {
            return QueryUtil.queryToCreateTable((Query)this.query, (Database)((Database)this.comboConnections.getSelectedItem()), (String)this.textTableName.getText(), (String)this.textQuotedChar.getText());
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return "";
        }
    }

    public boolean execute() {
        try {
            if (this.comboConnections.getSelectedItem() instanceof Database) {
                Database database = (Database)this.comboConnections.getSelectedItem();
                database.executeCommand(this.getSqlCode());
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textTableName = new TextField();
        this.jLabel2 = new JLabel();
        this.textQuotedChar = new ComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.comboConnections = new ComboBox();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(stringManager.getString("qctwp-table-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("qctwp-table-name-char-dd"));
        this.textQuotedChar.setEditable(true);
        this.textQuotedChar.setModel(new DefaultComboBoxModel<String>(new String[]{"\"", "'", "`"}));
        this.jLabel3.setText(stringManager.getString("qctwp-ext-info-html"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("qctwp-dest-connection-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, 476, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 125, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.comboConnections, -1, 347, Short.MAX_VALUE).addComponent((Component)this.textTableName, GroupLayout.Alignment.LEADING, -1, 347, Short.MAX_VALUE).addComponent((Component)this.textQuotedChar, GroupLayout.Alignment.LEADING, -2, 115, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textTableName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textQuotedChar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboConnections, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 178, Short.MAX_VALUE).addComponent(this.jLabel3).addContainerGap()));
    }
}

