/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.datamove.services;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import pl.mpak.orbada.datamove.OrbadaDataMovePlugin;
import pl.mpak.orbada.datamove.gui.MoveDataDialog;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ExportMoveDataService
extends ExportTableActionProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDataMovePlugin.class);

    public ExportMoveDataService() {
        this.setText(stringManager.getString("emds-text"));
        this.setTooltip(stringManager.getString("emds-hint"));
        this.setActionCommandKey("cmExportMoveDataService");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return stringManager.getString("emds-description");
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                final JTable table = ExportMoveDataService.this.getTable(event);
                if (table != null && table instanceof QueryTable) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            MoveDataDialog.show(((QueryTable)table).getQuery());
                        }
                    });
                }
            }
        };
    }

    public String getGroupName() {
        return "Orbada Tools";
    }
}

