/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.resource.ResourceException;

public class FBResourceException
extends ResourceException {
    public static final String SQL_STATE_GENERAL_ERROR = "HY000";

    public FBResourceException(String reason) {
        super(reason, SQL_STATE_GENERAL_ERROR);
    }

    public FBResourceException(String reason, String errorCode) {
        super(reason, errorCode);
    }

    public FBResourceException(String reason, Exception original) {
        super(reason, SQL_STATE_GENERAL_ERROR);
        this.setLinkedException(original);
    }

    public FBResourceException(Exception original) {
        super(original.getMessage(), SQL_STATE_GENERAL_ERROR);
        this.setLinkedException(original);
    }

    @Override
    public String getMessage() {
        String s = super.getMessage();
        if (this.getLinkedException() == null) {
            return s;
        }
        if (s == null) {
            return this.getLinkedException().getMessage();
        }
        return s + "\nReason: " + this.getLinkedException().getMessage();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.getLinkedException() != null) {
            s.print("at ");
            this.getLinkedException().printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.getLinkedException() != null) {
            s.print("at ");
            this.getLinkedException().printStackTrace(s);
        }
    }
}

