/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlscripts.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.sqlscripts.OrbadaSqlScriptsPlugin;
import pl.mpak.orbada.sqlscripts.db.SqlScriptRecord;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SqlScriptEditDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSqlScriptsPlugin.class);
    private String oss_id;
    private String dtp_id;
    private int modalResult = 0;
    private SqlScriptRecord sqlScript;
    private RecordLink templateLink;
    private Database forDatabase;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private TextField textName;
    private OrbadaSyntaxTextArea textSqlScript;

    public SqlScriptEditDialog(Database forDatabase, String oss_id, String dtp_id) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.oss_id = oss_id;
        this.dtp_id = dtp_id;
        this.forDatabase = forDatabase;
        this.initComponents();
        this.init();
    }

    public static int showDialog(Database forDatabase, String oss_id, String dtp_id) throws IntrospectionException, UseDBException {
        SqlScriptEditDialog dialog = new SqlScriptEditDialog(forDatabase, oss_id, dtp_id);
        dialog.setVisible(true);
        return dialog.getModalResult();
    }

    private void init() throws IntrospectionException, UseDBException {
        SwingUtil.centerWithinScreen((Window)this);
        this.templateLink = new RecordLink();
        this.templateLink.add("OSS_NAME", (Component)this.textName);
        this.templateLink.add("OSS_SCRIPT", (Component)this.textSqlScript);
        if (this.oss_id != null) {
            this.sqlScript = new SqlScriptRecord(InternalDatabase.get(), this.oss_id);
        } else {
            this.sqlScript = new SqlScriptRecord(InternalDatabase.get());
            this.sqlScript.setUsrId(Application.get().getUserId());
            this.sqlScript.setDtpId(this.dtp_id);
        }
        this.templateLink.updateComponents((BufferedRecord)this.sqlScript);
        this.textSqlScript.setDatabase(this.forDatabase);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void dispose() {
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jLabel1 = new JLabel();
        this.textName = new TextField();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel3 = new JLabel();
        this.textSqlScript = new OrbadaSyntaxTextArea();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("ok-action"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlScriptEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cancel-action"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlScriptEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("edit-sql-script"));
        this.setModal(true);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor((Component)this.textName);
        this.jLabel1.setText(this.stringManager.getString("name-collon"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jLabel3.setLabelFor((Component)this.textName);
        this.jLabel3.setText(this.stringManager.getString("template-collon"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textSqlScript, -1, 565, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 423, Short.MAX_VALUE)).addComponent(this.jLabel3)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSqlScript, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.templateLink.updateRecord((BufferedRecord)this.sqlScript);
            if (this.sqlScript.isChanged()) {
                if (this.oss_id == null) {
                    this.sqlScript.applyInsert();
                } else {
                    this.sqlScript.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }
}

