/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlscripts.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.sqlscripts.OrbadaSqlScriptsPlugin;
import pl.mpak.orbada.sqlscripts.db.SqlScriptRecord;
import pl.mpak.orbada.sqlscripts.gui.SqlScriptEditDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class SqlScriptListDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSqlScriptsPlugin.class);
    private ISettings settings;
    private String dtp_id;
    private Database forDatabase;
    private JButton buttonClose;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonNew;
    private Action cmClose;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmNew;
    private JScrollPane jScrollPane1;
    private ViewTable tableSqlScripts;

    public SqlScriptListDialog(Database forDatabase) {
        super(SwingUtil.getRootFrame());
        this.forDatabase = forDatabase;
        this.dtp_id = forDatabase.getUserProperties().getProperty("dtp_id");
        this.initComponents();
        this.init();
    }

    public static void showDialog(Database forDatabase) {
        SqlScriptListDialog dialog = new SqlScriptListDialog(forDatabase);
        dialog.setVisible(true);
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-sql-script-list-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.tableSqlScripts.getQuery().setDatabase(InternalDatabase.get());
        this.tableSqlScripts.getQuery().addQueryListener(new QueryListener(){

            public void beforeScroll(EventObject e) {
            }

            public void afterScroll(EventObject e) {
            }

            public void beforeOpen(EventObject e) {
            }

            public void afterOpen(EventObject e) {
                SqlScriptListDialog.this.cmNew.setEnabled(true);
            }

            public void beforeClose(EventObject e) {
            }

            public void afterClose(EventObject e) {
                SqlScriptListDialog.this.cmNew.setEnabled(false);
                SqlScriptListDialog.this.cmEdit.setEnabled(false);
                SqlScriptListDialog.this.cmDelete.setEnabled(false);
            }

            public void flushedPerformed(EventObject e) {
            }

            public void errorPerformed(EventObject e) {
            }
        });
        this.tableSqlScripts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SqlScriptListDialog.this.tableSqlScripts.getSelectedRow() >= 0) {
                    try {
                        SqlScriptListDialog.this.tableSqlScripts.getQuery().getRecord(SqlScriptListDialog.this.tableSqlScripts.getSelectedRow());
                        SqlScriptListDialog.this.cmEdit.setEnabled(true);
                        SqlScriptListDialog.this.cmDelete.setEnabled(true);
                    }
                    catch (Exception ex) {
                        MessageBox.show((Component)SqlScriptListDialog.this, (String)SqlScriptListDialog.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                    }
                } else {
                    SqlScriptListDialog.this.cmEdit.setEnabled(false);
                    SqlScriptListDialog.this.cmDelete.setEnabled(false);
                }
            }
        });
        try {
            this.tableSqlScripts.addColumn((TableColumn)new QueryTableColumn("oss_name", this.stringManager.getString("sql-script"), 450, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableSqlScripts.getQuery().setSqlText("select oss_id, oss_name\n  from osqlscripts\n where oss_usr_id = :USR_ID\n   and oss_dtp_id = :DTP_ID\n order by oss_name");
            this.tableSqlScripts.getQuery().paramByName("usr_id").setString(Application.get().getUserId());
            this.tableSqlScripts.getQuery().paramByName("dtp_id").setString(this.dtp_id);
            this.tableSqlScripts.getQuery().open();
            if (!this.tableSqlScripts.getQuery().isEmpty()) {
                this.tableSqlScripts.changeSelection(0, 0);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        this.tableSqlScripts.getQuery().close();
        super.dispose();
    }

    public void refreshQuery() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int lastRow = SqlScriptListDialog.this.tableSqlScripts.getSelectedRow();
                try {
                    SqlScriptListDialog.this.tableSqlScripts.getQuery().refresh();
                    if (SqlScriptListDialog.this.tableSqlScripts.getRowCount() > lastRow && lastRow >= 0) {
                        SqlScriptListDialog.this.tableSqlScripts.changeSelection(lastRow, lastRow);
                    } else if (SqlScriptListDialog.this.tableSqlScripts.getRowCount() > 0) {
                        SqlScriptListDialog.this.tableSqlScripts.changeSelection(0, 0);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.buttonClose = new JButton();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableSqlScripts = new ViewTable();
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(this.stringManager.getString("close-action"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlScriptListDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmNew.setEnabled(false);
        this.cmNew.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/new16.gif")));
        this.cmNew.setText(this.stringManager.getString("new-action"));
        this.cmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlScriptListDialog.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setEnabled(false);
        this.cmEdit.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/edit16.gif")));
        this.cmEdit.setText(this.stringManager.getString("edit-action"));
        this.cmEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlScriptListDialog.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setEnabled(false);
        this.cmDelete.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/trash.gif")));
        this.cmDelete.setText(this.stringManager.getString("delete-action"));
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlScriptListDialog.this.cmDeleteActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("define-sql-scripts"));
        this.setModal(true);
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(75, 23));
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 23));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 23));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 23));
        this.jScrollPane1.setViewportView((Component)this.tableSqlScripts);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 479, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 137, Short.MAX_VALUE).addComponent(this.buttonClose, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 291, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2).addComponent(this.buttonClose, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        if (this.tableSqlScripts.getQuery().isActive() && this.tableSqlScripts.getSelectedRow() >= 0) {
            try {
                this.tableSqlScripts.getQuery().getRecord(this.tableSqlScripts.getSelectedRow());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("sql-script-deleting-question"), this.tableSqlScripts.getQuery().fieldByName("OSS_NAME").getString()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    SqlScriptRecord sqlScript = new SqlScriptRecord(InternalDatabase.get());
                    sqlScript.getPrimaryKeyField().setValue(new Variant(this.tableSqlScripts.getQuery().fieldByName("OSS_ID").getString()));
                    sqlScript.applyDelete();
                    this.refreshQuery();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSqlScripts.getQuery().isActive() && this.tableSqlScripts.getSelectedRow() >= 0) {
                this.tableSqlScripts.getQuery().getRecord(this.tableSqlScripts.getSelectedRow());
                if (SqlScriptEditDialog.showDialog(this.forDatabase, this.tableSqlScripts.getQuery().fieldByName("oss_id").getString(), this.dtp_id) == 1) {
                    this.refreshQuery();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSqlScripts.getQuery().isActive() && SqlScriptEditDialog.showDialog(this.forDatabase, null, this.dtp_id) == 1) {
                this.refreshQuery();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

