/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlscripts.services;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.sqlscripts.OrbadaSqlScriptsPlugin;
import pl.mpak.orbada.sqlscripts.cm.SqlScriptCallAction;
import pl.mpak.orbada.sqlscripts.cm.SqlScriptDefineAction;
import pl.mpak.orbada.sqlscripts.db.SqlScriptRecord;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SqlScriptPerspectiveProvider
extends PerspectiveProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSqlScriptsPlugin.class);
    private JMenu scripts;

    public boolean isForDatabase(Database database) {
        return database != null;
    }

    public String getDescription() {
        return this.stringManager.getString("perspective-provider-description");
    }

    public String getGroupName() {
        return "Orbada Tools";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSqlScripts() {
        this.scripts.removeAll();
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.setSqlText("select *\n  from osqlscripts\n where oss_usr_id = :USR_ID\n   and oss_dtp_id = :DTP_ID\n order by oss_name");
            query.paramByName("usr_id").setString(this.accesibilities.getApplication().getUserId());
            query.paramByName("dtp_id").setString(this.accesibilities.getDatabase().getUserProperties().getProperty("dtp_id"));
            query.open();
            while (!query.eof()) {
                SqlScriptRecord record = new SqlScriptRecord(this.accesibilities.getApplication().getOrbadaDatabase());
                record.updateFrom(query);
                this.scripts.add((Action)((Object)new SqlScriptCallAction(this.accesibilities.getDatabase(), record)));
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.scripts.addSeparator();
        this.scripts.add((Action)((Object)new SqlScriptDefineAction(this)));
    }

    public void initialize() {
        this.scripts = new JMenu();
        this.scripts.setText(SwingUtil.setButtonText((AbstractButton)this.scripts, (String)this.stringManager.getString("sql-scripts")));
        this.reloadSqlScripts();
        this.accesibilities.addMenu(this.scripts);
    }
}

