/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell;

import bsh.Interpreter;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.beanshell.gui.BeanShellEditorView;
import pl.mpak.orbada.beanshell.services.BeanshellSqlTextTransformProvider;
import pl.mpak.orbada.beanshell.services.BshActionsSettingsProvider;
import pl.mpak.orbada.beanshell.services.BshComponentActionsProvider;
import pl.mpak.orbada.beanshell.services.StartupShutdownSettingsService;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.util.ScriptUtil;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.patt.Resolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaBeanshellPlugin
extends OrbadaPlugin {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    public static final String beanshellGroupName = "Orbada Tools";
    public static final ArrayList<Class<? extends IPluginProvider>> classList = new ArrayList();
    public static final String rootSettingsPath = "BeanShell";
    public static final String bshActionsReloadMessage = "bsh-actions-reload";

    public String getInternalName() {
        return "OrbadaBeanshellPlugin";
    }

    public String getDescriptiveName() {
        return String.format(this.stringManager.getString("OrbadaBeanshellPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Tools,Scripting";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 1, 8).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-beanshell-plugin";
    }

    public void load() {
        File startupFile = OrbadaBeanshellPlugin.getStartupFile();
        if (startupFile.exists()) {
            Interpreter i = new Interpreter();
            try {
                i.eval((Reader)new FileReader(startupFile));
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public void unload() {
        File startupFile = OrbadaBeanshellPlugin.getShutdownFile();
        if (startupFile.exists()) {
            Interpreter i = new Interpreter();
            try {
                i.eval((Reader)new FileReader(startupFile));
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public void initialize() {
        classList.add(BeanShellEditorView.class);
        classList.add(StartupShutdownSettingsService.class);
        classList.add(BshActionsSettingsProvider.class);
        classList.add(BshComponentActionsProvider.class);
        if (this.application.isUserAdmin()) {
            if (this.getLastVersion() == null || new VersionID(this.getLastVersion()).getBuild() < 1) {
                ScriptUtil.executeInternalScript((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/pl/mpak/orbada/beanshell/sql/b0001.sql"));
            }
            if (this.getLastVersion() == null || new VersionID(this.getLastVersion()).getBuild() < 5) {
                ScriptUtil.executeInternalScript((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/pl/mpak/orbada/beanshell/sql/b0002.sql"));
            }
        }
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            classList.add(BeanshellSqlTextTransformProvider.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    public static File getStartupFile() {
        return new File(Resolvers.expand((String)"$(orbada.home)") + "/startup.bsh");
    }

    public static File getShutdownFile() {
        return new File(Resolvers.expand((String)"$(orbada.home)") + "/shutdown.bsh");
    }
}

