/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell.gui;

import bsh.ConsoleInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import pl.mpak.orbada.beanshell.BeanShellInterpreter;
import pl.mpak.orbada.beanshell.OrbadaBeanshellPlugin;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.files.PatternFileFilter;
import pl.mpak.util.files.WildCard;
import pl.mpak.util.id.UniqueID;

public class BeanShellEditorPanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    private IViewAccesibilities accesibilities;
    private BeanShellInterpreter interpreter;
    private File openedFile;
    private ArrayList<String> editorContentList;
    private String currentEditorContent;
    private ToolButton buttonDeleteEditor;
    private ToolButton buttonNewEditor;
    private ToolButton buttonNextEditor;
    private ToolButton buttonOpenFile;
    private ToolButton buttonPervEditor;
    private ToolButton buttonSaveFile;
    private ToolButton buttonSaveFileAs;
    private Action cmDeleteEditor;
    private Action cmNewEditor;
    private Action cmNextEditor;
    private Action cmOpenFile;
    private Action cmPrevEditor;
    private Action cmRun;
    private Action cmSaveFile;
    private Action cmSaveFileAs;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JMenuItem menuOpenFile;
    private JMenuItem menuRun;
    private JMenuItem menuSaveFile;
    private JMenuItem menuSaveFileAs;
    private JMenu menuView;
    private OrbadaJavaSyntaxTextArea syntaxBeanShell;
    private JTextArea textResult;
    private ToolButton toolButton1;

    public BeanShellEditorPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.menuView.setText(SwingUtil.setButtonText((AbstractButton)this.menuView, (String)this.stringManager.getString("BeanShellEditorPanelView-menuView-text")));
        this.editorContentList = new ArrayList();
        this.accesibilities.addMenu(this.menuView);
        SwingUtil.addAction((JPanel)this, (String)"cmRun", (javax.swing.Action)this.cmRun);
        SwingUtil.addAction((JComponent)this.syntaxBeanShell.getEditorArea(), (String)"cmSaveFile", (javax.swing.Action)this.cmSaveFile);
        this.interpreter = new BeanShellInterpreter(this.accesibilities.getDatabase()){

            public void clearResult() {
                BeanShellEditorPanelView.this.textResult.setText("");
            }
        };
        this.interpreter.setConsole(new ConsoleInterface(){

            public Reader getIn() {
                return null;
            }

            public PrintStream getOut() {
                return null;
            }

            public PrintStream getErr() {
                return null;
            }

            public void println(Object o) {
                if (o != null) {
                    BeanShellEditorPanelView.this.textResult.append(o.toString() + "\n");
                }
            }

            public void print(Object o) {
                if (o != null) {
                    BeanShellEditorPanelView.this.textResult.append(o.toString());
                }
            }

            public void error(Object o) {
                if (o != null) {
                    SimpleAttributeSet as = new SimpleAttributeSet();
                    StyleConstants.setForeground(as, Color.RED);
                    try {
                        BeanShellEditorPanelView.this.textResult.getDocument().insertString(BeanShellEditorPanelView.this.textResult.getDocument().getLength(), o.toString(), as);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.refreshEditorContentList(true);
    }

    public void close() throws IOException {
        if (this.currentEditorContent != null) {
            try {
                this.syntaxBeanShell.saveToFile(this.currentEditorContent);
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.accesibilities = null;
    }

    public IApplication getApplication() {
        return this.accesibilities.getApplication();
    }

    private void updateCurrentEditorContentFile() {
        int index = this.editorContentList.indexOf(this.currentEditorContent);
        this.currentEditorContent = this.openedFile.getAbsolutePath();
        if (index != -1) {
            this.editorContentList.set(index, this.currentEditorContent);
        }
    }

    private boolean saveFile() {
        if (this.openedFile != null) {
            try {
                this.syntaxBeanShell.saveToFile(this.openedFile);
                this.syntaxBeanShell.setChanged(false);
                this.updateCurrentEditorContentFile();
            }
            catch (IOException ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                return false;
            }
            return true;
        }
        return this.saveFileAs();
    }

    private boolean saveFileAs() {
        JFileChooser fileChoose = new JFileChooser(".");
        fileChoose.addChoosableFileFilter((FileFilter)new FileExtensionFilter(this.stringManager.getString("beanshell-files"), new String[]{".bsh"}));
        int returnVal = fileChoose.showSaveDialog(this);
        if (returnVal == 0) {
            this.openedFile = fileChoose.getSelectedFile().getAbsoluteFile();
            if (this.openedFile != null) {
                return this.saveFile();
            }
        }
        return false;
    }

    private boolean openFile() {
        JFileChooser fileChoose = new JFileChooser(".");
        try {
            if (this.openedFile != null) {
                fileChoose.setSelectedFile(this.openedFile);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        fileChoose.addChoosableFileFilter((FileFilter)new FileExtensionFilter(this.stringManager.getString("beanshell-files"), new String[]{".bsh"}));
        int returnVal = fileChoose.showOpenDialog(this);
        if (returnVal == 0) {
            this.openedFile = fileChoose.getSelectedFile().getAbsoluteFile();
            try {
                this.syntaxBeanShell.loadFromFile(this.openedFile);
                this.syntaxBeanShell.setChanged(false);
                this.updateCurrentEditorContentFile();
                return true;
            }
            catch (IOException ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
        return false;
    }

    private String getEditorContentPath() {
        return this.getApplication().getConfigPath() + "/beanshell-editor-contents";
    }

    private void updateEditorContentActions() {
        this.cmPrevEditor.setEnabled(this.currentEditorContent != null && this.editorContentList.indexOf(this.currentEditorContent) > 0);
        this.cmNextEditor.setEnabled(this.currentEditorContent != null && this.editorContentList.indexOf(this.currentEditorContent) < this.editorContentList.size() - 1);
    }

    private void refreshEditorContentList(boolean autoLoad) {
        String configPath = this.getEditorContentPath();
        File dir = new File(configPath);
        dir.mkdirs();
        Object[] fileList = dir.list((FilenameFilter)new PatternFileFilter(WildCard.getRegex((String)"*.bsh")));
        Arrays.sort(fileList);
        this.editorContentList.clear();
        for (int i = 0; i < fileList.length; ++i) {
            if (i > fileList.length - 100) {
                this.editorContentList.add(configPath + "/" + (String)fileList[i]);
                continue;
            }
            new File(configPath + "/" + (String)fileList[i]).delete();
        }
        if (!(this.currentEditorContent != null && this.editorContentList.contains(this.currentEditorContent) || this.editorContentList.size() <= 0)) {
            this.currentEditorContent = this.editorContentList.get(this.editorContentList.size() - 1);
            if (autoLoad) {
                try {
                    this.syntaxBeanShell.loadFromFile(this.currentEditorContent);
                    this.syntaxBeanShell.setChanged(false);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        if (this.currentEditorContent == null) {
            this.newEditorContent();
        } else {
            this.updateEditorContentActions();
        }
    }

    private void newEditorContent() {
        if (this.currentEditorContent != null) {
            try {
                this.syntaxBeanShell.saveToFile(this.currentEditorContent);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.currentEditorContent = this.getEditorContentPath() + "/" + new UniqueID().toString() + ".bsh";
        this.editorContentList.add(this.currentEditorContent);
        this.syntaxBeanShell.setText("");
        this.syntaxBeanShell.setChanged(false);
        this.updateEditorContentActions();
    }

    private void deleteEditorContent() {
        if (this.currentEditorContent != null) {
            int index = this.editorContentList.indexOf(this.currentEditorContent);
            if (this.openedFile == null || !this.currentEditorContent.equals(this.openedFile.getAbsolutePath())) {
                new File(this.currentEditorContent).delete();
            }
            this.editorContentList.remove(index);
            this.currentEditorContent = null;
            if (this.editorContentList.size() > 0) {
                this.currentEditorContent = this.editorContentList.get(index < this.editorContentList.size() ? index : index - 1);
                try {
                    this.syntaxBeanShell.loadFromFile(this.currentEditorContent);
                    this.syntaxBeanShell.setChanged(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.updateEditorContentActions();
            } else {
                this.newEditorContent();
            }
        }
    }

    private void initComponents() {
        this.cmRun = new Action();
        this.cmSaveFile = new Action();
        this.cmSaveFileAs = new Action();
        this.cmOpenFile = new Action();
        this.cmPrevEditor = new Action();
        this.cmNextEditor = new Action();
        this.cmNewEditor = new Action();
        this.cmDeleteEditor = new Action();
        this.menuView = new JMenu();
        this.menuOpenFile = new JMenuItem();
        this.menuSaveFile = new JMenuItem();
        this.menuSaveFileAs = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.menuRun = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.textResult = new JTextArea();
        this.syntaxBeanShell = new OrbadaJavaSyntaxTextArea();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.buttonOpenFile = new ToolButton();
        this.buttonSaveFile = new ToolButton();
        this.buttonSaveFileAs = new ToolButton();
        this.jSeparator3 = new JSeparator();
        this.buttonNewEditor = new ToolButton();
        this.buttonPervEditor = new ToolButton();
        this.buttonNextEditor = new ToolButton();
        this.jSeparator4 = new JSeparator();
        this.buttonDeleteEditor = new ToolButton();
        this.jSeparator5 = new JSeparator();
        this.toolButton1 = new ToolButton();
        this.cmRun.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmRun.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/run.gif"));
        this.cmRun.setText(this.stringManager.getString("cmRun-text"));
        this.cmRun.setTooltip(this.stringManager.getString("cmRun-hint"));
        this.cmRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmRunActionPerformed(evt);
            }
        });
        this.cmSaveFile.setActionCommandKey("cmSaveFile");
        this.cmSaveFile.setShortCut(KeyStroke.getKeyStroke(83, 2));
        this.cmSaveFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmSaveFile.setText(this.stringManager.getString("cmSaveFile-text"));
        this.cmSaveFile.setTooltip(this.stringManager.getString("cmSaveFile-hint"));
        this.cmSaveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmSaveFileActionPerformed(evt);
            }
        });
        this.cmSaveFileAs.setActionCommandKey("cmSaveFileAs");
        this.cmSaveFileAs.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save_as16.gif"));
        this.cmSaveFileAs.setText(this.stringManager.getString("cmSaveFileAs-text"));
        this.cmSaveFileAs.setTooltip(this.stringManager.getString("cmSaveFileAs-hint"));
        this.cmSaveFileAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmSaveFileAsActionPerformed(evt);
            }
        });
        this.cmOpenFile.setActionCommandKey("cmOpenFile");
        this.cmOpenFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/open_document16.gif"));
        this.cmOpenFile.setText(this.stringManager.getString("cmOpenFile-text"));
        this.cmOpenFile.setTooltip(this.stringManager.getString("cmOpenFile-hint"));
        this.cmOpenFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmOpenFileActionPerformed(evt);
            }
        });
        this.cmPrevEditor.setActionCommandKey("cmPrevEditor");
        this.cmPrevEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/arrowup.gif"));
        this.cmPrevEditor.setText(this.stringManager.getString("cmPrevEditor-text"));
        this.cmPrevEditor.setTooltip(this.stringManager.getString("cmPrevEditor-hint"));
        this.cmPrevEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmPrevEditorActionPerformed(evt);
            }
        });
        this.cmNextEditor.setActionCommandKey("cmNextEditor");
        this.cmNextEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/arrowdown.gif"));
        this.cmNextEditor.setText(this.stringManager.getString("cmNextEditor-text"));
        this.cmNextEditor.setTooltip(this.stringManager.getString("cmNextEditor-hint"));
        this.cmNextEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmNextEditorActionPerformed(evt);
            }
        });
        this.cmNewEditor.setActionCommandKey("cmNewEditor");
        this.cmNewEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_document16.gif"));
        this.cmNewEditor.setText(this.stringManager.getString("cmNewEditor-text"));
        this.cmNewEditor.setTooltip(this.stringManager.getString("cmNewEditor-hint"));
        this.cmNewEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmNewEditorActionPerformed(evt);
            }
        });
        this.cmDeleteEditor.setActionCommandKey("cmDeleteEditor");
        this.cmDeleteEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/minus16.gif"));
        this.cmDeleteEditor.setText(this.stringManager.getString("cmDeleteEditor-text"));
        this.cmDeleteEditor.setTooltip(this.stringManager.getString("cmDeleteEditor-hint"));
        this.cmDeleteEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellEditorPanelView.this.cmDeleteEditorActionPerformed(evt);
            }
        });
        this.menuOpenFile.setAction((javax.swing.Action)this.cmOpenFile);
        this.menuView.add(this.menuOpenFile);
        this.menuSaveFile.setAction((javax.swing.Action)this.cmSaveFile);
        this.menuView.add(this.menuSaveFile);
        this.menuSaveFileAs.setAction((javax.swing.Action)this.cmSaveFileAs);
        this.menuView.add(this.menuSaveFileAs);
        this.menuView.add(this.jSeparator6);
        this.menuRun.setAction((javax.swing.Action)this.cmRun);
        this.menuView.add(this.menuRun);
        this.setFocusable(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                BeanShellEditorPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setFocusable(false);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jScrollPane1.setPreferredSize(new Dimension(106, 200));
        this.textResult.setColumns(20);
        this.textResult.setEditable(false);
        this.textResult.setRows(5);
        this.jScrollPane1.setViewportView(this.textResult);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setLeftComponent((Component)this.syntaxBeanShell);
        this.add((Component)this.jSplitPane1, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonOpenFile.setAction((javax.swing.Action)this.cmOpenFile);
        this.buttonOpenFile.setHorizontalTextPosition(0);
        this.buttonOpenFile.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonOpenFile);
        this.buttonSaveFile.setAction((javax.swing.Action)this.cmSaveFile);
        this.buttonSaveFile.setHorizontalTextPosition(0);
        this.buttonSaveFile.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonSaveFile);
        this.buttonSaveFileAs.setAction((javax.swing.Action)this.cmSaveFileAs);
        this.buttonSaveFileAs.setHorizontalTextPosition(0);
        this.buttonSaveFileAs.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonSaveFileAs);
        this.jSeparator3.setOrientation(1);
        this.jSeparator3.setPreferredSize(new Dimension(2, 2));
        this.jToolBar1.add(this.jSeparator3);
        this.buttonNewEditor.setAction((javax.swing.Action)this.cmNewEditor);
        this.buttonNewEditor.setHorizontalTextPosition(0);
        this.buttonNewEditor.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonNewEditor);
        this.buttonPervEditor.setAction((javax.swing.Action)this.cmPrevEditor);
        this.buttonPervEditor.setHorizontalTextPosition(0);
        this.buttonPervEditor.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonPervEditor);
        this.buttonNextEditor.setAction((javax.swing.Action)this.cmNextEditor);
        this.buttonNextEditor.setHorizontalTextPosition(0);
        this.buttonNextEditor.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonNextEditor);
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setPreferredSize(new Dimension(2, 2));
        this.jToolBar1.add(this.jSeparator4);
        this.buttonDeleteEditor.setAction((javax.swing.Action)this.cmDeleteEditor);
        this.buttonDeleteEditor.setHorizontalTextPosition(0);
        this.buttonDeleteEditor.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonDeleteEditor);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setPreferredSize(new Dimension(2, 2));
        this.jToolBar1.add(this.jSeparator5);
        this.toolButton1.setAction((javax.swing.Action)this.cmRun);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.toolButton1);
        this.jPanel1.add((Component)this.jToolBar1, "West");
        this.add((Component)this.jPanel1, "North");
    }

    private void formComponentShown(ComponentEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BeanShellEditorPanelView.this.syntaxBeanShell.requestFocusInWindow();
            }
        });
    }

    private void cmDeleteEditorActionPerformed(ActionEvent evt) {
        this.deleteEditorContent();
    }

    private void cmNewEditorActionPerformed(ActionEvent evt) {
        this.newEditorContent();
    }

    private void cmNextEditorActionPerformed(ActionEvent evt) {
        if (this.currentEditorContent != null) {
            try {
                this.syntaxBeanShell.saveToFile(this.currentEditorContent);
                if (this.openedFile != null && this.currentEditorContent.equals(this.openedFile.getAbsolutePath())) {
                    this.syntaxBeanShell.setChanged(false);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            int index = this.editorContentList.indexOf(this.currentEditorContent);
            if (index < this.editorContentList.size() - 1) {
                this.currentEditorContent = this.editorContentList.get(index + 1);
                try {
                    this.syntaxBeanShell.loadFromFile(this.currentEditorContent);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.updateEditorContentActions();
    }

    private void cmPrevEditorActionPerformed(ActionEvent evt) {
        if (this.currentEditorContent != null) {
            try {
                this.syntaxBeanShell.saveToFile(this.currentEditorContent);
                if (this.openedFile != null && this.currentEditorContent.equals(this.openedFile.getAbsolutePath())) {
                    this.syntaxBeanShell.setChanged(false);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            int index = this.editorContentList.indexOf(this.currentEditorContent);
            if (index > 0) {
                this.currentEditorContent = this.editorContentList.get(index - 1);
                try {
                    this.syntaxBeanShell.loadFromFile(this.currentEditorContent);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.updateEditorContentActions();
    }

    private void cmOpenFileActionPerformed(ActionEvent evt) {
        if (this.syntaxBeanShell.isChanged() && this.openedFile != null) {
            switch (MessageBox.show((Component)null, (String)this.stringManager.getString("save-file"), (String)String.format(this.stringManager.getString("BeanShellEditorPanelView-save-file-q"), this.openedFile.getName()), (int[])ModalResult.YESNOCANCEL)) {
                case 5: {
                    if (this.saveFile()) break;
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        this.openFile();
    }

    private void cmSaveFileAsActionPerformed(ActionEvent evt) {
        this.saveFileAs();
    }

    private void cmSaveFileActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private void cmRunActionPerformed(ActionEvent evt) {
        try {
            Object result = this.interpreter.eval(this.syntaxBeanShell.getText());
            if (result != null) {
                this.textResult.append("<" + result.toString() + ">\n");
            } else {
                this.textResult.append("Result: null\n");
            }
        }
        catch (Throwable ex) {
            this.textResult.append(ex.getMessage() + "\n");
        }
    }
}

