/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.IntrospectionException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.beanshell.OrbadaBeanshellPlugin;
import pl.mpak.orbada.beanshell.db.BshActionRecord;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.usedb.gui.swing.QueryComboBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class BshActionEditDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    private IApplication application;
    private int modalResult = 0;
    private BshActionRecord action;
    private RecordLink dataLink;
    private String bsha_id;
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkAllUsers;
    private Action cmCancel;
    private Action cmOk;
    private QueryComboBox comboDriverType;
    private TextField editKey;
    private TextField editName;
    private OrbadaJavaSyntaxTextArea editScript;
    private TextField editTooltip;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private Query queryDriverTypes;
    private TextField textShortcut;

    public BshActionEditDialog(IApplication application, String bsha_id, BshActionRecord action) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame(), true);
        this.application = application;
        this.bsha_id = bsha_id;
        this.action = action;
        this.initComponents();
        this.init();
    }

    public static String show(IApplication application, String bsha_id) throws IntrospectionException, UseDBException {
        BshActionEditDialog dialog = new BshActionEditDialog(application, bsha_id, null);
        dialog.setVisible(true);
        return dialog.modalResult == 1 ? dialog.bsha_id : null;
    }

    public static String show(IApplication application, String bsha_id, BshActionRecord action) throws IntrospectionException, UseDBException {
        BshActionEditDialog dialog = new BshActionEditDialog(application, bsha_id, action);
        dialog.setVisible(true);
        return dialog.modalResult == 1 ? dialog.bsha_id : null;
    }

    private void init() throws IntrospectionException, UseDBException {
        try {
            this.queryDriverTypes.open();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.settings = Application.get().getSettings("orbada-beanshell=action-edit-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dataLink = new RecordLink();
        this.dataLink.add("BSHA_TITLE", (Component)this.editName, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("action-title")));
        this.dataLink.add("BSHA_KEY", (Component)this.editKey, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("action-key")));
        this.dataLink.add("BSHA_TOOLTIP", (Component)this.editTooltip);
        this.dataLink.add("BSHA_DTP_ID", (Component)this.comboDriverType, "selectedItem");
        this.dataLink.add("BSHA_SCRIPT", (Component)this.editScript, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("beanshell-script")));
        if (this.action == null) {
            this.action = this.bsha_id != null ? new BshActionRecord(this.application.getOrbadaDatabase(), this.bsha_id) : new BshActionRecord(this.application.getOrbadaDatabase());
        }
        this.dataLink.updateComponents((BufferedRecord)this.action);
        this.checkAllUsers.setSelected(this.action.getUsrId() == null);
        if (!this.application.isUserAdmin()) {
            this.checkAllUsers.setEnabled(false);
            this.checkAllUsers.setSelected(true);
        }
        this.textShortcut.setText(SwingUtil.shortcutText((int)(this.action.getShortcutCode() != null ? this.action.getShortcutCode() : 0), (int)(this.action.getShortcutModifiers() != null ? this.action.getShortcutModifiers() : 0)));
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        this.queryDriverTypes.close();
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.queryDriverTypes = new Query();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.editName = new TextField();
        this.jLabel2 = new JLabel();
        this.comboDriverType = new QueryComboBox();
        this.jLabel3 = new JLabel();
        this.checkAllUsers = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.editKey = new TextField();
        this.jLabel5 = new JLabel();
        this.editTooltip = new TextField();
        this.jLabel6 = new JLabel();
        this.editScript = new OrbadaJavaSyntaxTextArea();
        this.textShortcut = new TextField();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BshActionEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BshActionEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.queryDriverTypes.setDatabase(this.application.getOrbadaDatabase());
        try {
            this.queryDriverTypes.setSqlText("select cast(null as varchar(40)) dtp_id, '<dla wszystkich>' dtp_name, 1 sort from dual\nunion all \nselect dtp_id, dtp_name, 2 sort from driver_types\norder by sort, dtp_name\n");
        }
        catch (UseDBException e1) {
            e1.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("BshActionEditDialog-title"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("action-title-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("for-driver-dd"));
        this.comboDriverType.setDisplayField("DTP_NAME");
        this.comboDriverType.setKeyField("DTP_ID");
        this.comboDriverType.setQuery(this.queryDriverTypes);
        this.jLabel3.setText(this.stringManager.getString("beanshell-script-dd"));
        this.checkAllUsers.setText(this.stringManager.getString("for-all-users"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("action-key-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("tooltip-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("shortcut-key-dd"));
        this.textShortcut.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                BshActionEditDialog.this.textShortcutKeyPressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.editScript, -1, 564, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.checkAllUsers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 223, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editName, -1, 429, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editKey, -1, 429, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editTooltip, -1, 429, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboDriverType, -1, 429, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textShortcut, -2, 171, -2)).addComponent(this.jLabel3)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.editName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.editKey, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.editTooltip, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.comboDriverType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textShortcut, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editScript, -1, 217, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.checkAllUsers)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.dataLink.updateRecord((BufferedRecord)this.action);
            if (this.checkAllUsers.isSelected()) {
                this.action.setUsrId(null);
            } else {
                this.action.setUsrId(this.application.getUserId());
            }
            if (this.action.isChanged()) {
                if (this.bsha_id == null) {
                    this.action.applyInsert();
                    this.bsha_id = this.action.getId();
                } else {
                    this.action.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void textShortcutKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 8 && !StringUtil.isEmpty((String)this.textShortcut.getText())) {
            this.textShortcut.setText("");
            this.action.setShortcutCode(null);
            this.action.setShortcutModifiers(null);
        } else {
            this.textShortcut.setText(SwingUtil.shortcutText((int)evt.getKeyCode(), (int)evt.getModifiers()));
            this.action.setShortcutCode(evt.getKeyCode());
            this.action.setShortcutModifiers(evt.getModifiers());
        }
        evt.consume();
    }
}

