/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.beanshell.OrbadaBeanshellPlugin;
import pl.mpak.orbada.beanshell.db.BshActionRecord;
import pl.mpak.orbada.beanshell.gui.BshActionEditDialog;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class BshActionsSettingsPanel
extends JPanel
implements ISettingsComponent,
Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    private IApplication application;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonExport;
    private JButton buttonImport;
    private JButton buttonNew;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmExport;
    private Action cmImport;
    private Action cmNew;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable tableBshActions;

    public BshActionsSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonEdit, this.buttonDelete, this.buttonExport, this.buttonImport});
        this.tableBshActions.getQuery().setDatabase(this.application.getOrbadaDatabase());
        this.tableBshActions.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void afterOpen(EventObject e) {
                BshActionsSettingsPanel.this.updateActions();
            }

            public void afterClose(EventObject e) {
                BshActionsSettingsPanel.this.updateActions();
            }
        });
        this.tableBshActions.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (BshActionsSettingsPanel.this.tableBshActions.getSelectedRow() >= 0) {
                    try {
                        BshActionsSettingsPanel.this.tableBshActions.getQuery().getRecord(BshActionsSettingsPanel.this.tableBshActions.getSelectedRow());
                        BshActionsSettingsPanel.this.updateActions();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    BshActionsSettingsPanel.this.cmEdit.setEnabled(false);
                    BshActionsSettingsPanel.this.cmDelete.setEnabled(false);
                }
            }
        });
        this.tableBshActions.addColumn((TableColumn)new QueryTableColumn("scope", this.stringManager.getString("scope"), 100));
        this.tableBshActions.addColumn((TableColumn)new QueryTableColumn("bsha_title", this.stringManager.getString("title"), 250, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableBshActions.addColumn((TableColumn)new QueryTableColumn("bsha_key", this.stringManager.getString("key"), 150));
        this.tableBshActions.addColumn((TableColumn)new QueryTableColumn("dtp_name", this.stringManager.getString("driver"), 150));
        this.refresh(null);
    }

    private void updateActions() {
        block5: {
            if (this.tableBshActions.getQuery().isActive() && this.tableBshActions.getSelectedRow() >= 0) {
                try {
                    if (this.tableBshActions.getQuery().fieldByName("bsha_usr_id").isNull()) {
                        this.cmEdit.setEnabled(this.application.isUserAdmin());
                        this.cmDelete.setEnabled(this.application.isUserAdmin());
                        break block5;
                    }
                    this.cmEdit.setEnabled(true);
                    this.cmDelete.setEnabled(true);
                }
                catch (Exception ex) {
                    this.cmEdit.setEnabled(false);
                    this.cmDelete.setEnabled(false);
                }
            } else {
                this.cmEdit.setEnabled(false);
                this.cmDelete.setEnabled(false);
            }
        }
        this.cmNew.setEnabled(this.tableBshActions.getQuery().isActive());
    }

    private void refresh(String gqi_id) {
        try {
            if (gqi_id == null && this.tableBshActions.getQuery().isActive() && this.tableBshActions.getSelectedRow() >= 0) {
                this.tableBshActions.getQuery().getRecord(this.tableBshActions.getSelectedRow());
                gqi_id = this.tableBshActions.getQuery().fieldByName("bsha_id").getString();
            }
            this.tableBshActions.getQuery().close();
            this.tableBshActions.getQuery().setSqlText("select bsha_id, bsha_usr_id, case when bsha_usr_id is null then 'Globalne' else 'U\u017cytkownika' end scope, bsha_title, bsha_key, dtp_name\n  from bshactions left outer join driver_types on (bsha_dtp_id = dtp_id)\n where (bsha_usr_id = :USR_ID or bsha_usr_id is null)\n order by bsha_title");
            this.tableBshActions.getQuery().paramByName("usr_id").setString(this.application.getUserId());
            this.tableBshActions.getQuery().open();
            if (gqi_id != null && this.tableBshActions.getQuery().locate("bsha_id", new Variant(gqi_id))) {
                this.tableBshActions.changeSelection(this.tableBshActions.getQuery().getCurrentRecord().getIndex(), 0, false, false);
            } else {
                this.tableBshActions.changeSelection(0, 0, false, false);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void restoreSettings() {
    }

    public void applySettings() {
        this.application.postPluginMessage(new PluginMessage(null, "bsh-actions-reload", null));
    }

    public void cancelSettings() {
    }

    public void close() throws IOException {
        this.tableBshActions.getQuery().close();
    }

    private void initComponents() {
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.cmExport = new Action();
        this.cmImport = new Action();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableBshActions = new ViewTable();
        this.buttonExport = new JButton();
        this.buttonImport = new JButton();
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(this.stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BshActionsSettingsPanel.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(this.stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BshActionsSettingsPanel.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(this.stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BshActionsSettingsPanel.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmExport.setActionCommandKey("cmExport");
        this.cmExport.setText(this.stringManager.getString("cmExport-text"));
        this.cmExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BshActionsSettingsPanel.this.cmExportActionPerformed(evt);
            }
        });
        this.cmImport.setActionCommandKey("cmImport");
        this.cmImport.setText(this.stringManager.getString("cmImport-text"));
        this.cmImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BshActionsSettingsPanel.this.cmImportActionPerformed(evt);
            }
        });
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setText(this.stringManager.getString("BshActionsSettingsPanel-action-script-info"));
        this.jScrollPane1.setViewportView((Component)this.tableBshActions);
        this.buttonExport.setAction((javax.swing.Action)this.cmExport);
        this.buttonExport.setMargin(new Insets(2, 2, 2, 2));
        this.buttonExport.setPreferredSize(new Dimension(85, 25));
        this.buttonImport.setAction((javax.swing.Action)this.cmImport);
        this.buttonImport.setMargin(new Insets(2, 2, 2, 2));
        this.buttonImport.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonExport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonImport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 89, Short.MAX_VALUE).addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 532, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, 532, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 314, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2).addComponent(this.buttonExport, -2, -1, -2).addComponent(this.buttonImport, -2, -1, -2)).addContainerGap()));
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            String gqi_id;
            if (this.tableBshActions.getQuery().isActive() && (gqi_id = BshActionEditDialog.show(this.application, null)) != null) {
                this.refresh(gqi_id);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableBshActions.getQuery().isActive() && this.tableBshActions.getSelectedRow() >= 0) {
                this.tableBshActions.getQuery().getRecord(this.tableBshActions.getSelectedRow());
                String bsha_id = BshActionEditDialog.show(this.application, this.tableBshActions.getQuery().fieldByName("bsha_id").getString());
                if (bsha_id != null) {
                    this.refresh(bsha_id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        try {
            if (this.tableBshActions.getQuery().isActive() && this.tableBshActions.getSelectedRow() >= 0) {
                this.tableBshActions.getQuery().getRecord(this.tableBshActions.getSelectedRow());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("BshActionsSettingsPanel-del-action-q"), this.tableBshActions.getQuery().fieldByName("bsha_title").getString()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    BshActionRecord action = new BshActionRecord(this.application.getOrbadaDatabase());
                    action.setPrimaryKeyValue(new Variant(this.tableBshActions.getQuery().fieldByName("bsha_id").getString()));
                    action.applyDelete();
                    this.refresh(null);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmExportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableBshActions.getQuery().isActive() && this.tableBshActions.getSelectedRow() >= 0) {
                this.tableBshActions.getQuery().getRecord(this.tableBshActions.getSelectedRow());
                File file = FileUtil.selectFileToSave((Component)this, (String)this.stringManager.getString("save-action-script"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("bshaction-files"), new String[]{".xml.bshaction"})});
                if (file != null) {
                    BshActionRecord action = new BshActionRecord(this.application.getOrbadaDatabase(), this.tableBshActions.getQuery().fieldByName("bsha_id").getString());
                    action.storeToXML(new FileOutputStream(file), null, "utf-8");
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmImportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableBshActions.getQuery().isActive() && this.tableBshActions.getSelectedRow() >= 0) {
                this.tableBshActions.getQuery().getRecord(this.tableBshActions.getSelectedRow());
                File file = FileUtil.selectFileToOpen((Component)this, (String)this.stringManager.getString("open-action-script"), (File)null, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("bshaction-files"), new String[]{".xml.bshaction"})});
                if (file != null) {
                    String bsha_id;
                    BshActionRecord action = new BshActionRecord(this.application.getOrbadaDatabase());
                    action.loadFromXML(new FileInputStream(file));
                    action.setId(new UniqueID().toString());
                    if (!this.application.isUserAdmin() || action.getUsrId() != null) {
                        action.setUsrId(this.application.getUserId());
                    }
                    if ((bsha_id = BshActionEditDialog.show(this.application, null, action)) != null) {
                        this.refresh(bsha_id);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

