/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.beanshell.OrbadaBeanshellPlugin;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class StartupShutdownSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    private IApplication application;
    private File startupFile = OrbadaBeanshellPlugin.getStartupFile();
    private File shutdownFile = OrbadaBeanshellPlugin.getShutdownFile();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private OrbadaJavaSyntaxTextArea textShutdown;
    private OrbadaJavaSyntaxTextArea textStartup;

    public StartupShutdownSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.restoreSettings();
    }

    public void restoreSettings() {
        if (this.startupFile.exists()) {
            try {
                this.textStartup.loadFromFile(this.startupFile);
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
                this.textStartup.setText("");
            }
        } else {
            this.textStartup.setText("");
        }
        if (this.shutdownFile.exists()) {
            try {
                this.textShutdown.loadFromFile(this.shutdownFile);
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
                this.textShutdown.setText("");
            }
        } else {
            this.textShutdown.setText("");
        }
    }

    public void applySettings() {
        try {
            this.textStartup.saveToFile(this.startupFile);
            this.textShutdown.saveToFile(this.shutdownFile);
        }
        catch (IOException ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textStartup = new OrbadaJavaSyntaxTextArea();
        this.jLabel2 = new JLabel();
        this.textShutdown = new OrbadaJavaSyntaxTextArea();
        this.jLabel1.setText(this.stringManager.getString("bsh-startup-dd"));
        this.jLabel2.setText(this.stringManager.getString("bsh-shutdown-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.textShutdown, GroupLayout.Alignment.LEADING, -1, 485, Short.MAX_VALUE).addComponent((Component)this.textStartup, GroupLayout.Alignment.LEADING, -1, 485, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textStartup, -1, 181, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textShutdown, -1, 173, Short.MAX_VALUE).addContainerGap()));
    }
}

