/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell.services;

import bsh.EvalError;
import pl.mpak.orbada.beanshell.BeanShellInterpreter;
import pl.mpak.orbada.beanshell.OrbadaBeanshellPlugin;
import pl.mpak.orbada.universal.providers.UniversalSqlTextTransformProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class BeanshellSqlTextTransformProvider
extends UniversalSqlTextTransformProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    private BeanShellInterpreter interpreter;

    public boolean isForDatabase(Database database) {
        return true;
    }

    public String transformSqlText(Database database, String sqlText) {
        int start;
        if (this.interpreter == null) {
            this.interpreter = new BeanShellInterpreter(database);
        }
        if ((start = sqlText.toUpperCase().indexOf("BEANSHELL")) >= 0) {
            while (start >= 0) {
                char ch;
                int end;
                boolean found = false;
                for (end = start + 9; end < sqlText.length() && Character.isSpaceChar(ch = sqlText.charAt(end)); ++end) {
                }
                if (end < sqlText.length() && sqlText.charAt(end) == '{') {
                    int rounds = 0;
                    while (end < sqlText.length()) {
                        char ch2 = sqlText.charAt(end);
                        if (ch2 == '{') {
                            ++rounds;
                        } else if (ch2 == '}') {
                            if (--rounds == 0) {
                                ++end;
                                found = true;
                                break;
                            }
                        } else if (ch2 == '\"') {
                            ++end;
                            while (end < sqlText.length() && (sqlText.charAt(end) != '\"' || sqlText.charAt(end - 1) == '\\')) {
                                ++end;
                            }
                        }
                        ++end;
                    }
                    if (found) {
                        try {
                            String toEval = sqlText.substring(start + 9, end);
                            toEval = toEval.substring(toEval.indexOf(123) + 1, toEval.lastIndexOf(125));
                            Object result = this.interpreter.eval(toEval);
                            if (start == 0) {
                                if (result != null) {
                                    MessageBox.show((String)this.stringManager.getString("result"), (String)result.toString(), (int)1);
                                }
                                return "";
                            }
                            if (result != null) {
                                String newSqlText = sqlText.substring(0, start);
                                newSqlText = newSqlText + result.toString();
                                sqlText = newSqlText + sqlText.substring(end);
                            }
                        }
                        catch (EvalError ex) {
                            MessageBox.show((String)this.stringManager.getString("beanshell-error"), (String)ex.getMessage(), (int)1);
                            return "";
                        }
                    }
                }
                if (!found) {
                    start = sqlText.toUpperCase().indexOf("BEANSHELL", start + 9);
                    continue;
                }
                start = sqlText.toUpperCase().indexOf("BEANSHELL");
            }
            return sqlText;
        }
        return null;
    }

    public String getDescription() {
        return this.stringManager.getString("BeanshellSqlTextTransformProvider-description");
    }

    public String getGroupName() {
        return "Orbada Tools";
    }
}

