/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell.services;

import java.util.ArrayList;
import pl.mpak.orbada.beanshell.OrbadaBeanshellPlugin;
import pl.mpak.orbada.beanshell.db.BshActionRecord;
import pl.mpak.orbada.beanshell.services.cm.BshComponentAction;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.IProcessMessagable;
import pl.mpak.orbada.plugins.providers.ComponentActionsProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.task.Task;

public class BshComponentActionsProvider
extends ComponentActionsProvider
implements IProcessMessagable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    private ArrayList<BshActionRecord> actionList = new ArrayList();
    private boolean inited = false;

    public void setApplication(IApplication application) {
        this.application = application;
        this.application.registerRequestMessager((IProcessMessagable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadActions() {
        ArrayList<BshActionRecord> arrayList = this.actionList;
        synchronized (arrayList) {
            this.actionList.clear();
            Query query = this.application.getOrbadaDatabase().createQuery();
            try {
                query.setSqlText("select * from bshactions where (bsha_usr_id is null or bsha_usr_id = :USR_ID)");
                query.paramByName("USR_ID").setString(this.application.getUserId());
                query.open();
                while (!query.eof()) {
                    BshActionRecord action = new BshActionRecord(this.application.getOrbadaDatabase());
                    action.updateFrom(query);
                    this.actionList.add(action);
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
        }
    }

    public boolean isForDatabase(Database database) {
        return database != null;
    }

    public String getDescription() {
        return this.stringManager.getString("BshComponentActionsProvider-description");
    }

    public String getGroupName() {
        return "Orbada Tools";
    }

    public void processMessage(PluginMessage message) {
        if (message.isMessageId("bsh-actions-reload")) {
            this.application.getOrbadaDatabase().getTaskPool().addTask(new Task(){

                public void run() {
                    BshComponentActionsProvider.this.reloadActions();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentAction[] getForComponent(Database database, String actionType) {
        ArrayList<BshComponentAction> actions = new ArrayList<BshComponentAction>();
        if (!this.inited) {
            this.reloadActions();
            this.inited = true;
        }
        ArrayList<BshActionRecord> arrayList = this.actionList;
        synchronized (arrayList) {
            for (BshActionRecord action : this.actionList) {
                if (!actionType.equals(action.getKey()) || !StringUtil.isEmpty((String)action.getDtpId()) && !action.getDtpId().equals(database.getUserProperties().get("dtp_id"))) continue;
                actions.add(new BshComponentAction(action));
            }
        }
        if (actions.size() > 0) {
            return actions.toArray(new BshComponentAction[actions.size()]);
        }
        return null;
    }
}

