/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.beanshell.services.cm;

import bsh.EvalError;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.beanshell.BeanShellInterpreter;
import pl.mpak.orbada.beanshell.OrbadaBeanshellPlugin;
import pl.mpak.orbada.beanshell.db.BshActionRecord;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class BshComponentAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaBeanshellPlugin.class);
    private BshActionRecord action;

    public BshComponentAction(BshActionRecord action) {
        super(action.getTitle());
        int modf;
        this.action = action;
        if (!StringUtil.isEmpty((String)action.getTooltip())) {
            this.setTooltip(action.getTooltip());
        }
        int code = action.getShortcutCode() != null ? action.getShortcutCode() : 0;
        int n = modf = action.getShortcutModifiers() != null ? action.getShortcutModifiers() : 0;
        if (code > 0 || modf > 0) {
            this.setShortCut(code, modf);
        }
        this.setActionCommandKey("cmBshComponent");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BeanShellInterpreter interpreter = new BeanShellInterpreter(BshComponentAction.this.database);
                try {
                    interpreter.set("component", BshComponentAction.this.getComponent());
                    interpreter.eval(BshComponentAction.this.action.getScript());
                }
                catch (EvalError ex) {
                    MessageBox.show((Component)SwingUtil.getRootFrame(), (String)BshComponentAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                }
            }
        };
    }
}

