/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbObjectContainer<T extends DbObjectIdentified>
extends DbObjectIdentified {
    protected HashMap<String, T> objectList = new HashMap();

    public DbObjectContainer(String name, DbObjectIdentified owner, boolean refreshed) {
        this(name, owner);
        this.setRefreshed(refreshed);
    }

    public DbObjectContainer(String name, DbObjectIdentified owner) {
        super(name, owner);
    }

    public T put(T item) {
        return this.put(((DbObjectIdentified)item).getName(), item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T put(String name, T item) {
        HashMap<String, T> hashMap = this.objectList;
        synchronized (hashMap) {
            this.objectList.put(name, item);
            return item;
        }
    }

    public abstract String[] getColumnNames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshThis() {
        HashMap<String, T> hashMap = this.objectList;
        synchronized (hashMap) {
            if (!this.isRefreshed() && !this.isRefreshing()) {
                try {
                    this.refresh();
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
    }

    public T get(String name) {
        this.refreshThis();
        return (T)((DbObjectIdentified)this.objectList.get(name));
    }

    public Iterator<T> objects() {
        this.refreshThis();
        return this.objectList.values().iterator();
    }

    public Iterator<String> names() {
        this.refreshThis();
        return this.objectList.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] namesArray() {
        HashMap<String, T> hashMap = this.objectList;
        synchronized (hashMap) {
            String[] array = new String[this.size()];
            Iterator<String> i = this.names();
            int c = 0;
            while (i.hasNext()) {
                array[c++] = i.next();
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbObjectIdentified[] objectsArray() {
        HashMap<String, T> hashMap = this.objectList;
        synchronized (hashMap) {
            DbObjectIdentified[] array = new DbObjectIdentified[this.size()];
            Iterator<T> i = this.objects();
            int c = 0;
            while (i.hasNext()) {
                array[c++] = (DbObjectIdentified)i.next();
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbObjectIdentified[] objectsArray(boolean sortedByName) {
        HashMap<String, T> hashMap = this.objectList;
        synchronized (hashMap) {
            Object[] array = this.objectsArray();
            if (sortedByName) {
                Arrays.sort(array);
            }
            return array;
        }
    }

    public int size() {
        this.refreshThis();
        return this.objectList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<String, T> hashMap = this.objectList;
        synchronized (hashMap) {
            this.objectList.clear();
        }
    }

    @Override
    public DbObjectIdentified getObjectInfo(StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            DbObjectIdentified o = null;
            if ("..".equals(token)) {
                o = this.getOwner();
            } else if (".".equals(token)) {
                o = this;
            } else if (token.indexOf(63) >= 0) {
                o = this.get(token.substring(0, token.indexOf(63)));
                if (o != null) {
                    o.setRefreshed(false);
                    o.setFilter(token.substring(token.indexOf(63) + 1, token.length()));
                }
            } else {
                o = this.get(token);
            }
            if (o != null) {
                return o.getObjectInfo(tokenizer);
            }
            return null;
        }
        return this;
    }
}

