/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo;

import java.util.StringTokenizer;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectInfo;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbObjectIdentified
implements Comparable<DbObjectIdentified> {
    private volatile boolean refreshed;
    private volatile boolean refreshing;
    private String name;
    private String remarks;
    private DbObjectIdentified owner;
    private String filter;

    public DbObjectIdentified(String name) {
        this(name, null);
    }

    public DbObjectIdentified(String name, DbObjectIdentified owner) {
        this.name = name;
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public DbObjectIdentified getOwner() {
        return this.owner;
    }

    public abstract String[] getMemberNames();

    public abstract Variant[] getMemberValues();

    public abstract void refresh() throws Exception;

    public void saveRefresh() {
        try {
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public void setRefreshed(boolean refreshed) {
        this.refreshed = refreshed;
        this.refreshing = false;
    }

    public DbObjectIdentified getObjectInfo(String path) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, "/\\");
        return this.getObjectInfo(st);
    }

    public DbObjectIdentified getObjectInfo(StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            return null;
        }
        return this;
    }

    public String getPath() {
        if (this.getOwner() != null) {
            return this.getOwner().getPath() + "/" + this.getName();
        }
        return "/";
    }

    public Database getDatabase() {
        DbObjectIdentified o = this.getOwner(DbDatabaseInfo.class);
        if (o != null) {
            return o.getDatabase();
        }
        return null;
    }

    public DbObjectIdentified getOwner(Class<? extends DbObjectIdentified> classOwner) {
        for (DbObjectIdentified o = this.getOwner(); o != null; o = o.getOwner()) {
            if (!classOwner.isInstance(o)) continue;
            return o;
        }
        return null;
    }

    public DbObjectInfo getObjectOwner() {
        for (DbObjectIdentified o = this.getOwner(); o != null; o = o.getOwner()) {
            if (!(o instanceof DbObjectInfo)) continue;
            return (DbObjectInfo)((Object)o);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(DbObjectIdentified o) {
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.getName().equals(o);
        }
        if (o instanceof DbObjectIdentified) {
            return this.getName().equals(((DbObjectIdentified)o).getName());
        }
        return super.equals(o);
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 61 * hash + (this.owner != null ? this.owner.hashCode() : 0);
        return hash;
    }
}

