/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbFunctionListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbIndexListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbProcedureListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableTypeListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTypeListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbViewListInfo;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.variant.Variant;

public class JdbcDbDatabaseInfo
extends DbDatabaseInfo {
    public JdbcDbDatabaseInfo(Database database) {
        super(database);
    }

    public String[] getColumnNames() {
        return new String[0];
    }

    public String[] getMemberNames() {
        return new String[]{"Version", "Banner"};
    }

    public Variant[] getMemberValues() {
        return new Variant[]{new Variant(this.getVersion()), new Variant(this.getBanner())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            this.setVersion(this.getDatabase().getMetaData().getDatabaseProductVersion());
            this.setBanner("Database: " + this.getDatabase().getMetaData().getDatabaseProductName() + ", " + this.getDatabase().getMetaData().getDatabaseProductVersion() + "\n" + "Driver: " + this.getDatabase().getMetaData().getDriverName() + ", " + this.getDatabase().getMetaData().getDriverVersion());
            this.setRemarks(this.getBanner());
            String[] schemaArray = this.getDatabase().getSchemaArray();
            if (schemaArray == null || schemaArray.length == 0) {
                this.put(new JdbcDbTableListInfo(this));
                this.put(new JdbcDbViewListInfo(this));
                this.put(new JdbcDbFunctionListInfo(this));
                this.put(new JdbcDbProcedureListInfo(this));
                this.put(new JdbcDbIndexListInfo(this));
            } else {
                this.put(new JdbcDbSchemaListInfo(this));
            }
            this.put(new JdbcDbTableTypeListInfo(this));
            this.put(new JdbcDbTypeListInfo(this));
        }
        finally {
            this.setRefreshed(true);
        }
    }

    public String getDescription() {
        return "Universal Jdbc Database Info Provider";
    }
}

