/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.DefaultDbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DefaultDbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbFunctionListInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbFunctionParameterInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbPrivilegeInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

public class JdbcDbFunctionInfo
extends DbObjectContainer {
    private String objectName;
    private String catalog;

    public JdbcDbFunctionInfo(String name, JdbcDbFunctionListInfo owner) {
        super(name, owner);
        this.put(new DefaultDbObjectContainer<JdbcDbFunctionParameterInfo>("PARAMETERS", (DbObjectIdentified)this){

            @Override
            public String[] getColumnNames() {
                return new String[]{"Pozycja", "Type", "Metoda", "Komentarz"};
            }
        });
        this.put(new DefaultDbObjectContainer<JdbcDbPrivilegeInfo>("PRIVILEGES", (DbObjectIdentified)this){

            @Override
            public String[] getColumnNames() {
                return new String[]{"Nada\u0142", "Dla", "Admin"};
            }
        });
        this.put(new DefaultDbObjectIdentified("CALL", this));
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String[] getColumnNames() {
        return new String[0];
    }

    public String[] getMemberNames() {
        return new String[]{"Katalog", "Komentarz"};
    }

    public Variant[] getMemberValues() {
        return new Variant[]{new Variant(this.getCatalog()), new Variant(this.getRemarks())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            DbObjectContainer params = (DbObjectContainer)this.get("PARAMETERS");
            params.setRefreshing(true);
            params.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getFunctionColumns(this.getCatalog(), schema == null ? null : schema.getName(), this.getObjectName(), null));
                while (!query.eof()) {
                    JdbcDbFunctionParameterInfo param = new JdbcDbFunctionParameterInfo(query.fieldByName("COLUMN_NAME").getString(), this);
                    if (query.fieldByName("COLUMN_TYPE").getInteger() == 3) {
                        param.setInOutReturn("{result}");
                    } else if (query.fieldByName("COLUMN_TYPE").getInteger() == 5) {
                        param.setInOutReturn("{return}");
                    } else if (query.fieldByName("COLUMN_TYPE").getInteger() == 1) {
                        param.setInOutReturn("IN");
                    } else if (query.fieldByName("COLUMN_TYPE").getInteger() == 4) {
                        param.setInOutReturn("OUT");
                    } else if (query.fieldByName("COLUMN_TYPE").getInteger() == 2) {
                        param.setInOutReturn("IN/OUT");
                    } else {
                        param.setInOutReturn("{unknown}");
                    }
                    param.setType(query.fieldByName("TYPE_NAME").getString());
                    param.setRemarks(query.fieldByName("remarks").getString());
                    params.put(param);
                    query.next();
                }
            }
            finally {
                query.close();
                params.setRefreshed(true);
            }
            DbObjectContainer privileges = (DbObjectContainer)this.get("PRIVILEGES");
            privileges.setRefreshing(true);
            privileges.clear();
            try {
                query.setResultSet(this.getDatabase().getMetaData().getTablePrivileges(this.getCatalog(), this.getSchema().getName(), this.getObjectName()));
                while (!query.eof()) {
                    JdbcDbPrivilegeInfo privilege = new JdbcDbPrivilegeInfo(query.fieldByName("PRIVILEGE").getString(), this);
                    privilege.setGrantor(query.fieldByName("GRANTOR").getString());
                    privilege.setGrantee(query.fieldByName("GRANTEE").getString());
                    privilege.setGrantable(query.fieldByName("IS_GRANTABLE").getString());
                    privileges.put(privilege);
                    query.next();
                }
            }
            finally {
                query.close();
                privileges.setRefreshing(true);
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

