/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbIndexInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDbIndexListInfo
extends DbObjectContainer<JdbcDbIndexInfo> {
    public JdbcDbIndexListInfo(DbObjectIdentified owner) {
        super("INDEXES", owner);
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Tabela", "Pozycja", "Nazwa kolumny", "Unikalny", "AscDesc"};
    }

    @Override
    public String[] getMemberNames() {
        return new String[0];
    }

    @Override
    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getIndexInfo(schema == null ? null : schema.getCatalog(), schema == null ? null : schema.getName(), "%", false, false));
                while (!query.eof()) {
                    JdbcDbIndexInfo index = new JdbcDbIndexInfo(query.fieldByName("index_name").getString(), this);
                    index.setTableName(query.fieldByName("table_name").getString());
                    index.setColumnName(query.fieldByName("column_name").getString());
                    index.setPosition(query.fieldByName("ordinal_position").getInteger());
                    if ("A".equals(query.fieldByName("asc_or_desc").getString())) {
                        index.setAscDesc("ASC");
                    } else if ("D".equals(query.fieldByName("asc_or_desc").getString())) {
                        index.setAscDesc("DESC");
                    } else {
                        index.setAscDesc("");
                    }
                    index.setUnique(!query.fieldByName("non_unique").getBoolean());
                    this.put(index.getName() + "." + index.getColumnName(), index);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

