/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbProcedureInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDbProcedureListInfo
extends DbObjectContainer<JdbcDbProcedureInfo> {
    public JdbcDbProcedureListInfo(DbObjectIdentified owner) {
        super("PROCEDURES", owner);
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Katalog", "Komentarz"};
    }

    @Override
    public String[] getMemberNames() {
        return new String[0];
    }

    @Override
    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getProcedures(schema == null ? null : schema.getCatalog(), schema == null ? null : schema.getName(), null));
                while (!query.eof()) {
                    String name = query.fieldByName("procedure_name").getString();
                    if (!StringUtil.isEmpty((String)query.fieldByName("procedure_cat").getString())) {
                        name = query.fieldByName("procedure_cat").getString() + "." + name;
                    }
                    JdbcDbProcedureInfo proc = new JdbcDbProcedureInfo(name, this);
                    proc.setObjectName(query.fieldByName("procedure_name").getString());
                    proc.setCatalog(query.fieldByName("procedure_cat").getString());
                    proc.setRemarks(query.fieldByName("remarks").getString());
                    this.put(proc);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

