/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableColumnInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDbTableColumnListInfo
extends DbObjectContainer<JdbcDbTableColumnInfo> {
    public JdbcDbTableColumnListInfo(JdbcDbTableInfo owner) {
        super("COLUMNS", owner);
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    public JdbcDbTableInfo getTable() {
        DbObjectIdentified o = this.getOwner(JdbcDbTableInfo.class);
        if (o != null) {
            return (JdbcDbTableInfo)o;
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Pozycja", "Typ", "Rozmiar", "Prec.", "Null?", "Warto\u015b\u0107 domy\u015blna", "Komentarz"};
    }

    @Override
    public String[] getMemberNames() {
        return new String[0];
    }

    @Override
    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getColumns(this.getTable().getCatalog(), schema == null ? null : schema.getName(), this.getTable().getObjectName(), "%"));
                while (!query.eof()) {
                    JdbcDbTableColumnInfo column = new JdbcDbTableColumnInfo(query.fieldByName("column_name").getString(), this);
                    column.setDefaultValue(query.fieldByName("column_def").getString());
                    column.setPosition(query.fieldByName("ordinal_position").getInteger());
                    column.setDataType(query.fieldByName("type_name").getString());
                    column.setDataSize(query.fieldByName("column_size").getInteger());
                    if (!query.fieldByName("decimal_digits").isNull()) {
                        column.setDigits(query.fieldByName("decimal_digits").getInteger());
                    }
                    column.setNullable(query.fieldByName("nullable").getInteger() == 1);
                    column.setRemarks(query.fieldByName("remarks").getString());
                    this.put(column);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

